/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io.xml;

import com.fr.base.core.FRCoreContext;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.core.headerfooter.DateHFElement;
import com.fr.report.core.headerfooter.FormulaHFElement;
import com.fr.report.core.headerfooter.HFElement;
import com.fr.report.core.headerfooter.ImageHFElement;
import com.fr.report.core.headerfooter.ParameterHFElement;
import com.fr.report.core.headerfooter.TextHFElement;
import com.fr.report.io.xml.ReportXMLUtils;

public class HFElementXML {
    public static void writeXML(XMLPrintWriter xMLPrintWriter, HFElement hFElement) {
        ImageHFElement imageHFElement;
        xMLPrintWriter.startTAG("HFElement").attr("className", hFElement.getClass().getName());
        if (hFElement instanceof FormulaHFElement) {
            FormulaHFElement formulaHFElement = (FormulaHFElement)hFElement;
            if (formulaHFElement.getFRFont() != null) {
                BaseXMLUtils.writeFRFont(xMLPrintWriter, formulaHFElement.getFRFont());
            }
            if (formulaHFElement.getFormulaContent() != null) {
                xMLPrintWriter.startTAG("Formula").attr("content", formulaHFElement.getFormulaContent()).end();
            }
        } else if (hFElement instanceof DateHFElement) {
            DateHFElement dateHFElement = (DateHFElement)hFElement;
            if (dateHFElement.getFRFont() != null) {
                BaseXMLUtils.writeFRFont(xMLPrintWriter, dateHFElement.getFRFont());
            }
            if (dateHFElement.getFormat() != null) {
                ReportXMLUtils.writeFormat(xMLPrintWriter, dateHFElement.getFormat());
            }
        } else if (hFElement instanceof TextHFElement) {
            TextHFElement textHFElement = (TextHFElement)hFElement;
            if (textHFElement.getFRFont() != null) {
                BaseXMLUtils.writeFRFont(xMLPrintWriter, textHFElement.getFRFont());
            }
            xMLPrintWriter.textNode(textHFElement.getText());
        } else if (hFElement instanceof ImageHFElement && (imageHFElement = (ImageHFElement)hFElement).getImage() != null) {
            BaseXMLUtils.writeImage(xMLPrintWriter, imageHFElement.getImage());
        }
        xMLPrintWriter.end();
    }

    public static HFElement readXML(XMLableReader xMLableReader) {
        HFElement hFElement = null;
        String string = null;
        string = xMLableReader.getAttr("className");
        if (string != null) {
            try {
                hFElement = (HFElement)FRCoreContext.classForName(string).newInstance();
            }
            catch (Exception exception) {
                try {
                    hFElement = (HFElement)FRCoreContext.classForName("com.fr.report.core.headerfooter." + string).newInstance();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (hFElement == null) {
            return hFElement;
        }
        if (hFElement instanceof DateHFElement) {
            final DateHFElement dateHFElement = (DateHFElement)hFElement;
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        String string = xMLableReader.getTagName();
                        if (BaseXMLUtils.isFRFontTagName(string)) {
                            dateHFElement.setFRFont(BaseXMLUtils.readFRFont(xMLableReader));
                        } else if (string.equals("Format")) {
                            dateHFElement.setFormat(ReportXMLUtils.readFormat(xMLableReader));
                        }
                    }
                }
            });
        } else if (hFElement instanceof TextHFElement) {
            final TextHFElement textHFElement = (TextHFElement)hFElement;
            XMLObject xMLObject = new XMLObject(null){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isCharacters()) {
                        textHFElement.setText(xMLableReader.getContent());
                    } else if (xMLableReader.isChildNode()) {
                        String string = xMLableReader.getTagName();
                        if (BaseXMLUtils.isFRFontTagName(string)) {
                            textHFElement.setFRFont(BaseXMLUtils.readFRFont(xMLableReader));
                        } else if ("Formula".equals(string)) {
                            String string2 = xMLableReader.getAttr("content");
                            if (string2 != null) {
                                ((FormulaHFElement)textHFElement).setFormulaContent(string2);
                            }
                        } else if ("Parameter".equals(string)) {
                            ((ParameterHFElement)textHFElement).setParameter(ReportXMLUtils.readParameter(xMLableReader));
                            this.obj = new FormulaHFElement("=$" + ReportXMLUtils.readParameter(xMLableReader).getName());
                            ((TextHFElement)this.obj).setText(textHFElement.getText());
                            ((TextHFElement)this.obj).setFRFont(textHFElement.getFRFont());
                        }
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            if (xMLObject.getObject() != null) {
                hFElement = (HFElement)xMLObject.getObject();
            }
        } else if (hFElement instanceof ImageHFElement) {
            final ImageHFElement imageHFElement = (ImageHFElement)hFElement;
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.getTagName().equals("Image")) {
                        imageHFElement.setImage(BaseXMLUtils.readImage(xMLableReader));
                    }
                }
            });
        }
        return hFElement;
    }
}

