/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io.xml;

import com.fr.base.FRContext;
import com.fr.base.NameStyle;
import com.fr.base.Painter;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.XMLable;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ChartCollection;
import com.fr.chart.ChartPainter;
import com.fr.chart.core.ChartXMLCompatibleUtils;
import com.fr.chart.core.FoldLine;
import com.fr.chart.core.Glyph;
import com.fr.chart.core.LineGlyph;
import com.fr.chart.core.glyph.CategoryAxis3DGlyph;
import com.fr.chart.core.glyph.CategoryAxisGlyph;
import com.fr.chart.core.glyph.CompositeGlyph;
import com.fr.chart.core.glyph.RadarAxisGlyph;
import com.fr.chart.core.glyph.ShapeGlyph;
import com.fr.chart.core.glyph.TextGlyph;
import com.fr.chart.core.glyph.ValueAxis3DGlyph;
import com.fr.chart.core.glyph.ValueAxisGlyph;
import com.fr.chart.shape3d.Area3D;
import com.fr.chart.shape3d.Cubic;
import com.fr.chart.shape3d.Cylinder;
import com.fr.chart.shape3d.FoldLine3D;
import com.fr.chart.shape3d.Pie3D;
import com.fr.data.ChartData;
import com.fr.data.DMLConfigJob;
import com.fr.data.SubmitJob;
import com.fr.data.core.define.FilterDefinition;
import com.fr.data.core.define.MoreNameCDDefinition;
import com.fr.data.core.define.OneValueCDDefinition;
import com.fr.data.core.define.ReportDataDefinition;
import com.fr.data.core.define.TopDefinition;
import com.fr.data.impl.ReportChartData;
import com.fr.data.impl.TableChartData;
import com.fr.data.impl.TableColumn;
import com.fr.data.impl.TopChartData;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.Report;
import com.fr.report.WorkSheet;
import com.fr.report.cellElement.BarcodePresent;
import com.fr.report.cellElement.DefaultPresent;
import com.fr.report.cellElement.DictPresent;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.FormulaPresent;
import com.fr.report.cellElement.Present;
import com.fr.report.cellElement.TextFormat;
import com.fr.report.cellElement.core.ConditionGroup;
import com.fr.report.cellElement.core.CustomGrouper;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.cellElement.core.FunctionGrouper;
import com.fr.report.cellElement.core.IndexGrouper;
import com.fr.report.cellElement.core.MonoGrouper;
import com.fr.report.cellElement.core.RecordGrouper;
import com.fr.report.cellElement.core.ResultSubReport;
import com.fr.report.cellElement.core.SubReport;
import com.fr.report.cellElement.core.SummaryGrouper;
import com.fr.report.highlight.BackgroundHighlightAction;
import com.fr.report.highlight.BorderHighlightAction;
import com.fr.report.highlight.ColWidthHighlightAction;
import com.fr.report.highlight.DefaultHighlight;
import com.fr.report.highlight.FRFontHighlightAction;
import com.fr.report.highlight.ForegroundHighlightAction;
import com.fr.report.highlight.Highlight;
import com.fr.report.highlight.HighlightAction;
import com.fr.report.highlight.HyperlinkHighlightAction;
import com.fr.report.highlight.PaddingHighlightAction;
import com.fr.report.highlight.PageHighlightAction;
import com.fr.report.highlight.PresentHighlightAction;
import com.fr.report.highlight.RowHeightHighlightAction;
import com.fr.report.highlight.ValueHighlightAction;
import com.fr.report.highlight.WidgetHighlightAction;
import com.fr.report.io.xml.SynchronizedNameWidget;
import com.fr.report.io.xml.SynchronizedStyleList;
import com.fr.report.js.EmailHyperlink;
import com.fr.report.js.JavaScript;
import com.fr.report.js.ReportletHyperlink;
import com.fr.report.js.WebHyperlink;
import com.fr.report.painter.BiasTextPainter;
import com.fr.report.painter.shape.IssoscelesTriangleShapePainter;
import com.fr.report.painter.shape.LineShapePainter;
import com.fr.report.painter.shape.OvalShapePainter;
import com.fr.report.painter.shape.RectangleShapePainter;
import com.fr.report.painter.shape.RoundedRectangleShapePainter;
import com.fr.report.painter.shape.ShapePainter;
import com.fr.report.parameter.ClassParameterProcessor;
import com.fr.report.parameter.CustomParameterUI;
import com.fr.report.parameter.Parameter;
import com.fr.report.parameter.ParameterProcessor;
import com.fr.report.parameter.ParameterUI;
import com.fr.report.parameter.processor.FormulaUnitProcessor;
import com.fr.report.parameter.processor.SQLQueryUnitProcessor;
import com.fr.report.parameter.processor.UnitProcessor;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FArray;
import com.fr.report.web.ui.Button;
import com.fr.report.web.ui.ComboBox;
import com.fr.report.web.ui.ComboCheckBox;
import com.fr.report.web.ui.CustomButton;
import com.fr.report.web.ui.DateEditor;
import com.fr.report.web.ui.DateTimeEditor;
import com.fr.report.web.ui.FieldEditor;
import com.fr.report.web.ui.FileEditor;
import com.fr.report.web.ui.NumberEditor;
import com.fr.report.web.ui.TextEditor;
import com.fr.report.web.ui.Widget;
import com.fr.report.web.ui.impl.form.FormResetButton;
import com.fr.report.web.ui.impl.form.FormSubmitButton;
import com.fr.report.write.config.DMLConfig;
import com.fr.report.write.config.IntelliDMLConfig;
import com.fr.util.Utils;
import com.fr.web.core.service.AttachmentService;
import java.awt.Color;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;

public class ReportXMLUtils {
    private static final Hashtable threadNameWidgetMap462 = new Hashtable();
    private static final int[] PasswordMaskArray = new int[]{19, 78, 10, 15, 100, 213, 43, 23};

    private ReportXMLUtils() {
    }

    public static Report readReportFromClassName(String string) {
        Report report;
        if (string.endsWith(".WorkSheet") || string.endsWith(".LinearReport") || string.endsWith(".ComplexBindSheet") || string.endsWith(".ComplexSheet") || string.endsWith(".ExpandBindSheet") || string.endsWith(".ExpandSheet")) {
            report = new WorkSheet();
        } else {
            try {
                Class clazz = FRCoreContext.classForName(string);
                report = (Report)clazz.newInstance();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                report = new WorkSheet();
            }
        }
        if (report == null) {
            report = new WorkSheet();
        }
        return report;
    }

    public static void writeXMLable(XMLPrintWriter xMLPrintWriter, XMLable xMLable, String string) {
        if (xMLable == null) {
            return;
        }
        xMLPrintWriter.startTAG(string).attr("class", xMLable.getClass().getName());
        xMLable.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static XMLable readXMLable(XMLableReader xMLableReader) {
        XMLable xMLable;
        block3: {
            String string = null;
            xMLable = null;
            string = xMLableReader.getAttr("class");
            if (string != null) {
                try {
                    xMLable = (XMLable)FRCoreContext.classForName(string).newInstance();
                    xMLableReader.readXMLObject(xMLable);
                }
                catch (Exception exception) {
                    if (exception instanceof ClassNotFoundException) break block3;
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        return xMLable;
    }

    public static void writeFormat(XMLPrintWriter xMLPrintWriter, Format format) {
        xMLPrintWriter.startTAG("Format").attr("class", format.getClass().getName());
        if (format instanceof DecimalFormat) {
            xMLPrintWriter.textNode(((DecimalFormat)format).toPattern());
        } else if (format instanceof SimpleDateFormat) {
            xMLPrintWriter.textNode(((SimpleDateFormat)format).toPattern());
        }
        xMLPrintWriter.end();
    }

    public static Format readFormat(XMLableReader xMLableReader) {
        Format format = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".TextFormat")) {
                format = TextFormat.getInstance();
            } else if (string.endsWith(".DecimalFormat")) {
                format = new DecimalFormat();
            } else if (string.endsWith(".SimpleDateFormat")) {
                format = new SimpleDateFormat();
            } else {
                try {
                    format = (Format)FRCoreContext.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        } else {
            format = TextFormat.getInstance();
        }
        if (format != null) {
            String string2 = null;
            string = xMLableReader.getElementValue();
            if (string != null) {
                string2 = string;
            }
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).applyPattern(string2);
            } else if (format instanceof SimpleDateFormat) {
                ((SimpleDateFormat)format).applyPattern(string2);
            }
        }
        return format;
    }

    public static DMLConfig readDMLConfig(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttr("class");
        if (string == null) {
            return null;
        }
        DMLConfig dMLConfig = null;
        if (string.endsWith(".IntelliDMLConfig")) {
            dMLConfig = new IntelliDMLConfig();
        } else {
            try {
                dMLConfig = (DMLConfig)FRCoreContext.classForName(string).newInstance();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (dMLConfig != null) {
            xMLableReader.readXMLObject(dMLConfig);
        }
        return dMLConfig;
    }

    public static SubmitJob readSubmitJob(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttr("class");
        if (string == null) {
            return null;
        }
        SubmitJob submitJob = null;
        if (string.endsWith(".DMLConfigJob")) {
            submitJob = new DMLConfigJob();
        } else {
            try {
                submitJob = (SubmitJob)FRCoreContext.classForName(string).newInstance();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (submitJob != null) {
            xMLableReader.readXMLObject(submitJob);
        }
        return submitJob;
    }

    public static JavaScript readJavaScript(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttr("class");
        if (string == null) {
            return null;
        }
        if (string.endsWith(".WebHyperlink")) {
            WebHyperlink webHyperlink = new WebHyperlink();
            xMLableReader.readXMLObject(webHyperlink);
            return webHyperlink;
        }
        if (string.endsWith(".EmailHyperlink")) {
            EmailHyperlink emailHyperlink = new EmailHyperlink();
            xMLableReader.readXMLObject(emailHyperlink);
            return emailHyperlink;
        }
        if (string.endsWith(".ReportletHyperlink")) {
            ReportletHyperlink reportletHyperlink = new ReportletHyperlink();
            xMLableReader.readXMLObject(reportletHyperlink);
            return reportletHyperlink;
        }
        JavaScript javaScript = null;
        try {
            javaScript = (JavaScript)FRCoreContext.classForName(string).newInstance();
            xMLableReader.readXMLObject(javaScript);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return javaScript;
    }

    public static ChartData readChartData(XMLableReader xMLableReader) {
        XMLable xMLable = null;
        String string = xMLableReader.getTagName();
        if (string.equals("ReportChartData")) {
            xMLable = (ReportChartData)xMLableReader.readXMLObject(new ReportChartData());
        } else if (string.equals("TableChartData")) {
            xMLable = (TableChartData)xMLableReader.readXMLObject(new TableChartData());
        } else if (string.equals("TopChartData")) {
            xMLable = (TopChartData)xMLableReader.readXMLObject(new TopChartData());
        }
        return xMLable;
    }

    public static FilterDefinition readDefinition(XMLableReader xMLableReader) {
        TopDefinition topDefinition = null;
        String string = xMLableReader.getTagName();
        if ("OneValueCDDefinition".equals(string)) {
            topDefinition = new OneValueCDDefinition();
        } else if ("MoreNameCDDefinition".equals(string)) {
            topDefinition = new MoreNameCDDefinition();
        } else if ("ReportDataDefinition".equals(string)) {
            topDefinition = new ReportDataDefinition();
        } else if ("SeriesListDefinition".equals(string)) {
            return ReportXMLUtils.seriesListRead2ReportDefinition(xMLableReader, new ReportDataDefinition());
        }
        xMLableReader.readXMLObject((XMLReadable)((Object)topDefinition));
        return topDefinition;
    }

    private static FilterDefinition seriesListRead2ReportDefinition(XMLableReader xMLableReader, final ReportDataDefinition reportDataDefinition) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("Top")) {
                        String string2 = xMLableReader.getAttr("topCate");
                        if (string2 != null) {
                            reportDataDefinition.setTopCate(Integer.parseInt(string2));
                        }
                        if ((string2 = xMLableReader.getAttr("topValue")) != null) {
                            reportDataDefinition.setTopValue(Integer.parseInt(string2));
                        }
                    }
                    if ("CategoryList".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                String string;
                                if (xMLableReader.isChildNode() && "Entry".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttr("value")) != null) {
                                    1.access$000(this.this$0).setCategoryNameString(string);
                                }
                            }
                        });
                    } else if ("SeriesList".equals(string)) {
                        xMLableReader.readXMLObject(new XMLReadable(this){
                            private final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode() && "SeriesEntry".equals(xMLableReader.getTagName())) {
                                    1.access$000(this.this$0).getSeriesList().add(xMLableReader.readXMLObject(new ReportDataDefinition.SeriesEntry()));
                                }
                            }
                        });
                    }
                }
            }

            static /* synthetic */ ReportDataDefinition access$000(1 var0) {
                return var0.reportDataDefinition;
            }
        });
        return reportDataDefinition;
    }

    public static void writeShape(XMLPrintWriter xMLPrintWriter, Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape instanceof GeneralPath) {
            GeneralPath generalPath = (GeneralPath)shape;
            ReportXMLUtils.writeGeneralPath(xMLPrintWriter, generalPath);
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            ReportXMLUtils.writeRectangle2D(xMLPrintWriter, rectangle2D);
        } else if (shape instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)shape;
            ReportXMLUtils.writeArc2D(xMLPrintWriter, arc2D);
        } else if (shape instanceof Cylinder) {
            Cylinder cylinder = (Cylinder)((Object)shape);
            cylinder.writeXML(xMLPrintWriter);
        }
    }

    public static Shape readShape(XMLableReader xMLableReader) {
        Shape shape = null;
        String string = xMLableReader.getTagName();
        if (string.equals("Rectangle2D")) {
            shape = ReportXMLUtils.readRectangle2D(xMLableReader);
        } else if (string.equals("Arc2D")) {
            shape = ReportXMLUtils.readArc2D(xMLableReader);
        } else if (string.equals("Cyliner")) {
            shape = (Shape)xMLableReader.readXMLObject(new Cylinder());
        } else if (string.equals("GeneralPath")) {
            shape = ReportXMLUtils.readGeneralPath(xMLableReader);
        }
        return shape;
    }

    public static void writeRectangularShape(XMLPrintWriter xMLPrintWriter, RectangularShape rectangularShape) {
        if (rectangularShape instanceof Arc2D) {
            ReportXMLUtils.writeArc2D(xMLPrintWriter, (Arc2D)rectangularShape);
        } else if (rectangularShape instanceof RoundRectangle2D) {
            ReportXMLUtils.writeRoundRectangle2D(xMLPrintWriter, (RoundRectangle2D)rectangularShape);
        } else if (rectangularShape instanceof Rectangle2D) {
            ReportXMLUtils.writeRectangle2D(xMLPrintWriter, (Rectangle2D)rectangularShape);
        }
    }

    public static RectangularShape readRectangularShape(XMLableReader xMLableReader) {
        RectangularShape rectangularShape = null;
        String string = xMLableReader.getTagName();
        if (string.equals("Rectangle2D")) {
            rectangularShape = ReportXMLUtils.readRectangle2D(xMLableReader);
        } else if (string.equals("Arc2D")) {
            rectangularShape = ReportXMLUtils.readArc2D(xMLableReader);
        } else if (string.equals("RoundRectangle")) {
            rectangularShape = ReportXMLUtils.readRoundRectangle2D(xMLableReader);
        }
        return rectangularShape;
    }

    public static RoundRectangle2D readRoundRectangle2D(XMLableReader xMLableReader) {
        RoundRectangle2D roundRectangle2D = null;
        String string = xMLableReader.getAttr("type");
        if (string != null) {
            roundRectangle2D = string.equals("float") ? new RoundRectangle2D.Float(Float.valueOf(xMLableReader.getAttr("x")).floatValue(), Float.valueOf(xMLableReader.getAttr("y")).floatValue(), Float.valueOf(xMLableReader.getAttr("width")).floatValue(), Float.valueOf(xMLableReader.getAttr("height")).floatValue(), Float.valueOf(xMLableReader.getAttr("arcWidth")).floatValue(), Float.valueOf(xMLableReader.getAttr("arcHeight")).floatValue()) : new RoundRectangle2D.Double(Double.valueOf(xMLableReader.getAttr("x")), Double.valueOf(xMLableReader.getAttr("y")), Double.valueOf(xMLableReader.getAttr("width")), Double.valueOf(xMLableReader.getAttr("height")), Double.valueOf(xMLableReader.getAttr("arcWidth")), Double.valueOf(xMLableReader.getAttr("arcHeight")));
        }
        return roundRectangle2D;
    }

    public static void writeRoundRectangle2D(XMLPrintWriter xMLPrintWriter, RoundRectangle2D roundRectangle2D) {
        xMLPrintWriter.startTAG("RoundRectangle2D");
        if (roundRectangle2D instanceof RoundRectangle2D.Double) {
            xMLPrintWriter.attr("type", "double");
        } else if (roundRectangle2D instanceof RoundRectangle2D.Float) {
            xMLPrintWriter.attr("type", "float");
        }
        xMLPrintWriter.attr("x", roundRectangle2D.getX()).attr("y", roundRectangle2D.getY()).attr("width", roundRectangle2D.getWidth()).attr("height", roundRectangle2D.getHeight()).attr("arcWidth", roundRectangle2D.getArcWidth()).attr("arcHeight", roundRectangle2D.getArcHeight()).end();
    }

    public static Glyph readGlyph(XMLableReader xMLableReader) {
        Glyph glyph = null;
        String string = xMLableReader.getTagName();
        if (string.equals("Cubic")) {
            glyph = (Cubic)xMLableReader.readXMLObject(new Cubic());
        } else if (string.equals("TextGlyph")) {
            glyph = (TextGlyph)xMLableReader.readXMLObject(new TextGlyph());
        } else if (string.equals("LineGlyph")) {
            glyph = (LineGlyph)xMLableReader.readXMLObject(new LineGlyph());
        } else if (string.equals("ValueAxisGlyph")) {
            glyph = (ValueAxisGlyph)xMLableReader.readXMLObject(new ValueAxisGlyph());
        } else if (string.equals("CategoryAxisGlyph")) {
            glyph = (CategoryAxisGlyph)xMLableReader.readXMLObject(new CategoryAxisGlyph());
        } else if (string.equals("RadarAxisGlyph")) {
            glyph = (RadarAxisGlyph)xMLableReader.readXMLObject(new RadarAxisGlyph());
        } else if (string.equals("ValueAxis3DGlyph")) {
            glyph = (ValueAxis3DGlyph)xMLableReader.readXMLObject(new ValueAxis3DGlyph());
        } else if (string.equals("CategoryAxis3DGlyph")) {
            glyph = (CategoryAxis3DGlyph)xMLableReader.readXMLObject(new CategoryAxis3DGlyph());
        } else if (string.equals("ShapeGlyph")) {
            glyph = (ShapeGlyph)xMLableReader.readXMLObject(new ShapeGlyph());
        } else if (string.equals("Area3D")) {
            glyph = (Area3D)xMLableReader.readXMLObject(new Area3D());
        } else if (string.equals("ShapeGlyph")) {
            glyph = (ShapeGlyph)xMLableReader.readXMLObject(new ShapeGlyph());
        } else if (string.equals("FoldLine3D")) {
            glyph = (FoldLine3D)xMLableReader.readXMLObject(new FoldLine3D());
        } else if (string.equals("FoldLine")) {
            glyph = (FoldLine)xMLableReader.readXMLObject(new FoldLine());
        } else if (string.equals("Pie3D")) {
            glyph = (Pie3D)xMLableReader.readXMLObject(new Pie3D());
        } else if (string.equals("CompositeGlyph")) {
            glyph = (CompositeGlyph)xMLableReader.readXMLObject(new CompositeGlyph());
        }
        return glyph;
    }

    public static Highlight readHighlight(XMLableReader xMLableReader) {
        Highlight highlight = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".DefaultHighlight") || string.endsWith(".CellHighlight")) {
                highlight = new DefaultHighlight();
            } else {
                try {
                    highlight = (Highlight)FRCoreContext.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        if (highlight == null) {
            return highlight;
        }
        xMLableReader.readXMLObject(highlight);
        return highlight;
    }

    public static HighlightAction readHighlightAction(XMLableReader xMLableReader) {
        HighlightAction highlightAction = null;
        String string = xMLableReader.getAttr("class");
        if (string == null) {
            return highlightAction;
        }
        if (string.endsWith(".ValueHighlightAction") || string.endsWith(".NewValueHighlightAction")) {
            highlightAction = new ValueHighlightAction();
        } else if (string.endsWith(".PresentHighlightAction")) {
            highlightAction = new PresentHighlightAction();
        } else if (string.endsWith(".ForegroundHighlightAction")) {
            highlightAction = new ForegroundHighlightAction();
        } else if (string.endsWith(".BackgroundHighlightAction")) {
            highlightAction = new BackgroundHighlightAction();
        } else if (string.endsWith(".RowHeightHighlightAction")) {
            highlightAction = new RowHeightHighlightAction();
        } else if (string.endsWith(".ColWidthHighlightAction")) {
            highlightAction = new ColWidthHighlightAction();
        } else if (string.endsWith(".PageHighlightAction")) {
            highlightAction = new PageHighlightAction();
        } else if (string.endsWith(".PaddingHighlightAction")) {
            highlightAction = new PaddingHighlightAction();
        } else if (string.endsWith(".FRFontHighlightAction")) {
            highlightAction = new FRFontHighlightAction();
        } else if (string.endsWith(".HyperlinkHighlightAction")) {
            highlightAction = new HyperlinkHighlightAction();
        } else if (string.endsWith(".BorderHighlightAction")) {
            highlightAction = new BorderHighlightAction();
        } else if (string.endsWith(".WidgetHighlightAction")) {
            highlightAction = new WidgetHighlightAction();
        } else {
            try {
                highlightAction = (HighlightAction)FRCoreContext.classForName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                FRContext.getLogger().log(Level.WARNING, instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FRContext.getLogger().log(Level.WARNING, illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FRContext.getLogger().log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        if (highlightAction != null) {
            xMLableReader.readXMLObject(highlightAction);
        }
        return highlightAction;
    }

    public static void writeCellElement(XMLPrintWriter xMLPrintWriter, CellElement cellElement) {
        if (cellElement == null) {
            return;
        }
        xMLPrintWriter.startTAG("C").attr("c", cellElement.getColumn()).attr("r", cellElement.getRow());
        if (cellElement.getColumnSpan() != 1) {
            xMLPrintWriter.attr("cs", cellElement.getColumnSpan());
        }
        if (cellElement.getRowSpan() != 1) {
            xMLPrintWriter.attr("rs", cellElement.getRowSpan());
        }
        if (cellElement.getStyle() != null && !ComparatorUtils.equals(cellElement.getStyle(), Style.DEFAULT_STYLE)) {
            SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList(Thread.currentThread());
            xMLPrintWriter.attr("s", synchronizedStyleList.indexOfStyle(cellElement.getStyle()));
        }
        cellElement.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeObject(XMLPrintWriter xMLPrintWriter, Object object) {
        if (object == null) {
            return;
        }
        ObjectXMLWriter objectXMLWriter = ReportXMLUtils.as(object);
        String string = objectXMLWriter.type();
        String string2 = objectXMLWriter.className();
        xMLPrintWriter.startTAG("O");
        if (StringUtils.isNotBlank(string)) {
            xMLPrintWriter.attr("t", string);
        }
        if (StringUtils.isNotBlank(string2)) {
            xMLPrintWriter.attr("class", string2);
        }
        objectXMLWriter.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private static ObjectXMLWriter as(Object object) {
        if (object == null || object == Primitive.NULL) {
            return new NULL();
        }
        if (object instanceof Boolean) {
            return new BOOLEAN((Boolean)object);
        }
        if (object instanceof Integer) {
            return new INTEGER((Integer)object);
        }
        if (object instanceof Double) {
            return new DOUBLE((Double)object);
        }
        if (object instanceof Float) {
            return new FLOAT((Float)object);
        }
        if (object instanceof BigInteger) {
            return new BIGI((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return new BIGD((BigDecimal)object);
        }
        if (object instanceof Date) {
            return new DATE((Date)object);
        }
        if (object instanceof Image) {
            return new IMAGE((Image)object);
        }
        if (object instanceof FArray) {
            return new FARRAYXML((FArray)object);
        }
        if (object instanceof Formula) {
            return new FORMULA((Formula)object);
        }
        if (object instanceof ChartCollection) {
            return new CC((ChartCollection)object);
        }
        if (object instanceof ChartPainter) {
            return new CP((ChartPainter)object);
        }
        if (object instanceof BiasTextPainter) {
            return new BTP((BiasTextPainter)object);
        }
        if (object instanceof Parameter) {
            return new PARA((Parameter)object);
        }
        if (object instanceof DSColumn) {
            return new DSCOLUMN((DSColumn)object);
        }
        if (object instanceof SubReport) {
            return new SUBREPORT((SubReport)object);
        }
        if (object instanceof ResultSubReport) {
            return new RESULTSUBREPORT((ResultSubReport)object);
        }
        if (object instanceof ShapePainter) {
            return new SP((ShapePainter)object);
        }
        if (object instanceof Report) {
            return new REPORT((Report)object);
        }
        if (object instanceof TableColumn) {
            return new TABLECOLUMN((TableColumn)object);
        }
        return new ElseAsString(object);
    }

    public static Object readObject(XMLableReader xMLableReader) {
        return ReportXMLUtils.readObject(xMLableReader, false, null);
    }

    public static String elementValue(XMLableReader xMLableReader) {
        String string = xMLableReader.getElementValue();
        if (string == null) {
            string = "";
        }
        string = string.replaceAll("\\n", "");
        return string;
    }

    public static Object readObject(XMLableReader xMLableReader, boolean bl, CellElement cellElement) {
        String string = "String";
        String string2 = xMLableReader.getAttr("t");
        if (string2 != null) {
            string = string2;
        } else {
            string2 = xMLableReader.getAttr("type");
            if (string2 != null) {
                string = string2;
            }
        }
        if ("NULL".equals(string)) {
            return Primitive.NULL;
        }
        if (StringUtils.isBlank(string) || "S".equals(string) || "String".equals(string)) {
            String string3 = "";
            try {
                string3 = BaseCoreUtils.readESC(ReportXMLUtils.elementValue(xMLableReader));
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.INFO, exception.getMessage(), exception);
            }
            if (bl && string3 != null && string3.startsWith("=")) {
                return new Formula(string3);
            }
            return string3;
        }
        if ("D".equals(string) || "Double".equals(string)) {
            try {
                return Double.valueOf(ReportXMLUtils.elementValue(xMLableReader));
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
                return new Double(0.0);
            }
        }
        if ("B".equals(string) || "Boolean".equals(string)) {
            return Boolean.valueOf(ReportXMLUtils.elementValue(xMLableReader));
        }
        if ("I".equals(string) || "Inteter".equals(string)) {
            return Integer.valueOf(ReportXMLUtils.elementValue(xMLableReader));
        }
        if ("F".equals(string) || "Float".equals(string)) {
            return Float.valueOf(ReportXMLUtils.elementValue(xMLableReader));
        }
        if ("BigInteger".equals(string)) {
            return new BigInteger(ReportXMLUtils.elementValue(xMLableReader));
        }
        if ("BigDecimal".equals(string)) {
            return new BigDecimal(ReportXMLUtils.elementValue(xMLableReader));
        }
        if ("Date".equals(string)) {
            return DateUtils.object2Date(ReportXMLUtils.elementValue(xMLableReader), true);
        }
        if ("FARRAY".equals(string)) {
            return xMLableReader.readXMLObject(new FArray());
        }
        if ("Formula".equals(string)) {
            Formula formula;
            String string4 = xMLableReader.getAttr("class");
            if (string4 == null || "Formula".equals(string4)) {
                formula = new Formula();
            } else {
                try {
                    formula = (Formula)FRCoreContext.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    formula = new Formula();
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            xMLableReader.readXMLObject(formula);
            return formula;
        }
        if ("Image".equals(string)) {
            XMLObject xMLObject = new XMLObject(null){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Image")) {
                        this.obj = BaseXMLUtils.readImage(xMLableReader);
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            return xMLObject.getObject();
        }
        if ("CC".equals(string)) {
            ChartCollection chartCollection = new ChartCollection();
            xMLableReader.readXMLObject(chartCollection);
            return chartCollection;
        }
        if ("Chart".equals(string) || "BindChart".equals(string) || "ReportDataChart".equals(string) || "ChartPainter".equals(string)) {
            return ChartXMLCompatibleUtils.read62ChartCollection(xMLableReader);
        }
        if ("CP".equals(string)) {
            ChartPainter chartPainter = new ChartPainter();
            xMLableReader.readXMLObject(chartPainter);
            return chartPainter;
        }
        if ("BiasTextPainter".equals(string)) {
            BiasTextPainter biasTextPainter = new BiasTextPainter("");
            xMLableReader.readXMLObject(biasTextPainter);
            return biasTextPainter;
        }
        if ("Parameter".equals(string)) {
            return ReportXMLUtils.readParameter(xMLableReader);
        }
        if ("DSColumn".equals(string) || string.equals("LinearDSColumn") || string.equals("ComplexDSColumn")) {
            DSColumn dSColumn = new DSColumn();
            xMLableReader.readXMLObject(dSColumn);
            return dSColumn;
        }
        if ("SubReport".equals(string)) {
            SubReport subReport = new SubReport();
            xMLableReader.readXMLObject(subReport);
            return subReport;
        }
        if ("ResultSubReport".equals(string)) {
            ResultSubReport resultSubReport = new ResultSubReport();
            xMLableReader.readXMLObject(resultSubReport);
            return resultSubReport;
        }
        if ("TableColumn".equals(string)) {
            TableColumn tableColumn = new TableColumn();
            xMLableReader.readXMLObject(tableColumn);
            return tableColumn;
        }
        if ("ShapePainter".equals(string)) {
            ShapePainter shapePainter = null;
            string2 = xMLableReader.getAttr("class");
            if (string2 != null) {
                try {
                    shapePainter = (ShapePainter)FRCoreContext.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    shapePainter = new RectangleShapePainter();
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            xMLableReader.readXMLObject(shapePainter);
            return shapePainter;
        }
        if ("Report".equals(string)) {
            Report report = null;
            string2 = xMLableReader.getAttr("class");
            if (string2 != null) {
                try {
                    report = (Report)FRCoreContext.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    report = new WorkSheet();
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            xMLableReader.readXMLObject(report);
            return report;
        }
        if ("Attachment".equals(string)) {
            return AttachmentService.getAttachment(ReportXMLUtils.elementValue(xMLableReader));
        }
        if ("PB".equals(string)) {
            return ReportXMLUtils.readOldPBElement(xMLableReader);
        }
        if ("PE".equals(string)) {
            return ReportXMLUtils.readOldPEElement(xMLableReader);
        }
        if ("PR".equals(string)) {
            XMLObject xMLObject = new XMLObject(null){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ParameterRef") && (string = xMLableReader.getAttr("name")) != null) {
                        this.obj = SynchronizedNameWidget.get(string);
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            return xMLObject.getObject();
        }
        return null;
    }

    public static Button readOldPBElement(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                String string;
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ParameterButton") && StringUtils.isNotBlank(string = xMLableReader.getAttr("type"))) {
                    if (string.equals("0")) {
                        arrayList.add(new FormSubmitButton(xMLableReader.getAttr("name")));
                    } else if (string.equals("1")) {
                        arrayList.add(new FormResetButton(xMLableReader.getAttr("name")));
                    }
                }
            }
        });
        return arrayList.size() > 0 ? (Button)arrayList.get(0) : null;
    }

    public static FieldEditor readOldPEElement(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ParameterEditor")) {
                    ParameterEditor parameterEditor = new ParameterEditor();
                    xMLableReader.readXMLObject(parameterEditor);
                    arrayList.add(parameterEditor);
                }
            }
        });
        return arrayList.size() > 0 ? ((ParameterEditor)arrayList.get(0)).toFieldEditor() : null;
    }

    public static void writeIndexStyle(XMLPrintWriter xMLPrintWriter, Style style) {
        if (style == null) {
            return;
        }
        SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList(Thread.currentThread());
        xMLPrintWriter.startTAG("Style").attr("index", synchronizedStyleList.indexOfStyle(style)).end();
    }

    public static Style readFullStyle(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttr("style_name");
        if (string != null) {
            return NameStyle.getInstance(string);
        }
        Style style = Style.getInstance();
        string = xMLableReader.getAttr("horizontal_alignment");
        if (string != null) {
            int n = Integer.parseInt(string);
            if (n == 5) {
                n = 2;
            }
            style = style.deriveHorizontalAlignment(n);
        }
        if ((string = xMLableReader.getAttr("vertical_alignment")) != null) {
            style = style.deriveVerticalAlignment(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("isWrapText")) != null) {
            style = Boolean.valueOf(string) != false ? style.deriveTextStyle(0) : style.deriveTextStyle(1);
        }
        if ((string = xMLableReader.getAttr("textStyle")) != null) {
            style = style.deriveTextStyle(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("isVerticalText")) != null) {
            style = style.deriveVerticalText(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("textDirection")) != null) {
            style = style.deriveTextDirection(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("rotation")) != null) {
            style = style.deriveRotation(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("imageLayout")) != null) {
            style = style.deriveImageLayout(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("paddingLeft")) != null || (string = xMLableReader.getAttr("leftIndent")) != null) {
            style = style.derivePaddingLeft(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("paddingRight")) != null || (string = xMLableReader.getAttr("rightIndent")) != null) {
            style = style.derivePaddingRight(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("spacingBefore")) != null) {
            style = style.deriveSpacingBefore(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("spacingAfter")) != null) {
            style = style.deriveSpacingAfter(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("lineSpacing")) != null) {
            style = style.deriveLineSpacing(Integer.parseInt(string));
        }
        XMLObject xMLObject = new XMLObject(style){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("Format")) {
                        this.obj = ((Style)this.obj).deriveFormat(ReportXMLUtils.readFormat(xMLableReader));
                    } else if (BaseXMLUtils.isFRFontTagName(string)) {
                        this.obj = ((Style)this.obj).deriveFRFont(BaseXMLUtils.readFRFont(xMLableReader));
                    } else if (string.equals("Background")) {
                        this.obj = ((Style)this.obj).deriveBackground(BaseXMLUtils.readBackground(xMLableReader));
                    } else if (string.equals("Border")) {
                        XMLObject xMLObject = new XMLObject(this, this.obj){
                            private final /* synthetic */ 8 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode()) {
                                    String string = xMLableReader.getTagName();
                                    int n = 0;
                                    Color color = Color.black;
                                    if (string.equals("Top")) {
                                        String string2 = xMLableReader.getAttr("style");
                                        if (string2 != null) {
                                            n = Integer.parseInt(string2);
                                        }
                                        if ((string2 = xMLableReader.getAttr("color")) != null) {
                                            color = new Color(Integer.parseInt(string2), true);
                                        }
                                        this.obj = ((Style)this.obj).deriveBorderTop(n, color);
                                    } else if (string.equals("Left")) {
                                        String string3 = xMLableReader.getAttr("style");
                                        if (string3 != null) {
                                            n = Integer.parseInt(string3);
                                        }
                                        if ((string3 = xMLableReader.getAttr("color")) != null) {
                                            color = new Color(Integer.parseInt(string3), true);
                                        }
                                        this.obj = ((Style)this.obj).deriveBorderLeft(n, color);
                                    } else if (string.equals("Bottom")) {
                                        String string4 = xMLableReader.getAttr("style");
                                        if (string4 != null) {
                                            n = Integer.parseInt(string4);
                                        }
                                        if ((string4 = xMLableReader.getAttr("color")) != null) {
                                            color = new Color(Integer.parseInt(string4), true);
                                        }
                                        this.obj = ((Style)this.obj).deriveBorderBottom(n, color);
                                    } else if (string.equals("Right")) {
                                        String string5 = xMLableReader.getAttr("style");
                                        if (string5 != null) {
                                            n = Integer.parseInt(string5);
                                        }
                                        if ((string5 = xMLableReader.getAttr("color")) != null) {
                                            color = new Color(Integer.parseInt(string5), true);
                                        }
                                        this.obj = ((Style)this.obj).deriveBorderRight(n, color);
                                    }
                                }
                            }
                        };
                        xMLableReader.readXMLObject(xMLObject);
                        this.obj = xMLObject.getObject();
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (Style)xMLObject.getObject();
    }

    public static void writeStyle(XMLPrintWriter xMLPrintWriter, Style style) {
        if (style instanceof NameStyle) {
            xMLPrintWriter.startTAG("Style").attr("style_name", ((NameStyle)style).getName()).end();
            return;
        }
        xMLPrintWriter.startTAG("Style");
        if (style.getHorizontalAlignment() != 2) {
            xMLPrintWriter.attr("horizontal_alignment", style.getHorizontalAlignment());
        }
        if (style.getVerticalAlignment() != 0) {
            xMLPrintWriter.attr("vertical_alignment", style.getVerticalAlignment());
        }
        if (style.getTextStyle() != 0) {
            xMLPrintWriter.attr("textStyle", style.getTextStyle());
        }
        if (style.getVerticalText() != 0) {
            xMLPrintWriter.attr("isVerticalText", style.getVerticalText()).attr("textDirection", style.getTextDirection());
        }
        if (style.getRotation() != 0) {
            xMLPrintWriter.attr("rotation", style.getRotation());
        }
        if (style.getImageLayout() != 3) {
            xMLPrintWriter.attr("imageLayout", style.getImageLayout());
        }
        if (style.getPaddingLeft() != 2) {
            xMLPrintWriter.attr("paddingLeft", style.getPaddingLeft());
        }
        if (style.getPaddingRight() != 2) {
            xMLPrintWriter.attr("paddingRight", style.getPaddingRight());
        }
        if (style.getSpacingBefore() != 0) {
            xMLPrintWriter.attr("spacingBefore", style.getSpacingBefore());
        }
        if (style.getSpacingAfter() != 0) {
            xMLPrintWriter.attr("spacingAfter", style.getSpacingAfter());
        }
        if (style.getLineSpacing() != 0) {
            xMLPrintWriter.attr("lineSpacing", style.getLineSpacing());
        }
        if (style.getFormat() != null) {
            ReportXMLUtils.writeFormat(xMLPrintWriter, style.getFormat());
        }
        if (style.getFRFont() != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, style.getFRFont());
        }
        BaseXMLUtils.writeBackground(xMLPrintWriter, style.getBackground());
        xMLPrintWriter.startTAG("Border");
        if (style.getBorderTop() != 0 || style.getBorderTopColor() != Color.black) {
            xMLPrintWriter.startTAG("Top");
            if (style.getBorderTop() != 0) {
                xMLPrintWriter.attr("style", style.getBorderTop());
            }
            if (style.getBorderTopColor() != Color.black) {
                xMLPrintWriter.attr("color", style.getBorderTopColor().getRGB());
            }
            xMLPrintWriter.end();
        }
        if (style.getBorderBottom() != 0 || style.getBorderBottomColor() != Color.black) {
            xMLPrintWriter.startTAG("Bottom");
            if (style.getBorderBottom() != 0) {
                xMLPrintWriter.attr("style", style.getBorderBottom());
            }
            if (style.getBorderBottomColor() != Color.black) {
                xMLPrintWriter.attr("color", style.getBorderBottomColor().getRGB());
            }
            xMLPrintWriter.end();
        }
        if (style.getBorderLeft() != 0 || style.getBorderLeftColor() != Color.black) {
            xMLPrintWriter.startTAG("Left");
            if (style.getBorderLeft() != 0) {
                xMLPrintWriter.attr("style", style.getBorderLeft());
            }
            if (style.getBorderLeftColor() != Color.black) {
                xMLPrintWriter.attr("color", style.getBorderLeftColor().getRGB());
            }
            xMLPrintWriter.end();
        }
        if (style.getBorderRight() != 0 || style.getBorderRightColor() != Color.black) {
            xMLPrintWriter.startTAG("Right");
            if (style.getBorderRight() != 0) {
                xMLPrintWriter.attr("style", style.getBorderRight());
            }
            if (style.getBorderRightColor() != Color.black) {
                xMLPrintWriter.attr("color", style.getBorderRightColor().getRGB());
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end().end();
    }

    public static void writeFloatElement(XMLPrintWriter xMLPrintWriter, FloatElement floatElement) {
        if (floatElement == null) {
            return;
        }
        xMLPrintWriter.startTAG(floatElement.getClass().getName());
        floatElement.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void readReportFloatElementList(XMLableReader xMLableReader, final Report report) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    Object object;
                    String string = xMLableReader.getTagName();
                    Object object2 = null;
                    if (string.equals("ShapeFloatElement")) {
                        object = xMLableReader.getAttr("class");
                        if (object != null) {
                            if (((String)object).endsWith(".IssoscelesTriangleShapeFloatElement")) {
                                object2 = new IssoscelesTriangleShapePainter();
                            } else if (((String)object).endsWith(".LineShapeFloatElement")) {
                                object2 = new LineShapePainter();
                            } else if (((String)object).endsWith(".OvalShapeFloatElement")) {
                                object2 = new OvalShapePainter();
                            } else if (((String)object).endsWith(".RectangleShapeFloatElement")) {
                                object2 = new RectangleShapePainter();
                            } else if (((String)object).endsWith(".RoundedRectangleShapeFloatElement")) {
                                object2 = new RoundedRectangleShapePainter();
                            }
                        }
                    } else if (string.equals("TextBoxFloatElement")) {
                        object2 = "";
                    } else if (string.equals("ImageFloatElement")) {
                        object2 = ((XMLObject)xMLableReader.readXMLObject(new XMLObject(this, null){
                            private final /* synthetic */ 10 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Image")) {
                                    this.obj = BaseXMLUtils.readImage(xMLableReader);
                                }
                            }
                        })).getObject();
                    }
                    if (object2 != null && object2 instanceof Painter) {
                        xMLableReader.readXMLObject((Painter)object2);
                    }
                    object = new FloatElement();
                    ((FloatElement)object).setValue(object2);
                    xMLableReader.readXMLObject((XMLReadable)object);
                    report.addFloatElement((FloatElement)object);
                }
            }
        });
    }

    public static void writeParameter(XMLPrintWriter xMLPrintWriter, Parameter parameter) {
        if (parameter == null) {
            return;
        }
        xMLPrintWriter.startTAG("Parameter");
        parameter.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static Parameter[] readParameters(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Parameter")) {
                    arrayList.add(ReportXMLUtils.readParameter(xMLableReader));
                }
            }
        });
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    public static Parameter readParameter(XMLableReader xMLableReader) {
        Parameter parameter = new Parameter();
        xMLableReader.readXMLObject(parameter);
        return parameter;
    }

    public static void writeParameters(XMLPrintWriter xMLPrintWriter, Parameter[] parameterArray) {
        int n;
        xMLPrintWriter.startTAG("Parameters");
        int n2 = n = parameterArray == null ? 0 : parameterArray.length;
        for (int i = 0; i < n; ++i) {
            ReportXMLUtils.writeParameter(xMLPrintWriter, parameterArray[i]);
        }
        xMLPrintWriter.end();
    }

    public static ParameterUI readParameterUI(XMLableReader xMLableReader) {
        ParameterUI parameterUI = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".DefaultParameterInterface") || string.endsWith(".DefaultParameterUI")) {
                parameterUI = CustomParameterUI.createDefaultParameterUI();
            } else if (string.endsWith(".CustomParameterInterface")) {
                parameterUI = new CustomParameterUI();
            } else if (string.endsWith(".CustomEmbeddedParameterInterface")) {
                parameterUI = new CustomParameterUI();
            } else {
                try {
                    parameterUI = (ParameterUI)FRCoreContext.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        if (parameterUI != null) {
            xMLableReader.readXMLObject(parameterUI);
        }
        return parameterUI;
    }

    public static ParameterProcessor readParameterProcessor(XMLableReader xMLableReader) {
        ParameterProcessor parameterProcessor = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".ClassParameterProcessor")) {
                parameterProcessor = new ClassParameterProcessor();
            } else {
                try {
                    parameterProcessor = (ParameterProcessor)FRCoreContext.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        if (parameterProcessor instanceof XMLable) {
            xMLableReader.readXMLObject((XMLReadable)((Object)parameterProcessor));
        }
        return parameterProcessor;
    }

    public static void writeParameterProcessor(XMLPrintWriter xMLPrintWriter, ParameterProcessor parameterProcessor) {
        xMLPrintWriter.startTAG("PP").attr("class", parameterProcessor.getClass().getName());
        if (parameterProcessor instanceof XMLable) {
            ((XMLable)((Object)parameterProcessor)).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public static UnitProcessor readUnitProcessor(XMLableReader xMLableReader) {
        UnitProcessor unitProcessor = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".SQLQueryUnitProcessor")) {
                unitProcessor = new SQLQueryUnitProcessor();
            } else if (string.endsWith(".FormulaUnitProcessor")) {
                unitProcessor = new FormulaUnitProcessor();
            } else {
                try {
                    unitProcessor = (UnitProcessor)FRCoreContext.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    unitProcessor = null;
                }
            }
        }
        if (unitProcessor instanceof XMLable) {
            xMLableReader.readXMLObject((XMLReadable)((Object)unitProcessor));
        }
        return unitProcessor;
    }

    public static void writeUnitProcessor(XMLPrintWriter xMLPrintWriter, UnitProcessor unitProcessor) {
        xMLPrintWriter.startTAG("UP").attr("class", unitProcessor.getClass().getName());
        if (unitProcessor instanceof XMLable) {
            ((XMLable)((Object)unitProcessor)).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public static FieldEditor readFieldEditor(XMLableReader xMLableReader) {
        Widget widget = ReportXMLUtils.readWidget(xMLableReader);
        return widget instanceof FieldEditor ? (FieldEditor)widget : null;
    }

    public static Widget readCellWidget(XMLableReader xMLableReader) {
        Widget widget = ReportXMLUtils.readWidget(xMLableReader);
        return widget instanceof FieldEditor || widget instanceof CustomButton ? widget : null;
    }

    public static Widget readWidget(XMLableReader xMLableReader) {
        Widget widget = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".TextCellEditorDef")) {
                widget = new TextEditor();
            } else if (string.endsWith(".ComboBoxCellEditorDef")) {
                widget = new ComboBox();
            } else if (string.endsWith(".CheckBoxCellEditorDef")) {
                widget = new ComboCheckBox();
                ((ComboCheckBox)widget).setReturnArray(false);
            } else if (string.endsWith(".DateCellEditorDef")) {
                widget = new DateEditor();
            } else if (string.endsWith(".DateTimeEditorDef")) {
                widget = new DateTimeEditor();
            } else if (string.endsWith(".FileCellEditorDef")) {
                widget = new FileEditor();
            } else if (string.endsWith(".NumberCellEditorDef")) {
                widget = new NumberEditor();
            } else if (string.endsWith(".CheckBoxEditor")) {
                widget = new ComboCheckBox();
                ((ComboCheckBox)widget).setReturnArray(false);
            } else {
                if (string.endsWith(".AppendRow")) {
                    return null;
                }
                if (string.endsWith(".DeleteRow")) {
                    return null;
                }
                try {
                    Class clazz = FRCoreContext.classForName(string);
                    widget = (Widget)clazz.newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            if (widget != null) {
                xMLableReader.readXMLObject(widget);
            }
        }
        return widget;
    }

    public static Formula readFormula(XMLableReader xMLableReader) {
        Formula formula = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            try {
                Class clazz = FRCoreContext.classForName(string);
                formula = (Formula)clazz.newInstance();
                xMLableReader.readXMLObject(formula);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return formula;
    }

    public static Button readButton(XMLableReader xMLableReader) {
        Button button = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            try {
                Class clazz = FRCoreContext.classForName(string);
                button = (Button)clazz.newInstance();
                xMLableReader.readXMLObject(button);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return button;
    }

    public static Present readPresent(XMLableReader xMLableReader) {
        Present present = null;
        String string = xMLableReader.getAttr("class");
        if (string != null) {
            if (string.endsWith(".DictPresent")) {
                present = new DictPresent();
            } else if (string.endsWith(".BarcodePresent")) {
                present = new BarcodePresent();
            } else if (string.endsWith(".FormulaPresent")) {
                present = new FormulaPresent();
            } else if (string.endsWith(".DefaultPresent")) {
                present = new DefaultPresent();
            } else {
                try {
                    Class clazz = FRCoreContext.classForName(string);
                    present = (Present)clazz.newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            xMLableReader.readXMLObject(present);
        }
        return present;
    }

    public static RecordGrouper readXMLRecordGrouper(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if ("GC".equals(string)) {
            return ReportXMLUtils.readGroupCalculator2RecordGrouper(xMLableReader);
        }
        if ("SpecifiedGroupAttr".equals(string)) {
            return ReportXMLUtils.readGA2RecordGrouper(xMLableReader);
        }
        RecordGrouper recordGrouper = null;
        String string2 = xMLableReader.getAttr("class");
        if (string2 != null) {
            if (string2.endsWith(".ValueGrouper")) {
                recordGrouper = new FunctionGrouper();
            } else if (string2.endsWith(".IndexGrouper")) {
                recordGrouper = new IndexGrouper();
            } else if (string2.endsWith(".MonoGrouper")) {
                recordGrouper = new MonoGrouper();
            } else if (string2.endsWith(".SummaryGrouper")) {
                recordGrouper = new SummaryGrouper();
            } else if (string2.endsWith(".CustomGrouper")) {
                recordGrouper = new CustomGrouper();
            } else {
                try {
                    recordGrouper = (RecordGrouper)FRCoreContext.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            xMLableReader.readXMLObject(recordGrouper);
        }
        return recordGrouper;
    }

    private static RecordGrouper readGroupCalculator2RecordGrouper(XMLableReader xMLableReader) {
        String string;
        RecordGrouper recordGrouper = null;
        String string2 = xMLableReader.getAttr("class");
        if (string2.endsWith(".DefaultGroupCalculator")) {
            XMLObject xMLObject = new XMLObject(null){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isChildNode() && ("GA".equals(string = xMLableReader.getTagName()) || "SpecifiedGroupAttr".equals(string))) {
                        this.obj = ReportXMLUtils.readGA2RecordGrouper(xMLableReader);
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            recordGrouper = (RecordGrouper)xMLObject.getObject();
        } else if (string2.endsWith(".FormulaGroupCalculator") && (string = xMLableReader.getElementValue()) != null && string.length() > 0) {
            recordGrouper = new FunctionGrouper();
            ((FunctionGrouper)recordGrouper).setFormulaContent(string);
        }
        return recordGrouper;
    }

    private static RecordGrouper readGA2RecordGrouper(XMLableReader xMLableReader) {
        CustomGrouper customGrouper = new CustomGrouper();
        String string = xMLableReader.getAttr("other");
        if (string != null) {
            customGrouper.setOther(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttr("odisplay")) != null) {
            customGrouper.setOdisplay(string);
        }
        if ((string = xMLableReader.getAttr("force")) != null) {
            customGrouper.setForce(Boolean.valueOf(string));
        }
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ConditionListGroup")) {
                    ConditionGroup conditionGroup = new ConditionGroup();
                    xMLableReader.readXMLObject(conditionGroup);
                    arrayList.add(conditionGroup);
                }
            }
        });
        customGrouper.setConditionGroups(arrayList.toArray(new ConditionGroup[arrayList.size()]));
        return customGrouper;
    }

    public static String passwordString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("___");
        if (string == null) {
            return stringBuffer.toString();
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (n == PasswordMaskArray.length) {
                n = 0;
            }
            int n2 = string.charAt(i) ^ PasswordMaskArray[n];
            String string2 = Integer.toHexString(n2);
            int n3 = string2.length();
            for (int j = 0; j < 4 - n3; ++j) {
                string2 = "0" + string2;
            }
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String unPasswordString(String string) {
        if (string != null && string.startsWith("___")) {
            string = string.substring(3);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            for (int i = 0; i <= string.length() - 4; i += 4) {
                if (n == PasswordMaskArray.length) {
                    n = 0;
                }
                String string2 = string.substring(i, i + 4);
                int n2 = Integer.parseInt(string2, 16) ^ PasswordMaskArray[n];
                stringBuffer.append((char)n2);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static void writeBounds(XMLPrintWriter xMLPrintWriter, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return;
        }
        xMLPrintWriter.startTAG("Bounds").attr("x", rectangle2D.getX()).attr("y", rectangle2D.getY()).attr("w", rectangle2D.getWidth()).attr("h", rectangle2D.getHeight()).end();
    }

    public static Rectangle2D readBounds(XMLableReader xMLableReader) {
        return new Rectangle2D.Double(Utils.string2Number(xMLableReader.getAttr("x")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("y")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("w")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("h")).doubleValue());
    }

    public static void writeArc2D(XMLPrintWriter xMLPrintWriter, Arc2D arc2D) {
        xMLPrintWriter.startTAG("Arc2D");
        if (arc2D instanceof Arc2D.Double) {
            xMLPrintWriter.attr("type", "double");
        } else if (arc2D instanceof Arc2D.Float) {
            xMLPrintWriter.attr("type", "float");
        }
        xMLPrintWriter.attr("x", arc2D.getX()).attr("y", arc2D.getY()).attr("width", arc2D.getWidth()).attr("height", arc2D.getHeight()).attr("start", arc2D.getAngleStart()).attr("extent", arc2D.getAngleExtent()).attr("intType", arc2D.getArcType()).end();
    }

    public static Arc2D readArc2D(XMLableReader xMLableReader) {
        Arc2D arc2D = null;
        String string = xMLableReader.getAttr("type");
        if (string != null) {
            arc2D = string.equals("float") ? new Arc2D.Float(Utils.string2Number(xMLableReader.getAttr("x")).floatValue(), Utils.string2Number(xMLableReader.getAttr("y")).floatValue(), Utils.string2Number(xMLableReader.getAttr("width")).floatValue(), Utils.string2Number(xMLableReader.getAttr("height")).floatValue(), Utils.string2Number(xMLableReader.getAttr("start")).floatValue(), Utils.string2Number(xMLableReader.getAttr("extent")).floatValue(), Utils.string2Number(xMLableReader.getAttr("intType")).intValue()) : new Arc2D.Double(Utils.string2Number(xMLableReader.getAttr("x")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("y")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("width")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("height")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("start")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("extent")).doubleValue(), Utils.string2Number(xMLableReader.getAttr("intType")).intValue());
        }
        return arc2D;
    }

    public static void writeRectangle2D(XMLPrintWriter xMLPrintWriter, Rectangle2D rectangle2D) {
        xMLPrintWriter.startTAG("Rectangle2D");
        if (rectangle2D instanceof Rectangle2D.Double) {
            xMLPrintWriter.attr("type", "double");
        } else if (rectangle2D instanceof Rectangle2D.Float) {
            xMLPrintWriter.attr("type", "float");
        }
        xMLPrintWriter.attr("x", rectangle2D.getX()).attr("y", rectangle2D.getY()).attr("width", rectangle2D.getWidth()).attr("height", rectangle2D.getHeight()).end();
    }

    public static Rectangle2D readRectangle2D(XMLableReader xMLableReader) {
        Rectangle2D rectangle2D = null;
        String string = xMLableReader.getAttr("type");
        if (string != null) {
            rectangle2D = string.equals("float") ? new Rectangle2D.Float(Float.valueOf(xMLableReader.getAttr("x")).floatValue(), Float.valueOf(xMLableReader.getAttr("y")).floatValue(), Float.valueOf(xMLableReader.getAttr("width")).floatValue(), Float.valueOf(xMLableReader.getAttr("height")).floatValue()) : new Rectangle2D.Double(Double.valueOf(xMLableReader.getAttr("x")), Double.valueOf(xMLableReader.getAttr("y")), Double.valueOf(xMLableReader.getAttr("width")), Double.valueOf(xMLableReader.getAttr("height")));
        }
        return rectangle2D;
    }

    public static void writeGeneralPath(XMLPrintWriter xMLPrintWriter, GeneralPath generalPath) {
        xMLPrintWriter.startTAG("GeneralPath");
        float[] fArray = new float[6];
        PathIterator pathIterator = generalPath.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            xMLPrintWriter.startTAG("Coord").attr("coords0", fArray[0]).attr("coords1", fArray[1]).end();
            pathIterator.next();
        }
        xMLPrintWriter.startTAG("Type").attr("windingRule", generalPath.getWindingRule()).end();
        xMLPrintWriter.end();
    }

    public static GeneralPath readGeneralPath(XMLableReader xMLableReader) {
        boolean bl = true;
        GeneralPath generalPath = new GeneralPath(1);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            String string2 = null;
            float f = 0.0f;
            float f2 = 0.0f;
            if (string.equals("Coord")) {
                string2 = xMLableReader.getAttr("coords0");
                if (string2 != null) {
                    f = Float.valueOf(string2).floatValue();
                }
                if ((string2 = xMLableReader.getAttr("coords1")) != null) {
                    f2 = Float.valueOf(string2).floatValue();
                }
                if (bl) {
                    bl = false;
                    generalPath.moveTo(f, f2);
                } else {
                    generalPath.lineTo(f, f2);
                }
            } else if (string.equals("Type")) {
                generalPath.setWindingRule(Integer.valueOf(string2));
            }
        }
        return generalPath;
    }

    private static final class ParameterEditor
    implements XMLReadable {
        private String name;
        private FieldEditor editor;
        private Object defaultValue;

        public void readXML(XMLableReader xMLableReader) {
            if (xMLableReader.isChildNode()) {
                String string = xMLableReader.getTagName();
                if ("CellEditorDef".equals(string)) {
                    this.editor = ReportXMLUtils.readFieldEditor(xMLableReader);
                } else if ("O".equals(string)) {
                    this.defaultValue = ReportXMLUtils.readObject(xMLableReader);
                } else if ("Name".equals(string)) {
                    this.name = xMLableReader.getElementValue();
                }
            }
        }

        public FieldEditor toFieldEditor() {
            if (this.editor != null) {
                this.editor.setFieldName(this.name);
            }
            return this.editor;
        }
    }

    private static class ElseAsString
    extends ObjectXMLWriter {
        private Object ob;

        ElseAsString(Object object) {
            this.ob = object;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.textNode(BaseCoreUtils.writeESC(Utils.objectToString(this.ob)));
        }
    }

    private static class REPORT
    extends XML {
        REPORT(Report report) {
            this.xml = report;
        }

        public String type() {
            return "Report";
        }

        public String className() {
            return this.xml.getClass().getName();
        }
    }

    private static class SP
    extends XML {
        SP(ShapePainter shapePainter) {
            this.xml = shapePainter;
        }

        public String type() {
            return "ShapePainter";
        }

        public String className() {
            return this.xml.getClass().getName();
        }
    }

    private static class TABLECOLUMN
    extends XML {
        TABLECOLUMN(TableColumn tableColumn) {
            this.xml = tableColumn;
        }

        public String type() {
            return "TableColumn";
        }
    }

    private static class RESULTSUBREPORT
    extends XML {
        RESULTSUBREPORT(ResultSubReport resultSubReport) {
            this.xml = resultSubReport;
        }

        public String type() {
            return "ResultSubReport";
        }
    }

    private static class SUBREPORT
    extends XML {
        SUBREPORT(SubReport subReport) {
            this.xml = subReport;
        }

        public String type() {
            return "SubReport";
        }
    }

    private static class DSCOLUMN
    extends XML {
        DSCOLUMN(DSColumn dSColumn) {
            this.xml = dSColumn;
        }

        public String type() {
            return "DSColumn";
        }
    }

    private static class PARA
    extends XML {
        PARA(Parameter parameter) {
            this.xml = parameter;
        }

        public String type() {
            return "Parameter";
        }
    }

    private static class BTP
    extends XML {
        BTP(BiasTextPainter biasTextPainter) {
            this.xml = biasTextPainter;
        }

        public String type() {
            return "BiasTextPainter";
        }
    }

    private static class CP
    extends XML {
        CP(ChartPainter chartPainter) {
            this.xml = chartPainter;
        }

        public String type() {
            return "CP";
        }
    }

    private static class CC
    extends XML {
        CC(ChartCollection chartCollection) {
            this.xml = chartCollection;
        }

        public String type() {
            return "CC";
        }
    }

    private static class FORMULA
    extends XML {
        FORMULA(Formula formula) {
            this.xml = formula;
        }

        public String type() {
            return "Formula";
        }

        public String className() {
            String string = this.xml.getClass().getName();
            if (string.endsWith(".Formula")) {
                string = "Formula";
            }
            return string;
        }
    }

    private static class FARRAYXML
    extends XML {
        public FARRAYXML(FArray fArray) {
            this.xml = fArray;
        }

        public String type() {
            return "FARRAY";
        }
    }

    private static abstract class XML
    extends ObjectXMLWriter {
        protected XMLWriter xml;

        private XML() {
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            this.xml.writeXML(xMLPrintWriter);
        }
    }

    private static class IMAGE
    extends ObjectXMLWriter {
        private Image im;

        IMAGE(Image image) {
            this.im = image;
        }

        public String type() {
            return "Image";
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            BaseXMLUtils.writeImage(xMLPrintWriter, this.im);
        }
    }

    private static class DATE
    extends ObjectXMLWriter {
        private Date d;

        DATE(Date date) {
            this.d = date;
        }

        public String type() {
            return "Date";
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.textNode(String.valueOf(this.d.getTime()));
        }
    }

    private static class BIGD
    extends ToString {
        BIGD(BigDecimal bigDecimal) {
            this.ob = bigDecimal;
        }

        public String type() {
            return "BigDecimal";
        }
    }

    private static class BIGI
    extends ToString {
        BIGI(BigInteger bigInteger) {
            this.ob = bigInteger;
        }

        public String type() {
            return "BigInteger";
        }
    }

    private static class FLOAT
    extends ToString {
        FLOAT(Float f) {
            this.ob = f;
        }

        public String type() {
            return "F";
        }
    }

    private static class DOUBLE
    extends ToString {
        DOUBLE(Double d) {
            this.ob = d;
        }

        public String type() {
            return "D";
        }
    }

    private static class INTEGER
    extends ToString {
        INTEGER(Integer n) {
            this.ob = n;
        }

        public String type() {
            return "I";
        }
    }

    private static class BOOLEAN
    extends ToString {
        BOOLEAN(Boolean bl) {
            this.ob = bl;
        }

        public String type() {
            return "B";
        }
    }

    private static abstract class ToString
    extends ObjectXMLWriter {
        protected Object ob;

        private ToString() {
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.textNode(this.ob.toString());
        }
    }

    private static class NULL
    extends ObjectXMLWriter {
        private NULL() {
        }

        public String type() {
            return "NULL";
        }
    }

    private static abstract class ObjectXMLWriter
    implements XMLWriter {
        private ObjectXMLWriter() {
        }

        public String type() {
            return null;
        }

        public String className() {
            return null;
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
        }
    }
}

