/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.js;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.js.AbstractJavaScript;
import com.fr.report.js.Hyperlink;
import com.fr.util.Utils;
import com.fr.web.Repository;

public abstract class AbstractHyperlink
extends AbstractJavaScript
implements Hyperlink {
    private String targetFrame = "_blank";
    public static final String SELF_FRAME = "_self";
    public static final String BLANK_FRAME = "_blank";
    private static final String STATUS = "status";
    private static final String TOOLBAR = "toolbar";
    private static final String LOCATION = "location";
    private static final String MENUBAR = "menubar";
    private static final String RESIZABLE = "resizable";
    private static final String DIRECTORIES = "directories";
    private static final String SCROLLBARS = "scrollbars";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private boolean showStatus = true;
    private boolean showToolbar = true;
    private boolean showLocation = true;
    private boolean showMenubar = true;
    private boolean showDirectories = true;
    private boolean showScrollbars = true;
    private boolean resizable = true;
    private int width = 0;
    private int height = 0;

    public String features4NewWindow() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.width > 0) {
            stringBuffer.append(WIDTH).append("=").append(this.width).append(",");
        }
        if (this.height > 0) {
            stringBuffer.append(HEIGHT).append("=").append(this.height).append(",");
        }
        if (!(this.showStatus && this.showToolbar && this.showLocation && this.showMenubar && this.resizable && this.showDirectories && this.showScrollbars)) {
            stringBuffer.append(STATUS).append("=").append(this.showStatus ? 1 : 0).append(",").append(TOOLBAR).append("=").append(this.showToolbar ? 1 : 0).append(",").append(LOCATION).append("=").append(this.showLocation ? 1 : 0).append(",").append(MENUBAR).append("=").append(this.showMenubar ? 1 : 0).append(",").append(RESIZABLE).append("=").append(this.resizable ? 1 : 0).append(",").append(DIRECTORIES).append("=").append(this.showDirectories ? 1 : 0).append(",").append(SCROLLBARS).append("=").append(this.showScrollbars ? 1 : 0);
        }
        return stringBuffer.toString();
    }

    public String getTargetFrame() {
        return this.targetFrame;
    }

    public void setTargetFrame(String string) {
        this.targetFrame = string;
    }

    public boolean isShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(boolean bl) {
        this.showStatus = bl;
    }

    public boolean isShowToolbar() {
        return this.showToolbar;
    }

    public void setShowToolbar(boolean bl) {
        this.showToolbar = bl;
    }

    public boolean isShowLocation() {
        return this.showLocation;
    }

    public void setShowLocation(boolean bl) {
        this.showLocation = bl;
    }

    public boolean isShowMenubar() {
        return this.showMenubar;
    }

    public void setShowMenubar(boolean bl) {
        this.showMenubar = bl;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public boolean isShowDirectories() {
        return this.showDirectories;
    }

    public void setShowDirectories(boolean bl) {
        this.showDirectories = bl;
    }

    public boolean isShowScrollbars() {
        return this.showScrollbars;
    }

    public void setShowScrollbars(boolean bl) {
        this.showScrollbars = bl;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public String createJS(Repository repository) {
        return this.createURL(repository);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("TargetFrame")) {
                String string = null;
                string = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string)) {
                    this.setTargetFrame(string);
                }
            } else if (xMLableReader.getTagName().equals("Features")) {
                String string = null;
                string = xMLableReader.getAttr(STATUS);
                if (StringUtils.isNotBlank(string)) {
                    this.setShowStatus(Boolean.valueOf(string));
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getAttr(TOOLBAR))) {
                    this.setShowToolbar(Boolean.valueOf(string));
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getAttr(LOCATION))) {
                    this.setShowLocation(Boolean.valueOf(string));
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getAttr(MENUBAR))) {
                    this.setShowMenubar(Boolean.valueOf(string));
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getAttr(RESIZABLE))) {
                    this.setResizable(Boolean.valueOf(string));
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getAttr(DIRECTORIES))) {
                    this.setShowDirectories(Boolean.valueOf(string));
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getAttr(SCROLLBARS))) {
                    this.setShowScrollbars(Boolean.valueOf(string));
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getAttr(WIDTH))) {
                    this.setWidth(Utils.string2Number(string).intValue());
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getAttr(HEIGHT))) {
                    this.setHeight(Utils.string2Number(string).intValue());
                }
                if (StringUtils.isNotBlank(string = xMLableReader.getElementValue())) {
                    String string2 = string;
                    String[] stringArray = string2.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string3 = stringArray[i];
                        String string4 = string3.split("=")[0];
                        String string5 = string3.split("=")[1];
                        if (WIDTH.equalsIgnoreCase(string4)) {
                            this.setWidth(Utils.string2Number(string5).intValue());
                            continue;
                        }
                        if (HEIGHT.equalsIgnoreCase(string4)) {
                            this.setHeight(Utils.string2Number(string5).intValue());
                            continue;
                        }
                        if (STATUS.equalsIgnoreCase(string4)) {
                            this.setShowStatus(AbstractHyperlink.string2Boolean4XmlCompatation(string5));
                            continue;
                        }
                        if (TOOLBAR.equalsIgnoreCase(string4)) {
                            this.setShowToolbar(AbstractHyperlink.string2Boolean4XmlCompatation(string5));
                            continue;
                        }
                        if (LOCATION.equalsIgnoreCase(string4)) {
                            this.setShowLocation(AbstractHyperlink.string2Boolean4XmlCompatation(string5));
                            continue;
                        }
                        if (MENUBAR.equalsIgnoreCase(string4)) {
                            this.setShowMenubar(AbstractHyperlink.string2Boolean4XmlCompatation(string5));
                            continue;
                        }
                        if (RESIZABLE.equalsIgnoreCase(string4)) {
                            this.setResizable(AbstractHyperlink.string2Boolean4XmlCompatation(string5));
                            continue;
                        }
                        if (DIRECTORIES.equalsIgnoreCase(string4)) {
                            this.setShowDirectories(AbstractHyperlink.string2Boolean4XmlCompatation(string5));
                            continue;
                        }
                        if (!SCROLLBARS.equalsIgnoreCase(string4)) continue;
                        this.setShowScrollbars(AbstractHyperlink.string2Boolean4XmlCompatation(string5));
                    }
                }
            }
        }
    }

    private static boolean string2Boolean4XmlCompatation(String string) {
        if ("1".equals(string)) {
            return true;
        }
        if ("0".equals(string)) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.getTargetFrame())) {
            xMLPrintWriter.startTAG("TargetFrame").textNode(this.getTargetFrame()).end();
        }
        xMLPrintWriter.startTAG("Features").attr(STATUS, this.showStatus).attr(TOOLBAR, this.showToolbar).attr(LOCATION, this.showLocation).attr(MENUBAR, this.showMenubar).attr(RESIZABLE, this.resizable).attr(DIRECTORIES, this.showDirectories).attr(SCROLLBARS, this.showScrollbars);
        if (this.width > 0) {
            xMLPrintWriter.attr(WIDTH, this.width);
        }
        if (this.height > 0) {
            xMLPrintWriter.attr(HEIGHT, this.height);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractHyperlink)) {
            return false;
        }
        return super.equals(object) && this.showDirectories == ((AbstractHyperlink)object).showDirectories && this.showScrollbars == ((AbstractHyperlink)object).showScrollbars && this.showLocation == ((AbstractHyperlink)object).showLocation && this.showMenubar == ((AbstractHyperlink)object).showMenubar && this.showStatus == ((AbstractHyperlink)object).showStatus && this.showToolbar == ((AbstractHyperlink)object).showToolbar && this.resizable == ((AbstractHyperlink)object).resizable && this.height == ((AbstractHyperlink)object).height && this.width == ((AbstractHyperlink)object).width && ComparatorUtils.equals(this.targetFrame, ((AbstractHyperlink)object).targetFrame);
    }
}

