/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.js;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.js.AbstractJavaScript;
import com.fr.report.js.CallBackable;
import com.fr.report.js.JavaScript;
import com.fr.report.js.JavaScriptImpl;
import com.fr.report.parameter.Parameter;
import com.fr.web.Repository;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public class AjaxJavaScript
extends AbstractJavaScript
implements CallBackable {
    private static final String XML_TAG = "AjaxAttr";
    private boolean async = true;
    private String initContent;
    private String url;
    private String dataType = "auto";
    private JavaScript callBack;

    public String createJS(Repository repository) {
        Map map = repository.checkoutTplContext();
        Parameter[] parameterArray = this.getParameters();
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < parameterArray.length; ++i) {
            try {
                jSONObject.put(parameterArray[i].getName(), parameterArray[i].getValue());
                continue;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
        }
        String string = TemplateUtils.readTemplate2String("/com/fr/report/js/ajaxScript.tpl", "GBK");
        map.put("initContent", this.initContent);
        map.put("url", this.url);
        map.put("async", new Boolean(this.async));
        map.put("data", jSONObject.toString());
        map.put("dataType", this.dataType);
        map.put("complete", "function(res, status){" + (this.callBack != null ? this.callBack.createJS(repository) : "") + "}");
        try {
            return TemplateUtils.render(TemplateUtils.render(string, map), map);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getInitContent() {
        return this.initContent;
    }

    public void setInitContent(String string) {
        this.initContent = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean bl) {
        this.async = bl;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public void setCallBack(JavaScript javaScript) {
        this.callBack = javaScript;
    }

    public JavaScript getCallBack() {
        return this.callBack;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(XML_TAG)) {
                this.initContent = xMLableReader.getAttr("init");
                this.url = xMLableReader.getAttr("url");
                this.async = xMLableReader.getAttr("async") == null;
                String string2 = xMLableReader.getAttr("data");
                if (StringUtils.isNotBlank(string2)) {
                    this.readPara(string2);
                }
                this.dataType = xMLableReader.getAttr("dataType");
                String string3 = xMLableReader.getAttr("complete");
                if (StringUtils.isNotEmpty(string3)) {
                    this.setCallBack(new JavaScriptImpl(string3));
                }
            } else if ("JavaScript".equals(string)) {
                this.setCallBack(ReportXMLUtils.readJavaScript(xMLableReader));
            }
        }
    }

    private void readPara(String string) {
        Parameter[] parameterArray = this.getParameters();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (parameterArray.length > 0) {
            for (int i = 0; i < parameterArray.length; ++i) {
                arrayList.add(parameterArray[i]);
            }
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                arrayList.add(new Parameter(e.toString(), jSONObject.opt(e.toString())));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.setParameters(arrayList.toArray(new Parameter[0]));
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotBlank(this.initContent)) {
            xMLPrintWriter.attr("init", this.initContent);
        }
        if (StringUtils.isNotBlank(this.url)) {
            xMLPrintWriter.attr("url", this.url);
        }
        if (!this.async) {
            xMLPrintWriter.attr("async", this.async);
        }
        if (StringUtils.isNotBlank(this.dataType)) {
            xMLPrintWriter.attr("dataType", this.dataType);
        }
        if (this.getCallBack() != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.getCallBack(), "JavaScript");
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AjaxJavaScript && super.equals(object) && ((AjaxJavaScript)object).async == this.async && ComparatorUtils.equals(((AjaxJavaScript)object).getCallBack(), this.getCallBack()) && ComparatorUtils.equals(((AjaxJavaScript)object).dataType, this.dataType) && ComparatorUtils.equals(((AjaxJavaScript)object).initContent, this.initContent) && ComparatorUtils.equals(((AjaxJavaScript)object).url, this.url);
    }

    public Object clone() throws CloneNotSupportedException {
        AjaxJavaScript ajaxJavaScript = (AjaxJavaScript)super.clone();
        if (this.callBack != null) {
            ajaxJavaScript.callBack = (JavaScript)this.callBack.clone();
        }
        return ajaxJavaScript;
    }
}

