/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.js;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.js.AbstractHyperlink;
import com.fr.web.Repository;

public class EmailHyperlink
extends AbstractHyperlink {
    private String email = "";
    private String sentMailMethod = "FR.sentEMail";

    public EmailHyperlink() {
    }

    public EmailHyperlink(String string) {
        this(string, "");
    }

    public EmailHyperlink(String string, String string2) {
        this.setEmail(string);
        this.setTargetFrame(string2);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Email") && StringUtils.isNotBlank(string = xMLableReader.getElementValue())) {
            this.setEmail(string);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Email").textNode(this.getEmail()).end();
        xMLPrintWriter.end();
    }

    public String createURL(Repository repository) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sentMailMethod).append("(\"");
        if (this.getEmail().toLowerCase().startsWith("mailto:")) {
            stringBuffer.append(this.getEmail());
        } else {
            stringBuffer.append("mailto:").append(this.getEmail());
        }
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EmailHyperlink)) {
            return false;
        }
        return super.equals(object) && ComparatorUtils.equals(this.email, ((EmailHyperlink)object).email);
    }
}

