/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.js;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.js.AbstractJavaScript;
import com.fr.report.js.CallBackable;
import com.fr.report.js.JavaScript;
import com.fr.report.js.JavaScriptImpl;
import com.fr.report.parameter.Parameter;
import com.fr.web.Repository;
import java.util.Map;
import java.util.logging.Level;

public class FormSubmitJavaScript
extends AbstractJavaScript
implements CallBackable {
    private String action = "";
    private boolean asynchronous = true;
    private JavaScript callBack;

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setCallBack(JavaScript javaScript) {
        this.callBack = javaScript;
    }

    public JavaScript getCallBack() {
        return this.callBack;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean bl) {
        this.asynchronous = bl;
    }

    public String createJS(Repository repository) {
        Map map = repository.checkoutTplContext();
        Parameter[] parameterArray = this.getParameters();
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < parameterArray.length; ++i) {
            try {
                jSONObject.put(parameterArray[i].getName(), parameterArray[i].getValue());
                continue;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("var config={");
        stringBuffer.append("url:\"" + this.action + "\",");
        stringBuffer.append("asyn:" + this.asynchronous + ",");
        stringBuffer.append("data:" + jSONObject.toString() + ",");
        stringBuffer.append("callback: function(){" + (this.callBack != null ? this.callBack.createJS(repository) : "") + "}");
        stringBuffer.append("};");
        stringBuffer.append("this.options.form.formSubmit(config);");
        String string = stringBuffer.toString();
        try {
            return TemplateUtils.render(string, map);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return string;
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Action")) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setAction(string2);
                }
            } else if (string.equals("Asyn")) {
                if (xMLableReader.getElementValue() != null) {
                    this.setAsynchronous(false);
                }
            } else if (string.equals("CallBack")) {
                String string3 = null;
                string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.setCallBack(new JavaScriptImpl(string3));
                }
            } else if ("JavaScript".equals(string)) {
                this.setCallBack(ReportXMLUtils.readJavaScript(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!StringUtils.isEmpty(this.action)) {
            xMLPrintWriter.startTAG("Action").textNode(this.action).end();
        }
        if (!this.asynchronous) {
            xMLPrintWriter.startTAG("Asyn").textNode(String.valueOf(this.asynchronous)).end();
        }
        if (this.getCallBack() != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.getCallBack(), "JavaScript");
        }
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof FormSubmitJavaScript && ComparatorUtils.equals(((FormSubmitJavaScript)object).action, this.action) && ((FormSubmitJavaScript)object).asynchronous == this.asynchronous;
    }

    public Object clone() throws CloneNotSupportedException {
        FormSubmitJavaScript formSubmitJavaScript = (FormSubmitJavaScript)super.clone();
        if (this.callBack != null) {
            formSubmitJavaScript.callBack = (JavaScript)this.callBack.clone();
        }
        return formSubmitJavaScript;
    }
}

