/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.js;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONUtils;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.cellElement.Formula;
import com.fr.report.js.AbstractJavaScript;
import com.fr.report.parameter.Parameter;
import com.fr.web.Repository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JavaScriptImpl
extends AbstractJavaScript {
    private List jsImportList = null;
    private String content;

    public JavaScriptImpl() {
    }

    public JavaScriptImpl(String string) {
        this.content = string;
    }

    public String createJS(Repository repository) {
        Map map = repository.checkoutTplContext();
        Parameter[] parameterArray = this.getParameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            Object object = parameterArray[i].getValue();
            if (object instanceof Formula) {
                object = ((Formula)object).getResult() != null ? ((Formula)object).getResult() : object;
            }
            map.put(parameterArray[i].getName(), object);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getJSImportSize();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("FR.$import(\"" + CodeUtils.javascriptEncode(this.getJSImport(i)) + "\"" + ", 'js'); ");
        }
        if (StringUtils.isNotBlank(this.content)) {
            stringBuffer.append(this.createContentFunction());
        }
        String string = stringBuffer.toString();
        try {
            return TemplateUtils.render(string, map);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return string;
        }
    }

    private String createContentFunction() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(";return (function(");
        Parameter[] parameterArray = this.getParameters();
        for (n = 0; n < parameterArray.length; ++n) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(parameterArray[n].getName());
        }
        stringBuffer.append("){" + (this.content == null ? "" : this.content) + "})");
        stringBuffer.append(".createDelegate(this, [");
        for (n = 0; n < parameterArray.length; ++n) {
            Object object;
            if (n != 0) {
                stringBuffer.append(",");
            }
            if ((object = parameterArray[n].getValue()) instanceof Formula) {
                Object object2 = object = ((Formula)object).getResult() != null ? ((Formula)object).getResult() : object;
            }
            if ((object = JSONUtils.quoteFrObject(object)) != null && "".equals(object.toString())) {
                object = null;
            }
            stringBuffer.append(object);
        }
        stringBuffer.append("], 0).apply(this, arguments);");
        return stringBuffer.toString();
    }

    public int getJSImportSize() {
        return this.jsImportList == null ? 0 : this.jsImportList.size();
    }

    public String getJSImport(int n) {
        return this.jsImportList == null ? null : (String)this.jsImportList.get(n);
    }

    public void addJSImort(String string) {
        if (this.jsImportList == null) {
            this.jsImportList = new ArrayList();
        }
        this.jsImportList.add(string);
    }

    public void clearJSImports() {
        if (this.jsImportList != null) {
            this.jsImportList.clear();
            this.jsImportList = null;
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.clearJSImports();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Content")) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setContent(string2);
                }
            } else if (string.equals("JSImport")) {
                String string3 = null;
                string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.addJSImort(string3);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        int n = this.getJSImportSize();
        for (int i = 0; i < n; ++i) {
            xMLPrintWriter.startTAG("JSImport").textNode(this.getJSImport(i)).end();
        }
        xMLPrintWriter.startTAG("Content").textNode(this.getContent()).end();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JavaScriptImpl) || !super.equals(object)) {
            return false;
        }
        return ComparatorUtils.equals(this.getContent(), ((JavaScriptImpl)object).getContent()) && ComparatorUtils.equals(this.jsImportList, ((JavaScriptImpl)object).jsImportList);
    }

    public Object clone() throws CloneNotSupportedException {
        JavaScriptImpl javaScriptImpl = (JavaScriptImpl)super.clone();
        if (this.jsImportList != null) {
            javaScriptImpl.jsImportList = new ArrayList();
            javaScriptImpl.jsImportList.addAll(this.jsImportList);
        }
        return javaScriptImpl;
    }
}

