/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.js;

import com.fr.base.CodeUtils;
import com.fr.base.DefaultValues;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.cellElement.Formula;
import com.fr.report.js.AbstractHyperlink;
import com.fr.report.parameter.Parameter;
import com.fr.util.Utils;
import com.fr.web.Repository;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public class ReportletHyperlink
extends AbstractHyperlink {
    private String reportPath = "";
    private String postMethod = "FR.doHyperlinkByPost";
    private String getMethod = "FR.doHyperlinkByGet";
    private boolean extendParameters = false;
    private boolean showParameterInterface = false;
    private boolean byPost = false;

    public ReportletHyperlink() {
    }

    public ReportletHyperlink(String string) {
        this(string, "");
    }

    public ReportletHyperlink(String string, String string2) {
        this.setReportletPath(string);
        this.setTargetFrame(string2);
    }

    public String getReportletPath() {
        return this.reportPath;
    }

    public void setReportletPath(String string) {
        this.reportPath = string;
    }

    public boolean isExtendParameters() {
        return this.extendParameters;
    }

    public void setExtendParameters(boolean bl) {
        this.extendParameters = bl;
    }

    public boolean isShowParameterInterface() {
        return this.showParameterInterface;
    }

    public void setShowParameterInterface(boolean bl) {
        this.showParameterInterface = bl;
    }

    public boolean isByPost() {
        return this.byPost;
    }

    public void setByPost(boolean bl) {
        this.byPost = bl;
    }

    public String createURL(Repository repository) {
        try {
            return this.createReportPath(repository);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    private String createReportPath(Repository repository) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.byPost) {
            stringBuffer.append(this.postMethod);
        } else {
            stringBuffer.append(this.getMethod);
        }
        stringBuffer.append("(\"");
        stringBuffer.append(repository.checkoutReportletPath(this.getReportletPath()));
        stringBuffer.append("\", ");
        stringBuffer.append(this.createParaPath(repository));
        stringBuffer.append(", \"");
        stringBuffer.append(this.getTargetFrame());
        stringBuffer.append("\", \"");
        stringBuffer.append(this.features4NewWindow());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    private JSONObject createParaPath(Repository repository) throws Exception {
        Map map;
        Object object;
        Parameter[] parameterArray;
        JSONObject jSONObject = new JSONObject();
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                parameterArray = this.parameters[i];
                Object object2 = parameterArray.getValue();
                String string = "";
                if (object2 != null) {
                    if (object2 instanceof Formula) {
                        object2 = ((Formula)object2).getResult();
                    }
                    if (object2 == null) continue;
                    if (object2 instanceof Date) {
                        object = FRContext.getDefaultValues();
                        string = ((DefaultValues)object).getDateTimeFormat().format(object2);
                    } else {
                        string = object2 instanceof Double ? Utils.doubleToString((Double)object2) : object2.toString();
                    }
                }
                jSONObject.put(CodeUtils.cjkEncode(parameterArray.getName()), CodeUtils.cjkEncode(string));
            }
        }
        jSONObject.put("__pi__", this.showParameterInterface);
        if (this.isExtendParameters() && (map = repository.getSessionIDInfor().getParameterMap4Execute()) != null) {
            parameterArray = repository.getSessionIDInfor().getWorkBookDefine() == null ? new Parameter[]{} : repository.getSessionIDInfor().getWorkBookDefine().getParameters();
            int n = parameterArray.length;
            for (int i = 0; i < n; ++i) {
                if (map.get(parameterArray[i].getName()) != null) continue;
                object = parameterArray[i].getValue();
                if (object instanceof Formula) {
                    object = ((Formula)parameterArray[i].getValue()).getResult();
                }
                map.put(parameterArray[i].getName(), object);
            }
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                jSONObject.put(CodeUtils.cjkEncode((String)entry.getKey()), CodeUtils.cjkEncode("" + entry.getValue()));
            }
        }
        return jSONObject;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ReportletName");
        if (this.isExtendParameters()) {
            xMLPrintWriter.attr("extendParameters", this.isExtendParameters());
        }
        if (this.isShowParameterInterface()) {
            xMLPrintWriter.attr("showPI", this.isShowParameterInterface());
        }
        if (this.byPost) {
            xMLPrintWriter.attr("byPost", this.byPost);
        }
        xMLPrintWriter.textNode(this.getReportletPath());
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ReportletName")) {
            String string = xMLableReader.getAttr("extendParameters");
            if (StringUtils.isNotBlank(string)) {
                this.setExtendParameters(Boolean.valueOf(string));
            }
            if (StringUtils.isNotBlank(string = xMLableReader.getAttr("showPI"))) {
                this.setShowParameterInterface(Boolean.valueOf(string));
            }
            if (StringUtils.isNotBlank(string = xMLableReader.getAttr("byPost"))) {
                this.setByPost(Boolean.valueOf(string));
            }
            if (StringUtils.isNotBlank(string = xMLableReader.getElementValue())) {
                this.setReportletPath(string);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReportletHyperlink)) {
            return false;
        }
        return super.equals(object) && this.extendParameters == ((ReportletHyperlink)object).extendParameters && ComparatorUtils.equals(this.reportPath, ((ReportletHyperlink)object).reportPath) && this.byPost == ((ReportletHyperlink)object).byPost;
    }
}

