/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.js;

import com.fr.base.FRContext;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.js.AbstractJavaScript;
import com.fr.report.js.CallBackable;
import com.fr.report.js.JavaScript;
import com.fr.web.Repository;
import java.util.Map;

public abstract class ServerJavaScript
extends AbstractJavaScript
implements CallBackable {
    public static final String XML_TAG = "ServerJS";
    public static final int TYPE_PROCESSOR = 0;
    public static final int TYPE_URL = 1;
    private int type = 0;
    private String path = null;
    private JavaScript callBack;

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public JavaScript getCallBack() {
        return this.callBack;
    }

    public void setCallBack(JavaScript javaScript) {
        this.callBack = javaScript;
    }

    public String createJS(Repository repository) {
        Map map = repository.checkoutTplContext();
        if (this.type == 0) {
            map.put("url", map.get("servletURL"));
            map.put("data", "{op : 'serverjs_',class : '" + this.path + "'}");
        } else {
            map.put("url", this.path);
            map.put("data", "{}");
        }
        map.put("async", "true");
        map.put("params", "{}");
        try {
            String string = TemplateUtils.render("$.ajax({url : '${url}',type : 'POST',data : $.extend(${data}, ${params}),async : ${async},complete : function(res, status) {" + (this.callBack == null ? "" : this.callBack.createJS(repository)) + "}});", map);
            return string;
        }
        catch (Exception exception) {
            FRContext.getLogger().warning(exception.getMessage());
            return null;
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.isAttr()) {
            string = xMLableReader.getAttr("type");
            if (string != null) {
                this.setType(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("path")) != null) {
                this.setPath(string);
            }
        }
        if (xMLableReader.isChildNode() && "JavaScript".equals(xMLableReader.getTagName())) {
            this.setCallBack(ReportXMLUtils.readJavaScript(xMLableReader));
        }
        super.readXML(xMLableReader);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("type", this.type).attr("path", this.path);
        if (this.callBack != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.callBack, "JavaScript");
        }
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ServerJavaScript serverJavaScript = (ServerJavaScript)super.clone();
        if (this.callBack != null) {
            serverJavaScript.callBack = (JavaScript)this.callBack.clone();
        }
        return serverJavaScript;
    }
}

