/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.js;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.js.AbstractHyperlink;
import com.fr.report.parameter.Parameter;
import com.fr.web.Repository;
import java.util.logging.Level;

public class WebHyperlink
extends AbstractHyperlink {
    private String url = "";
    private boolean useCJK = true;

    public WebHyperlink() {
    }

    public WebHyperlink(String string) {
        this(string, "");
    }

    public WebHyperlink(String string, String string2) {
        this.setURL(string);
        this.setTargetFrame(string2);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public boolean isUseCJK() {
        return this.useCJK;
    }

    public void setUseCJK(boolean bl) {
        this.useCJK = bl;
    }

    public String createURL(Repository repository) {
        try {
            return this.createWebPath(repository);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    private String createWebPath(Repository repository) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FR.doHyperlinkByGet");
        stringBuffer.append("(\"");
        stringBuffer.append(CodeUtils.encodeURIComponent(CodeUtils.cjkEncode(this.getURL())));
        stringBuffer.append("\", ");
        stringBuffer.append(this.createParaPath(repository));
        stringBuffer.append(", \"");
        stringBuffer.append(this.getTargetFrame());
        stringBuffer.append("\", \"");
        stringBuffer.append(this.features4NewWindow());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    private JSONObject createParaPath(Repository repository) throws Exception {
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter parameter = this.parameters[i];
            Object object = parameter.getValue();
            if (object == null) continue;
            jSONObject.put(this.useCJK ? CodeUtils.cjkEncode(parameter.getName()) : parameter.getName(), this.useCJK ? CodeUtils.cjkEncode(parameter.valueToString()) : parameter.valueToString());
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("URL")) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string2)) {
                    this.setURL(string2);
                }
            } else if (string.equals("CJK")) {
                String string3 = null;
                string3 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string3)) {
                    this.setUseCJK(Boolean.valueOf(string3));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("URL").textNode(this.getURL()).end();
        if (!this.isUseCJK()) {
            xMLPrintWriter.startTAG("CJK").textNode(String.valueOf(this.isUseCJK())).end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WebHyperlink)) {
            return false;
        }
        return super.equals(object) && this.useCJK == ((WebHyperlink)object).useCJK && ComparatorUtils.equals(this.url, ((WebHyperlink)object).url);
    }
}

