/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.painter;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.xml.XMLableReader;
import com.fr.report.cellElement.BarcodeAttr;
import com.fr.report.core.barcode.BarCodeUtils;
import com.fr.report.core.barcode.BarcodeException;
import com.fr.report.core.barcode.BarcodeImpl;
import com.fr.report.painter.AbstractPainter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Level;

public class BarcodePainter
extends AbstractPainter {
    private String text = null;
    private BarcodeAttr barcodeAttr;

    public BarcodePainter(BarcodeAttr barcodeAttr, String string) {
        this.barcodeAttr = barcodeAttr;
        this.setText(string);
    }

    public BarcodeAttr getBarcodeAttr() {
        return this.barcodeAttr;
    }

    public void setBarcodeAttr(BarcodeAttr barcodeAttr) {
        this.barcodeAttr = barcodeAttr;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = StringUtils.containChinese(string) ? null : string;
    }

    public void paint(Graphics graphics, int n, int n2, Style style) {
        if (this.text == null) {
            return;
        }
        try {
            Background background;
            BarcodeImpl barcodeImpl = BarCodeUtils.getBarcodeImpl(this);
            if (style.getFRFont() != null) {
                barcodeImpl.setFont(style.getFRFont());
                barcodeImpl.setForeground(style.getFRFont().getForeground());
            }
            if ((background = style.getBackground()) != null && background instanceof ColorBackground) {
                barcodeImpl.setBackground(((ColorBackground)background).getColor());
            }
            double d = (n - barcodeImpl.getWidth()) / 2;
            double d2 = (n2 - barcodeImpl.getHeight()) / 2;
            barcodeImpl.draw((Graphics2D)graphics, (int)d, (int)d2);
        }
        catch (BarcodeException barcodeException) {
            FRContext.getLogger().log(Level.WARNING, barcodeException.getMessage(), barcodeException);
        }
    }

    public String toString() {
        return "";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void readXML(XMLableReader xMLableReader) {
    }
}

