/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.painter;

import com.fr.base.FRFont;
import com.fr.base.Style;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.list.IntList;
import com.fr.base.core.serializable.Point2DSerializable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.painter.AbstractPainter;
import com.fr.report.painter.BiasZone;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class BiasTextPainter
extends AbstractPainter {
    private String text = null;
    private List angleList = new ArrayList();
    private transient List lineEndList = new ArrayList();
    private List textList = new ArrayList();
    private List isLargeDiagonal = new ArrayList();
    private boolean isCenter = false;
    private boolean isBackSlash = false;

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n > 0) {
            if (this.lineEndList == null) {
                this.lineEndList = new ArrayList();
            }
            this.lineEndList.clear();
            for (int i = 0; i < n; ++i) {
                Object object = objectInputStream.readObject();
                if (object == null) continue;
                this.lineEndList.add(((Point2DSerializable)object).getPoint2D());
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.lineEndList.size());
        for (int i = 0; i < this.lineEndList.size(); ++i) {
            Point2D point2D = (Point2D)this.lineEndList.get(i);
            objectOutputStream.writeObject(new Point2DSerializable(point2D));
        }
    }

    public BiasTextPainter(String string) {
        this.setText(string);
    }

    private void generateTextListAndAngleList() {
        int n;
        int n2;
        this.angleList.clear();
        this.lineEndList.clear();
        this.textList.clear();
        this.isLargeDiagonal.clear();
        int n3 = this.getText().length();
        IntList intList = new IntList();
        intList.add(0);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.getText().charAt(n2) != '|') continue;
            n = intList.get(intList.size() - 1);
            if (n2 != n) {
                intList.add(n2 + 1);
                String string = this.getText().substring(n, n2);
                this.getTextList().add(string);
                continue;
            }
            intList.add(n2 + 1);
            this.getTextList().add(" ");
        }
        n2 = intList.get(intList.size() - 1);
        if (n2 == n3) {
            this.getTextList().add(" ");
        } else {
            this.getTextList().add(this.getText().substring(intList.get(intList.size() - 1), n3));
        }
        for (n = 1; n < intList.size(); ++n) {
            if (this.isBackSlash) {
                this.getAngleList().add(new Double(90 / intList.size() * (intList.size() - n)));
                continue;
            }
            this.getAngleList().add(new Double(90 / intList.size() * n));
        }
    }

    public void setAngle(int n, double d, double d2, double d3) {
        double d4;
        double d5;
        this.getAngleList().set(n, new Double(d));
        double d6 = d3 / d2;
        if (d6 > Math.tan(d / 180.0 * Math.PI)) {
            this.getLargeDiagonal().set(n, Boolean.FALSE);
            if (this.isBackSlash) {
                d5 = d2;
                d4 = -d2 * Math.tan(d / 180.0 * Math.PI);
            } else {
                d5 = d2;
                d4 = d2 * Math.tan(d / 180.0 * Math.PI);
            }
        } else {
            this.getLargeDiagonal().set(n, Boolean.TRUE);
            if (this.isBackSlash) {
                d4 = -d3;
                d5 = d3 / Math.tan(d / 180.0 * Math.PI);
            } else {
                d4 = d3;
                d5 = d3 / Math.tan(d / 180.0 * Math.PI);
            }
        }
        this.getLineEndList().set(n, new Point2D.Double(d5, d4));
    }

    public void generateLineEndList(double d, double d2) {
        ArrayList<Point2D.Double> arrayList = this.getLineEndList();
        if (arrayList == null) {
            arrayList = new ArrayList<Point2D.Double>();
            this.setLineEndList(arrayList);
        }
        arrayList.clear();
        double d3 = d2 / d;
        for (int i = 0; i < this.getAngleList().size(); ++i) {
            double d4;
            double d5;
            double d6 = (Double)this.getAngleList().get(i) / 180.0 * Math.PI;
            if (d3 > Math.tan(d6)) {
                this.getLargeDiagonal().add(Boolean.FALSE);
                if (this.isBackSlash) {
                    d5 = d;
                    d4 = -d * Math.tan(d6);
                } else {
                    d5 = d;
                    d4 = d * Math.tan(d6);
                }
            } else {
                this.getLargeDiagonal().add(Boolean.TRUE);
                if (this.isBackSlash) {
                    d4 = -d2;
                    d5 = d2 / Math.tan(d6);
                } else {
                    d4 = d2;
                    d5 = d2 / Math.tan(d6);
                }
            }
            arrayList.add(new Point2D.Double(d5, d4));
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.generateTextListAndAngleList();
    }

    public List getAngleList() {
        return this.angleList;
    }

    public void setAngleList(List list) {
        this.angleList = list;
    }

    public List getLineEndList() {
        return this.lineEndList;
    }

    public void setLineEndList(List list) {
        this.lineEndList = list;
    }

    public List getTextList() {
        return this.textList;
    }

    public void setTextList(List list) {
        this.textList = list;
    }

    public List getLargeDiagonal() {
        return this.isLargeDiagonal;
    }

    public void setLargeDiagonal(List list) {
        this.isLargeDiagonal = list;
    }

    public void setIsBackSlash(boolean bl) {
        this.isBackSlash = bl;
    }

    public boolean getIsBackSlash() {
        return this.isBackSlash;
    }

    public void paint(Graphics graphics, int n, int n2, Style style) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintBiasString(graphics2D, new Rectangle2D.Double(0.0, 0.0, n, n2), new Rectangle2D.Double(0.0, 0.0, n, n2), this.text, style);
    }

    private void paintBiasString(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, String string, Style style) {
        if (string == null || string.indexOf("|") == -1) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (this.isBackSlash) {
            graphics2D2.translate(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
        } else {
            graphics2D2.translate(rectangle2D.getX(), rectangle2D.getY());
        }
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D2.setStroke(graphics2D2.getStroke());
        if (string.length() > 0) {
            int n;
            Color color;
            FRFont fRFont;
            if (style == null) {
                style = Style.DEFAULT_STYLE;
            }
            if (!ComparatorUtils.equals(fRFont = style.getFRFont(), graphics2D2.getFont())) {
                graphics2D2.setFont(fRFont);
            }
            if (!ComparatorUtils.equals(color = fRFont.getForeground(), graphics2D2.getPaint())) {
                graphics2D2.setPaint(color);
            }
            this.generateLineEndList(rectangle2D.getWidth(), rectangle2D.getHeight());
            int n2 = this.textList.size();
            BiasZone[] biasZoneArray = new BiasZone[n2];
            if (n2 == 2) {
                n = 0;
                this.setAngle(0, Math.atan2(rectangle2D.getHeight(), rectangle2D.getWidth()) * 180.0 / Math.PI, rectangle2D.getWidth(), rectangle2D.getHeight());
                if (this.isBackSlash) {
                    biasZoneArray[0] = new BiasZone(rectangle2D, 90.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 1, n != 0, this.isBackSlash);
                    biasZoneArray[1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(0), 0.0, (String)this.getTextList().get(1), style, 2, n != 0, this.isBackSlash);
                } else {
                    biasZoneArray[0] = new BiasZone(rectangle2D, 0.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 1, n != 0, this.isBackSlash);
                    biasZoneArray[1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(0), 90.0, (String)this.getTextList().get(1), style, 2, n != 0, this.isBackSlash);
                }
            } else if (n2 == 3) {
                boolean bl;
                double d;
                if (this.isBackSlash) {
                    double d2 = 180.0 * Math.atan(2.0 * rectangle2D.getHeight() / 3.0 / rectangle2D.getWidth()) / Math.PI;
                    d = 180.0 * (1.5707963267948966 - Math.atan(2.0 * rectangle2D.getWidth() / 3.0 / rectangle2D.getHeight())) / Math.PI;
                    this.setAngle(0, d, rectangle2D.getWidth(), rectangle2D.getHeight());
                    this.setAngle(1, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
                    bl = false;
                    biasZoneArray[0] = new BiasZone(rectangle2D, 90.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 1, bl, this.isBackSlash);
                    biasZoneArray[1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(0), (Double)this.getAngleList().get(1), (String)this.getTextList().get(1), style, 3, this.isCenter, this.isBackSlash);
                    biasZoneArray[2] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(1), 0.0, (String)this.getTextList().get(2), style, 2, bl, this.isBackSlash);
                } else {
                    double d3 = 180.0 * Math.atan(2.0 * rectangle2D.getHeight() / 3.0 / rectangle2D.getWidth()) / Math.PI;
                    d = 180.0 * (1.5707963267948966 - Math.atan(2.0 * rectangle2D.getWidth() / 3.0 / rectangle2D.getHeight())) / Math.PI;
                    this.setAngle(0, d3, rectangle2D.getWidth(), rectangle2D.getHeight());
                    this.setAngle(1, d, rectangle2D.getWidth(), rectangle2D.getHeight());
                    bl = false;
                    biasZoneArray[0] = new BiasZone(rectangle2D, 0.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 1, bl, this.isBackSlash);
                    biasZoneArray[1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(0), (Double)this.getAngleList().get(1), (String)this.getTextList().get(1), style, 3, this.isCenter, this.isBackSlash);
                    biasZoneArray[2] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(1), 90.0, (String)this.getTextList().get(2), style, 2, bl, this.isBackSlash);
                }
            } else if (this.isBackSlash) {
                biasZoneArray[0] = new BiasZone(rectangle2D, 90.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 3, this.isCenter, this.isBackSlash);
                biasZoneArray[n2 - 1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(this.getAngleList().size() - 1), 0.0, (String)this.getTextList().get(this.getTextList().size() - 1), style, 3, this.isCenter, this.isBackSlash);
                for (int i = 1; i < n2 - 1; ++i) {
                    biasZoneArray[i] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(i - 1), (Double)this.getAngleList().get(i), (String)this.getTextList().get(i), style, 3, this.isCenter, this.isBackSlash);
                }
            } else {
                biasZoneArray[0] = new BiasZone(rectangle2D, 0.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 3, this.isCenter, this.isBackSlash);
                biasZoneArray[n2 - 1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(this.getAngleList().size() - 1), 90.0, (String)this.getTextList().get(this.getTextList().size() - 1), style, 3, this.isCenter, this.isBackSlash);
                for (int i = 1; i < n2 - 1; ++i) {
                    biasZoneArray[i] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(i - 1), (Double)this.getAngleList().get(i), (String)this.getTextList().get(i), style, 3, this.isCenter, this.isBackSlash);
                }
            }
            for (n = 0; n < n2; ++n) {
                biasZoneArray[n].paintZone(graphics2D2);
            }
            for (n = 0; n < this.getLineEndList().size(); ++n) {
                Point2D point2D = (Point2D)this.getLineEndList().get(n);
                graphics2D2.draw(new Line2D.Double(0.0, 0.0, point2D.getX(), point2D.getY()));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof BiasTextPainter)) {
            return false;
        }
        return ComparatorUtils.equals(this.getText(), ((BiasTextPainter)object).getText()) && ComparatorUtils.equals(new Boolean(this.getIsBackSlash()), new Boolean(((BiasTextPainter)object).isBackSlash));
    }

    public String toString() {
        return "";
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("IsBackSlash") && (string = xMLableReader.getAttr("value")) != null) {
            this.setIsBackSlash(Boolean.valueOf(string));
        }
        if (xMLableReader.isCharacters()) {
            this.setText(xMLableReader.getContent());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("IsBackSlash").attr("value", this.isBackSlash).end().textNode(this.text);
    }
}

