/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.painter;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.Converter;
import com.fr.data.core.db.BinaryObject;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.ReportHF;
import com.fr.report.ReportPage;
import com.fr.report.ReportSettings;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.cellElement.CoverCellElement;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.util.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public class PagePainter
implements Converter {
    private Graphics2D g2d;
    private boolean isPrint;
    private ReportPage reportPage;

    public PagePainter(ReportPage reportPage, Graphics2D graphics2D, boolean bl) {
        this.reportPage = reportPage;
        this.g2d = graphics2D;
        this.isPrint = bl;
    }

    public void convert() {
        this.preparePaint();
        this.paintPage();
        this.g2d.dispose();
    }

    private void paintPage() {
        DynamicValueList dynamicValueList = ReportHelper.createColumnWidthList(this.reportPage);
        DynamicValueList dynamicValueList2 = ReportHelper.createRowHeightList(this.reportPage);
        this.prepareCell(this.reportPage.cellIterator(), dynamicValueList, dynamicValueList2);
        this.prepareFloat(this.reportPage.floatIterator(), dynamicValueList, dynamicValueList2);
    }

    private void preparePaint() {
        ReportSettings reportSettings = this.reportPage.getReportSettings();
        int n = this.reportPage.getPageWidth();
        int n2 = this.reportPage.getPageHeight();
        int n3 = this.reportPage.getMarginTop();
        int n4 = this.reportPage.getMarginLeft();
        int n5 = this.reportPage.getMarginBottom();
        int n6 = this.reportPage.getMarginRight();
        if ((double)n > 100000.0 || (double)n2 > 100000.0 || (double)(n * n2) > 4.0E8) {
            FRContext.getLogger().log(Level.INFO, Inter.getLocText("Page_OutOfLimit_Msg"));
        }
        if (this.isPrint) {
            double d = 72.0 / (double)reportSettings.getResolution();
            this.g2d.scale(d, d);
        } else {
            ColorBackground.getInstance(Color.white).paint(this.g2d, new Rectangle2D.Double(0.0, 0.0, n, n2));
        }
        int n7 = n - n4 - n6;
        this.prepareHF(n7, reportSettings);
        this.prepareContentArea(this.g2d, new Rectangle2D.Double(n4, n3 + ReportUtils.getHeaderHeight(reportSettings), n7, n2 - n3 - n5 - ReportUtils.getHeaderHeight(reportSettings) - ReportUtils.getFooterHeight(reportSettings)), reportSettings, this.isPrint);
    }

    protected void prepareHF(int n, ReportSettings reportSettings) {
        ReportHF reportHF;
        ReportHF reportHF2 = this.reportPage.getHeader();
        if (reportHF2 != null) {
            reportHF2.paint(this.g2d, new Rectangle2D.Double(this.reportPage.getMarginLeft(), this.reportPage.getMarginTop(), n, ReportUtils.getHeaderHeight(reportSettings)), n, ReportUtils.getHeaderHeight(reportSettings), this.reportPage.getCurrentPageNumber(), this.reportPage.getTotalPages(), this.isPrint);
        }
        if ((reportHF = this.reportPage.getFooter()) != null) {
            reportHF.paint(this.g2d, new Rectangle2D.Double(this.reportPage.getMarginLeft(), this.reportPage.getPageHeight() - this.reportPage.getMarginBottom() - ReportUtils.getFooterHeight(reportSettings), n, ReportUtils.getFooterHeight(reportSettings)), n, ReportUtils.getFooterHeight(reportSettings), this.reportPage.getCurrentPageNumber(), this.reportPage.getTotalPages(), this.isPrint);
        }
    }

    private void prepareContentArea(Graphics2D graphics2D, Rectangle2D rectangle2D, ReportSettings reportSettings, boolean bl) {
        int n;
        this.g2d = (Graphics2D)graphics2D.create();
        this.g2d.translate(rectangle2D.getX(), rectangle2D.getY());
        Background background = reportSettings.getBackground();
        if (background != null) {
            if (bl) {
                if (reportSettings.isPrintBackground()) {
                    background.paint(this.g2d, new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight()));
                }
            } else if (reportSettings.isPreviewBackground()) {
                background.paint(this.g2d, new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight()));
            }
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.reportPage.getColumnCount(); ++n) {
            n2 += this.reportPage.getColumnWidth(n);
        }
        for (n = 0; n < this.reportPage.getRowCount(); ++n) {
            n3 += this.reportPage.getRowHeight(n);
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        n = 0;
        int n4 = 0;
        if (reportSettings.isHorizontalCenterOnPage()) {
            n = (int)(rectangle2D.getWidth() - (double)n2) / 2;
        }
        if (reportSettings.isVerticalCenterOnPage()) {
            n4 = (int)(rectangle2D.getHeight() - (double)n3) / 2;
        }
        this.g2d.translate(n, n4);
    }

    public void prepareCell(Iterator iterator, DynamicValueList dynamicValueList, DynamicValueList dynamicValueList2) {
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        Rectangle rectangle;
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
        ArrayList<CellGUIAttr> arrayList2 = new ArrayList<CellGUIAttr>();
        ArrayList<Cloneable> arrayList3 = new ArrayList<Cloneable>();
        ArrayList<CellGUIAttr> arrayList4 = new ArrayList<CellGUIAttr>();
        while (iterator.hasNext()) {
            Rectangle rectangle2;
            CellElement cellElement = (CellElement)iterator.next();
            CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
            if (cellGUIAttr == null) {
                cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
            }
            rectangle = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            cloneable3 = cellElement.getCellPageAttr();
            if (cloneable3 == null) {
                cloneable3 = CellPageAttr.DEFAULT_CELLPAGEATTR;
            }
            cloneable2 = (rectangle2 = ((CoverCellElement)cellElement).getCellPaintRect()) != null ? rectangle2 : new Rectangle(dynamicValueList.getRangeValue(0, rectangle.x), dynamicValueList2.getRangeValue(0, rectangle.y), dynamicValueList.getRangeValue(rectangle.x, rectangle.x + rectangle.width), dynamicValueList2.getRangeValue(rectangle.y, rectangle.y + rectangle.height));
            rectangle2 = ((CoverCellElement)cellElement).getCellClipRect();
            cloneable = rectangle2 != null ? rectangle2 : new Rectangle(0, 0, ((Rectangle)cloneable2).width, ((Rectangle)cloneable2).height);
            arrayList.add(cellElement);
            arrayList2.add(cellGUIAttr);
            arrayList3.add(cloneable2);
            arrayList4.add((CellGUIAttr)cloneable);
            if (this.isPrint && cellGUIAttr.isPrintBackground() || !this.isPrint && cellGUIAttr.isPreviewBackground()) {
                PaintUtils.paintBackground(this.g2d, cellElement.getStyle(), (Rectangle)cloneable2, (Rectangle)cloneable);
            }
            this.paintCellContent(cellGUIAttr, this.isPrint, cellElement, (Rectangle)cloneable2, (Rectangle)cloneable);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            cloneable2 = (CellElement)arrayList.get(i);
            cloneable = (CellGUIAttr)arrayList2.get(i);
            rectangle = (Rectangle)arrayList3.get(i);
            cloneable3 = (Rectangle)arrayList4.get(i);
            if ((!this.isPrint || !cloneable.isPrintBorder()) && (this.isPrint || !cloneable.isPreviewBorder())) continue;
            PaintUtils.paintBorder(this.g2d, cloneable2.getStyle(), rectangle, (Rectangle)cloneable3);
        }
    }

    protected void paintCellContent(CellGUIAttr cellGUIAttr, boolean bl, CellElement cellElement, Rectangle rectangle, Rectangle rectangle2) {
        if (!bl || cellGUIAttr.isPrintContent()) {
            Object object = ((CoverCellElement)cellElement).getCellOriValue();
            if (object == null) {
                object = cellElement.getValue();
            }
            while (object instanceof Formula) {
                object = ((Formula)object).getResult();
            }
            if (!cellGUIAttr.isPrintZeroValue() && object != null && object.toString().matches("[\\-]?0[\\.]?[0]*")) {
                return;
            }
            if (object instanceof Blob) {
                object = Utils.blob2Object((Blob)object, cellGUIAttr.isShowAsImage());
            }
            if (object instanceof Clob) {
                object = Utils.clob2String((Clob)object);
            }
            if (object instanceof BinaryObject) {
                object = cellGUIAttr.isShowAsImage() ? ((BinaryObject)object).getImage() : ((BinaryObject)object).getValue();
            }
            if (object instanceof String && cellGUIAttr.isShowAsHTML()) {
                object = PaintUtils.createHTMLContentBufferedImage((String)object, rectangle);
            }
            PaintUtils.paintContent(this.g2d, object, cellElement.getStyle(), rectangle, rectangle2);
        }
    }

    public void prepareFloat(Iterator iterator, DynamicValueList dynamicValueList, DynamicValueList dynamicValueList2) {
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            int n = floatElement.getColumn();
            int n2 = floatElement.getRow();
            Rectangle rectangle = new Rectangle(dynamicValueList.getRangeValueFromZero(n) + floatElement.getLeftDistance(), dynamicValueList2.getRangeValueFromZero(n2) + floatElement.getTopDistance(), floatElement.getSize().width, floatElement.getSize().height);
            Rectangle rectangle2 = null;
            Rectangle rectangle3 = null;
            rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle3 = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
            if (rectangle2 == null || rectangle3 == null) continue;
            PaintUtils.paintFloatElement(this.g2d, floatElement, rectangle2, rectangle3);
        }
    }
}

