/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.parameter;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.DefaultCellElement;
import com.fr.report.ParameterReport;
import com.fr.report.TemplateWorkBook;
import com.fr.report.cellElement.Formula;
import com.fr.report.parameter.AbstractParameterUI;
import com.fr.report.parameter.Parameter;
import com.fr.report.parameter.ParameterUI;
import com.fr.report.web.ui.FieldEditor;
import com.fr.report.web.ui.TextEditor;
import com.fr.report.web.ui.impl.form.FormSubmitButton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

public class CustomParameterUI
extends AbstractParameterUI {
    private static final int textWidth = 80;
    private static final int editorWidth = 140;
    private static final int pCount = 3;

    public CustomParameterUI() {
        this(null);
    }

    public CustomParameterUI(ParameterReport parameterReport) {
        this.setParameterForm(parameterReport);
    }

    public void readXML(XMLableReader xMLableReader) {
        this.parameterForm = new ParameterReport();
        xMLableReader.readXMLObject(this.parameterForm);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.parameterForm != null) {
            this.parameterForm.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static ParameterReport createEmptyParameterForm(TemplateWorkBook templateWorkBook) {
        ParameterReport parameterReport = new ParameterReport();
        DefaultCellElement defaultCellElement = new DefaultCellElement(0, 0, Inter.getLocText("Query"));
        defaultCellElement.setWidget(new FormSubmitButton());
        parameterReport.addCellElement(defaultCellElement);
        return parameterReport;
    }

    public static ParameterUI createDefaultParameterUI() {
        CustomParameterUI customParameterUI = new CustomParameterUI();
        customParameterUI.setParameterForm(CustomParameterUI.createEmptyParameterForm());
        return customParameterUI;
    }

    public static ParameterUI createDefaultParameterUI(TemplateWorkBook templateWorkBook, Map map, Map map2) {
        CustomParameterUI customParameterUI = new CustomParameterUI();
        customParameterUI.setParameterForm(CustomParameterUI.createDefaultParameterForm(templateWorkBook, map, map2));
        return customParameterUI;
    }

    public static ParameterReport createDefaultParameterForm(TemplateWorkBook templateWorkBook, Map map, Map map2) {
        if (templateWorkBook == null) {
            return null;
        }
        Object[] objectArray = new Parameter[]{};
        try {
            objectArray = templateWorkBook.getParameters();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        if (ArrayUtils.isEmpty(objectArray)) {
            return CustomParameterUI.createEmptyParameterForm();
        }
        ParameterReport parameterReport = CustomParameterUI.createDefaultParameterForm((Parameter[])objectArray, map, map2);
        return parameterReport;
    }

    private static ParameterReport createEmptyParameterForm() {
        ParameterReport parameterReport = new ParameterReport();
        DefaultCellElement defaultCellElement = new DefaultCellElement(0, 0, Inter.getLocText("Query"));
        defaultCellElement.setWidget(new FormSubmitButton());
        parameterReport.addCellElement(defaultCellElement);
        return parameterReport;
    }

    public static ParameterReport createDefaultParameterForm(Parameter[] parameterArray, Map map, Map map2) {
        ParameterReport parameterReport = new ParameterReport();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (int i = 0; i < parameterArray.length; ++i) {
            String string;
            Parameter parameter = parameterArray[i];
            if (parameter == null || (string = parameter.getName()) == null || hashSet.contains(string.toUpperCase())) continue;
            arrayList.add(parameterArray[i]);
            hashSet.add(string.toUpperCase());
        }
        parameterReport.setHeader(0, null);
        parameterReport.setFooter(0, null);
        Style style = Style.DEFAULT_STYLE.deriveHorizontalAlignment(4);
        int n = 0;
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            Parameter parameter = (Parameter)arrayList.get(i);
            n = i % 3 * 2;
            n2 = i / 3 * 2 + 1;
            if (i % n3 == 0) {
                parameterReport.setRowHeight(n2, 23);
            }
            parameterReport.setRowHeight(n2 - 1, 10);
            String string = parameter.getName();
            if (StringUtils.isBlank(string)) {
                string = parameter.getName();
            }
            DefaultCellElement defaultCellElement = new DefaultCellElement(n, n2, string + ":");
            parameterReport.setColumnWidth(n, 80);
            defaultCellElement.setStyle(style);
            parameterReport.addCellElement(defaultCellElement);
            DefaultCellElement defaultCellElement2 = new DefaultCellElement(n + 1, n2, CustomParameterUI.alterCellValue(parameter.getValue()));
            parameterReport.setColumnWidth(n + 1, 140);
            FieldEditor fieldEditor = null;
            if (map != null) {
                fieldEditor = (FieldEditor)map.get(parameter.getName());
            }
            if (fieldEditor == null) {
                fieldEditor = new TextEditor();
            }
            fieldEditor.setWidgetName(parameter.getName());
            defaultCellElement2.setWidget(fieldEditor);
            if (map2 != null && map2.containsKey(parameter.getName())) {
                defaultCellElement2.setValue(map2.get(parameter.getName()));
            }
            parameterReport.addCellElement(defaultCellElement2);
        }
        parameterReport.setRowHeight(n2 + 1, 10);
        DefaultCellElement defaultCellElement = new DefaultCellElement(1, n2 + 2, 6, 1, null);
        defaultCellElement.setWidget(new FormSubmitButton(Inter.getLocText("Query")));
        defaultCellElement.setStyle(style.deriveHorizontalAlignment(4));
        parameterReport.addCellElement(defaultCellElement);
        parameterReport.setRowHeight(n2 + 2, 23);
        parameterReport.addCellElement(new DefaultCellElement(0, n2 + 3));
        parameterReport.setRowHeight(n2 + 3, 10);
        return parameterReport;
    }

    private static Object alterCellValue(Object object) {
        if (object instanceof String && ((String)object).startsWith("=")) {
            object = new Formula((String)object);
        }
        return object;
    }
}

