/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.parameter;

import com.fr.base.DefaultValues;
import com.fr.base.FRContext;
import com.fr.base.Nameable;
import com.fr.base.XMLable;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.cellElement.Formula;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedNameWidget;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.report.script.Calculator;
import com.fr.report.web.ui.FieldEditor;
import com.fr.util.Utils;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;

public class Parameter
implements XMLable,
Nameable,
Serializable {
    public static final String XML_TAG = "Parameter";
    public static final String ARRAY_XML_TAG = "Parameters";
    private String name = null;
    private Object value = null;

    public Parameter() {
        this("");
    }

    public Parameter(String string) {
        this(string, "");
    }

    public Parameter(String string, Object object) {
        this.setName(string);
        this.setValue(object);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Object".equals(string) || "O".equals(string)) {
                Object object = ReportXMLUtils.readObject(xMLableReader);
                if (object instanceof String && ((String)object).startsWith("=") && SynchronizedVersion.getSynchronizedVersion(Thread.currentThread()).getVersion() < 6.5) {
                    object = new Formula((String)object);
                }
                this.setValue(object);
            } else if ("Attributes".equals(string)) {
                String string2 = xMLableReader.getAttr("name");
                if (string2 != null) {
                    this.setName(string2);
                }
            } else if ("Widget".equals(string) || string.equals("CellEditorDef")) {
                FieldEditor fieldEditor = ReportXMLUtils.readFieldEditor(xMLableReader);
                SynchronizedNameWidget.put(this.getName(), fieldEditor);
                SynchronizedNameWidget.put(this.getName(), this.value);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("name", this.getName()).end();
        if (this.getValue() != null) {
            ReportXMLUtils.writeObject(xMLPrintWriter, this.getValue());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Parameter parameter = (Parameter)super.clone();
        if (this.value != null) {
            parameter.value = BaseCoreUtils.cloneObject(this.value);
        }
        return parameter;
    }

    public String toString() {
        return "$" + this.getName();
    }

    public String valueToString() {
        String string = "";
        if (this.value != null) {
            if (this.value instanceof Formula) {
                Object object = ((Formula)this.value).getResult();
                if (object == null) {
                    try {
                        object = Calculator.createCalculator().eval(((Formula)this.value).getContent().substring(1));
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    }
                }
                if (object != null) {
                    return object.toString();
                }
                return "";
            }
            if (this.value instanceof Date) {
                DefaultValues defaultValues = FRContext.getDefaultValues();
                string = defaultValues.getDateTimeFormat().format(this.value);
            } else {
                string = this.value instanceof Double ? Utils.doubleToString((Double)this.value) : this.value.toString();
            }
        }
        return string;
    }

    public boolean equals(Object object) {
        return object instanceof Parameter && ComparatorUtils.equals(this.name, ((Parameter)object).name) && ComparatorUtils.equals(this.value, ((Parameter)object).value);
    }
}

