/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.FRCoreContext;
import com.fr.base.file.FunctionManager;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.core.ScriptUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.Function;
import com.fr.report.script.FunctionDef;
import com.fr.report.script.NameSpace;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.parser.ColumnRowLiteral;
import com.fr.report.script.core.parser.ColumnRowRange;
import com.fr.report.script.core.parser.InterpreterError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class AbstractNameSpace
implements NameSpace {
    private HashMap initedFunctionClasses;

    public Object getVariable(Object object, Calculator calculator) {
        if (object instanceof ColumnRow) {
            object = ColumnRowRange.columnRow2Range((ColumnRow)object);
        }
        if (object instanceof ColumnRowRange) {
            return this.resolveColumnRowRange(calculator, (ColumnRowRange)object);
        }
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof ColumnRow) {
            string = ((ColumnRow)object).toString();
        }
        if (string == null) {
            return null;
        }
        Serializable serializable = null;
        if (string.equalsIgnoreCase("null")) {
            serializable = Primitive.NULL;
        } else if (string.equalsIgnoreCase("nofilter")) {
            serializable = Primitive.NOFILTER;
        } else if (string.equalsIgnoreCase("true")) {
            serializable = Boolean.TRUE;
        } else if (string.equalsIgnoreCase("false")) {
            serializable = Boolean.FALSE;
        } else if (string.equals("$$$") || string.matches("\\$\\w+")) {
            serializable = Primitive.NULL;
        }
        return serializable;
    }

    private Object resolveColumnRowRange(Calculator calculator, ColumnRowRange columnRowRange) {
        ColumnRow columnRow;
        ColumnRowLiteral columnRowLiteral = columnRowRange.getFrom();
        ColumnRowLiteral columnRowLiteral2 = columnRowRange.getTo();
        ColumnRow columnRow2 = columnRowLiteral == null ? null : columnRowLiteral.getTargetColumnRow();
        ColumnRow columnRow3 = columnRow = columnRowLiteral2 == null ? null : columnRowLiteral2.getTargetColumnRow();
        if (columnRow2 == null) {
            return Primitive.NULL;
        }
        if (columnRow == null) {
            columnRow = columnRow2;
        }
        int n = Math.min(columnRow2.row, columnRow.row);
        int n2 = Math.max(columnRow2.row, columnRow.row);
        int n3 = Math.min(columnRow2.column, columnRow.column);
        int n4 = Math.max(columnRow2.column, columnRow.column);
        return this.resolveColumnRowIntersect(calculator, n3, n, n4 - n3 + 1, n2 - n + 1);
    }

    protected Object resolveColumnRowIntersect(Calculator calculator, int n, int n2, int n3, int n4) {
        Object object;
        Report report = calculator.getCurrentReport();
        if (report == null) {
            return Primitive.NULL;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = report.intersect(n, n2, n3, n4);
        while (iterator.hasNext()) {
            object = (CellElement)iterator.next();
            if (Boolean.TRUE.equals(object.getAttribute(CellElementAttribute.DEL))) continue;
            Object object2 = object.getValue();
            if (object2 instanceof Formula) {
                if (((Formula)object2).getResult() == null) {
                    ScriptUtils.executeCellElementFormula(calculator, (Formula)object2, calculator.getCurrentReport(), calculator.getCurrentTableDataSource(), (CellElement)object);
                }
                arrayList.add(((Formula)object2).getResult());
                continue;
            }
            arrayList.add(object2);
        }
        object = null;
        object = arrayList.size() == 0 ? Primitive.NULL : (arrayList.size() == 1 ? arrayList.get(0) : new FArray(arrayList));
        return object == null ? Primitive.NULL : object;
    }

    public Function getMethod(Object object, Calculator calculator) {
        String string;
        Class clazz;
        String string2;
        block13: {
            if (!(object instanceof String)) {
                throw new InterpreterError(Inter.getLocText("Function_Name_Should_Not_Be") + object + (object != null ? " " + object.getClass() : ""));
            }
            string2 = ((String)object).toUpperCase();
            if (this.initedFunctionClasses == null) {
                this.initedFunctionClasses = new HashMap();
            }
            if ((clazz = (Class)this.initedFunctionClasses.get(string2)) == null) {
                string = null;
                FunctionManager functionManager = FRContext.getFunctionManager();
                if (functionManager != null) {
                    int n = functionManager.getFunctionDefCount();
                    for (int i = 0; i < n; ++i) {
                        FunctionDef functionDef = functionManager.getFunctionDef(i);
                        if (!functionDef.getName().equalsIgnoreCase(string2)) continue;
                        string = functionDef.getClassName();
                    }
                }
                if (string == null) {
                    string = "com.fr.report.script.function." + string2;
                }
                try {
                    clazz = FRCoreContext.classForName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (string.equals("com.fr.report.script.function." + string2)) break block13;
                    try {
                        clazz = FRCoreContext.classForName("com.fr.report.script.function." + string2);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        // empty catch block
                    }
                }
            }
        }
        if (clazz == null) {
            return null;
        }
        this.initedFunctionClasses.put(string2, clazz);
        try {
            string = (String)clazz.newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, "new instance error", exception);
            return null;
        }
        return (Function)((Object)string);
    }
}

