/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.core.antlr.ANTLRException;
import com.fr.data.impl.RowsTableData;
import com.fr.report.Report;
import com.fr.report.TableDataSource;
import com.fr.report.core.FormReport;
import com.fr.report.core.ParameterHelper;
import com.fr.report.core.SegmentHandler;
import com.fr.report.script.AbstractNameSpace;
import com.fr.report.script.Function;
import com.fr.report.script.NameSpace;
import com.fr.report.script.Primitive;
import com.fr.report.script.Variable;
import com.fr.report.script.core.parser.Ambiguity;
import com.fr.report.script.core.parser.CRAddress;
import com.fr.report.script.core.parser.ColumnRowLiteral;
import com.fr.report.script.core.parser.ColumnRowRange;
import com.fr.report.script.core.parser.Expression;
import com.fr.report.script.core.parser.FRLexer;
import com.fr.report.script.core.parser.FRParser;
import com.fr.report.script.core.parser.Tiny;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UtilEvalError;
import com.fr.util.Utils;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Calculator
implements Serializable,
Cloneable {
    private CNS globalNameSpace = new CNS();
    private Map parsedExpression = new HashMap();
    private Map attributes = new HashMap();
    private static final Object REPORT = new Object();
    private static final Object TABLEDATA = new Object();
    private static final Object COLUMNROW = new Object();
    private static final Object CUR_ROWSTABLEDATA = new Object();
    private static Hashtable calculators = new Hashtable();
    private static final Pattern deprecatedParaPattern = Pattern.compile("\\[\\?[^\\]\\?]*\\?\\]");
    public static Pattern ParameterPattern = Pattern.compile("\\$\\{((\\\"[^(\\$\\{)]*\\}[^(\\$\\{)]*\\\")|(\\\"[^(\\$\\{)]*[^\\$]?\\{[^(\\$\\{)]*\\\")|[^\\{\\}])*+\\}");

    public static Calculator currentCalculator() {
        return (Calculator)calculators.get(Thread.currentThread());
    }

    public static Calculator createCalculator() {
        return new Calculator();
    }

    public static Calculator createStaticCalculator() {
        Calculator calculator = new Calculator();
        calculators.put(Thread.currentThread(), calculator);
        return calculator;
    }

    private Calculator() {
    }

    public void release() {
        calculators.remove(Thread.currentThread());
    }

    public void setCurrentReport(Report report) {
        this.attributes.put(REPORT, report);
    }

    public Report getCurrentReport() {
        return (Report)this.attributes.get(REPORT);
    }

    public void setCurrentTableDataSource(TableDataSource tableDataSource) {
        this.attributes.put(TABLEDATA, tableDataSource);
    }

    public TableDataSource getCurrentTableDataSource() {
        return (TableDataSource)this.attributes.get(TABLEDATA);
    }

    public void setCurrentColumnRow(ColumnRow columnRow) {
        this.attributes.put(COLUMNROW, columnRow);
    }

    public RowsTableData getCurrentRowsTableData() {
        return (RowsTableData)this.attributes.get(CUR_ROWSTABLEDATA);
    }

    public void setCurrentRowsTableData(RowsTableData rowsTableData) {
        this.attributes.put(CUR_ROWSTABLEDATA, rowsTableData);
    }

    public ColumnRow getCurrentColumnRow() {
        return (ColumnRow)this.attributes.get(COLUMNROW);
    }

    public void setAttribute(Object object, Object object2) {
        this.attributes.put(object, object2);
    }

    public Object getAttribute(Object object) {
        return this.attributes.get(object);
    }

    public void set(String string, Object object) {
        this.globalNameSpace.set(string, object);
    }

    public void pushNameSpace(NameSpace nameSpace) {
        this.globalNameSpace.namespaceList.addFirst(nameSpace);
    }

    public boolean removeNameSpace(NameSpace nameSpace) {
        return this.globalNameSpace.namespaceList.remove(nameSpace);
    }

    public Object resolveVariable(Object object) {
        return this.globalNameSpace.getVariable(object, this);
    }

    public Function resolveMethod(Object object) {
        return this.globalNameSpace.getMethod(object, this);
    }

    public Object resolveCellElementAttribute(ColumnRow columnRow, Object object) {
        return this.globalNameSpace.getCellElementAttribute(columnRow, object, this);
    }

    public Expression parse(Object object) throws ANTLRException {
        if (object instanceof Expression) {
            return (Expression)object;
        }
        return this.parse(Utils.objectToString(object));
    }

    public Expression parse(String string) throws ANTLRException {
        Expression expression;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("=")) {
            string = string.substring(1);
        }
        if ((expression = (Expression)this.parsedExpression.get(string)) == null) {
            StringReader stringReader = new StringReader(string);
            FRLexer fRLexer = new FRLexer(stringReader);
            FRParser fRParser = new FRParser(fRLexer);
            expression = fRParser.parse();
            this.parsedExpression.put(string, expression);
        }
        return expression;
    }

    public Object eval(String string) throws UtilEvalError {
        Expression expression = null;
        if (string != null) {
            try {
                expression = this.parse(string);
            }
            catch (ANTLRException aNTLRException) {
                if (this.getCurrentColumnRow() != null) {
                    StringBuffer stringBuffer = new StringBuffer().append(Inter.getLocText("Error_Cell") + ":").append(this.getCurrentColumnRow()).append(Inter.getLocText("Error_Statement_Is") + "\"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                    FRContext.getLogger().log(Level.WARNING, stringBuffer.toString(), aNTLRException);
                }
                FRContext.getLogger().log(Level.WARNING, Inter.getLocText("Error_Statement_Is") + "\"" + string + "\"", aNTLRException);
            }
        }
        return expression == null ? null : expression.eval(this);
    }

    public static ColumnRow[] relatedColumnRowArray(String string) throws ANTLRException {
        Expression expression = new Calculator().parse(string);
        if (expression == null) {
            return new ColumnRow[0];
        }
        ColumnRowHunter columnRowHunter = new ColumnRowHunter();
        expression.traversal4Tiny(columnRowHunter);
        return columnRowHunter.getColumnRowBooty();
    }

    public static String[] relatedParameters(String string) throws ANTLRException {
        Expression expression = new Calculator().parse(string);
        if (expression == null) {
            return new String[0];
        }
        ParameterHunter parameterHunter = new ParameterHunter();
        expression.traversal4Tiny(parameterHunter);
        return parameterHunter.getParameterBooty();
    }

    public String exStatement(ColumnRow columnRow, String string) {
        this.setCurrentColumnRow(columnRow);
        Expression expression = null;
        try {
            expression = this.parse(string);
        }
        catch (ANTLRException aNTLRException) {
            if (this.getCurrentColumnRow() != null) {
                StringBuffer stringBuffer = new StringBuffer().append("Error Cell: ").append(this.getCurrentColumnRow()).append(" and statement is \"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                FRContext.getLogger().log(Level.WARNING, stringBuffer.toString(), aNTLRException);
            }
            FRContext.getLogger().log(Level.WARNING, "error statement is \"" + string + "\"", aNTLRException);
        }
        return expression == null ? string : expression.exString(this);
    }

    public String onAddDeleteColumnOrRow(String string, int n, int n2, int n3, int n4) {
        Expression expression = null;
        try {
            expression = this.parse(string);
        }
        catch (ANTLRException aNTLRException) {
            if (this.getCurrentColumnRow() != null) {
                StringBuffer stringBuffer = new StringBuffer().append("Error Cell: ").append(this.getCurrentColumnRow()).append(" and statement is \"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                FRContext.getLogger().log(Level.WARNING, stringBuffer.toString(), aNTLRException);
            }
            FRContext.getLogger().log(Level.WARNING, "error statement is \"" + string + "\"", aNTLRException);
        }
        return expression == null ? string : expression.getExpression(n, n2, n3, n4, true);
    }

    public void extract(ColumnRow[] columnRowArray, ColumnRow columnRow, FormReport.Action action) throws Exception {
        int n = 0;
        Report report = this.getCurrentReport();
        if (report instanceof FormReport) {
            n = ((FormReport)((Object)report)).setCurrentColumnRow(columnRowArray, columnRow, this, action);
        }
        if (n <= 0) {
            action.run(0, this);
        }
    }

    public String renderTpl(String string) {
        if (deprecatedParaPattern.matcher(string).find()) {
            SegmentHandler.QueryCreator queryCreator = new SegmentHandler.QueryCreator(this);
            ParameterHelper.analyzeParametersFromQuery(string, queryCreator);
            return queryCreator.getNewQuery();
        }
        Matcher matcher = ParameterPattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (matcher.find()) {
            n2 = matcher.start();
            String string2 = string.substring(n, n2);
            n = matcher.end();
            stringBuffer.append(string2);
            String string3 = matcher.group();
            String string4 = string3.substring(2, string3.length() - 1);
            Object object = null;
            try {
                object = this.eval(string4);
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
            if (object == null) continue;
            stringBuffer.append(Utils.objectToString(object));
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    protected static class CNS
    extends AbstractNameSpace {
        private Map variables = new HashMap();
        private LinkedList namespaceList = new LinkedList();

        protected CNS() {
        }

        public Function getMethod(Object object, Calculator calculator) {
            Function function = null;
            int n = this.namespaceList.size();
            for (int i = 0; i < n; ++i) {
                function = ((NameSpace)this.namespaceList.get(i)).getMethod(object, calculator);
                if (function == null) continue;
                return function;
            }
            return super.getMethod(object, calculator);
        }

        public Object getCellElementAttribute(ColumnRow columnRow, Object object, Calculator calculator) {
            Object object2 = null;
            int n = this.namespaceList.size();
            for (int i = 0; i < n; ++i) {
                object2 = ((NameSpace)this.namespaceList.get(i)).getCellElementAttribute(columnRow, object, calculator);
                if (object2 == null) continue;
                return object2;
            }
            return object2;
        }

        public Object getVariable(Object object, Calculator calculator) {
            Object object2 = null;
            object2 = this.unwrapVariable((Variable)this.variables.get(object));
            if (object2 != null) {
                return object2;
            }
            int n = this.namespaceList.size();
            for (int i = 0; i < n; ++i) {
                object2 = ((NameSpace)this.namespaceList.get(i)).getVariable(object, calculator);
                if (object2 == null) continue;
                return object2;
            }
            return super.getVariable(object, calculator);
        }

        private Object unwrapVariable(Variable variable) {
            return variable == null ? null : variable.getValue();
        }

        private void set(Object object, Object object2) {
            Variable variable;
            if (object == null) {
                return;
            }
            if (object2 == null) {
                object2 = Primitive.NULL;
            }
            if ((variable = (Variable)this.variables.get(object)) != null) {
                variable.setValue(object2);
            } else {
                this.variables.put(object, new Variable(object2));
            }
        }
    }

    private static class ParameterHunter
    extends TinyHunter {
        private List parameterList = new ArrayList();

        private ParameterHunter() {
        }

        public String[] getParameterBooty() {
            return this.parameterList.toArray(new String[this.parameterList.size()]);
        }

        public void hunter4Tiny(Tiny tiny) {
            String string;
            if (tiny instanceof Ambiguity && StringUtils.isNotBlank(string = ((Ambiguity)tiny).getStatement()) && string.startsWith("$") && !this.parameterList.contains(string)) {
                this.parameterList.add(string);
            }
        }
    }

    private static class ColumnRowHunter
    extends TinyHunter {
        private List list = new ArrayList();

        private ColumnRowHunter() {
        }

        public ColumnRow[] getColumnRowBooty() {
            return this.list.toArray(new ColumnRow[this.list.size()]);
        }

        public void hunter4Tiny(Tiny tiny) {
            ColumnRow columnRow;
            if (tiny instanceof ColumnRowRange) {
                ColumnRow columnRow2;
                ColumnRowRange columnRowRange = (ColumnRowRange)tiny;
                ColumnRowLiteral columnRowLiteral = columnRowRange.getFrom();
                if (columnRowLiteral == null) {
                    return;
                }
                ColumnRow columnRow3 = columnRow2 = columnRowLiteral.getTargetColumnRow();
                ColumnRowLiteral columnRowLiteral2 = columnRowRange.getTo();
                if (columnRowLiteral2 != null) {
                    columnRow3 = columnRowLiteral2.getTargetColumnRow();
                }
                int n = Math.min(columnRow2.column, columnRow3.column);
                int n2 = Math.min(columnRow2.row, columnRow3.row);
                int n3 = Math.max(columnRow2.column, columnRow3.column);
                int n4 = Math.max(columnRow2.row, columnRow3.row);
                for (int i = n; i <= n3; ++i) {
                    for (int j = n2; j <= n4; ++j) {
                        ColumnRow columnRow4 = ColumnRow.valueOf(i, j);
                        if (this.list.contains(columnRow4) || !ColumnRow.validate(columnRow4)) continue;
                        this.list.add(columnRow4);
                    }
                }
            } else if (tiny instanceof CRAddress && !this.list.contains(columnRow = ((CRAddress)tiny).getTarget()) && ColumnRow.validate(columnRow)) {
                this.list.add(columnRow);
            }
        }
    }
}

