/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.base.core.DateUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.MathExpression;
import com.fr.report.script.core.parser.MultiExpression;
import com.fr.report.script.core.parser.OperationUtils;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UtilEvalError;
import com.fr.util.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class AddExpression
extends MathExpression {
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    String[] ops;
    MultiExpression[] multis;

    AddExpression(MultiExpression[] multiExpressionArray, String[] stringArray) {
        this.multis = multiExpressionArray;
        this.ops = stringArray;
    }

    public Object eval(Calculator calculator) throws UtilEvalError {
        if (this.multis.length == 0) {
            throw new InterpreterError("multiList should not be empty");
        }
        Object object = null;
        for (int i = 0; i < this.multis.length; ++i) {
            if (i == 0) {
                object = this.multis[i].eval(calculator);
                continue;
            }
            Object object2 = this.multis[i].eval(calculator);
            object = this.binaryOperation(object, object2, this.ops[i - 1]);
        }
        return object;
    }

    private static boolean isPLUS(String string) {
        return PLUS.equals(string);
    }

    private static boolean isMINUS(String string) {
        return MINUS.equals(string);
    }

    protected Object ccNINI(String string) {
        return AddExpression.isPLUS(string) ? (Number)OperationUtils.NEGATIVE_INFINITY : (Number)OperationUtils.ZERO;
    }

    protected Object ccNIPI(String string) {
        return AddExpression.isPLUS(string) ? (Number)OperationUtils.ZERO : (Number)OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccNIRE(Object object, String string) {
        return OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccPINI(String string) {
        return AddExpression.isPLUS(string) ? (Number)OperationUtils.ZERO : (Number)OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccPIPI(String string) {
        return AddExpression.isPLUS(string) ? (Number)OperationUtils.POSITIVE_INFINITY : (Number)OperationUtils.ZERO;
    }

    protected Object ccPIRE(Object object, String string) {
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccRENI(Object object, String string) {
        return AddExpression.isPLUS(string) ? OperationUtils.NEGATIVE_INFINITY : OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccREPI(Object object, String string) {
        return AddExpression.isPLUS(string) ? OperationUtils.POSITIVE_INFINITY : OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccRERE(Object object, Object object2, String string) throws UtilEvalError {
        if (object instanceof Date && object2 instanceof Number) {
            int n = ((Number)object2).intValue();
            return DateUtils.datePlusInteger((Date)object, AddExpression.isPLUS(string) ? n : -n);
        }
        if ((object instanceof String || object2 instanceof String) && AddExpression.isPLUS(string)) {
            return Utils.objectToString(object) + Utils.objectToString(object2);
        }
        if (object instanceof Date && object2 instanceof Date && AddExpression.isMINUS(string)) {
            return new Integer((int)DateUtils.subtractDate((Date)object, (Date)object2, "d"));
        }
        return this.numberOperation(object, object2, string);
    }

    protected Object decimalOperation(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        if (AddExpression.isPLUS(string)) {
            return bigDecimal.add(bigDecimal2);
        }
        return bigDecimal.subtract(bigDecimal2);
    }

    protected Object doubleOperation(double d, double d2, String string) {
        if (AddExpression.isPLUS(string)) {
            return new Double(d + d2);
        }
        return new Double(d - d2);
    }

    protected Object intOperation(int n, int n2, String string) {
        if (AddExpression.isPLUS(string)) {
            return new Integer(n + n2);
        }
        return new Integer(n - n2);
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        for (int i = 0; i < this.multis.length; ++i) {
            this.multis[i].traversal4Tiny(tinyHunter);
        }
    }

    public String exString(Calculator calculator) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.multis.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ').append(this.ops[i - 1]).append(' ');
            }
            stringBuffer.append(this.multis[i].exString(calculator));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.multis.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ').append(this.ops[i - 1]).append(' ');
            }
            stringBuffer.append(this.multis[i]);
        }
        return stringBuffer.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.multis.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ').append(this.ops[i - 1]).append(' ');
            }
            stringBuffer.append(this.multis[i].getExpression(n, n2, n3, n4, bl));
        }
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.multis.length;
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(Arrays.asList(this.multis[i].parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

