/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.BinaryExpression;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.OperationUtils;
import com.fr.report.script.core.parser.RelationExpression;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.ArrayList;
import java.util.Arrays;

public class ConditionalAndExpression
extends BinaryExpression {
    private static final String AND = "&&";
    RelationExpression[] rels;

    ConditionalAndExpression(RelationExpression[] relationExpressionArray) {
        this.rels = relationExpressionArray;
    }

    public Object eval(Calculator calculator) throws UtilEvalError {
        if (this.rels.length == 0) {
            throw new InterpreterError("relationList should not be empty");
        }
        Object object = null;
        for (int i = 0; i < this.rels.length; ++i) {
            if (i == 0) {
                object = this.rels[i].eval(calculator);
            } else {
                Object object2 = this.rels[i].eval(calculator);
                object = this.binaryOperation(object, object2, AND);
            }
            if (i != this.rels.length - 1 && !OperationUtils.isFalse(object)) continue;
            return object;
        }
        return object;
    }

    protected Object objectBinaryOperation(Object object, Object object2, String string) {
        return OperationUtils.isFalse(object) ? object : object2;
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        for (int i = 0; i < this.rels.length; ++i) {
            this.rels[i].traversal4Tiny(tinyHunter);
        }
    }

    public String exString(Calculator calculator) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rels.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" && ");
            }
            stringBuffer.append(this.rels[i].exString(calculator));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rels.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" && ");
            }
            stringBuffer.append(this.rels[i]);
        }
        return stringBuffer.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rels.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" && ");
            }
            stringBuffer.append(this.rels[i].getExpression(n, n2, n3, n4, bl));
        }
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.rels.length;
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(Arrays.asList(this.rels[i].parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

