/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.BinaryExpression;
import com.fr.report.script.core.parser.ConditionalAndExpression;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.OperationUtils;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.ArrayList;
import java.util.Arrays;

public class ConditionalOrExpression
extends BinaryExpression {
    private static final String OR = "||";
    ConditionalAndExpression[] ands;

    ConditionalOrExpression(ConditionalAndExpression[] conditionalAndExpressionArray) {
        this.ands = conditionalAndExpressionArray;
    }

    public Object eval(Calculator calculator) throws UtilEvalError {
        if (this.ands.length == 0) {
            throw new InterpreterError("conditionalAndList should not be empty");
        }
        Object object = null;
        for (int i = 0; i < this.ands.length; ++i) {
            if (i == 0) {
                object = this.ands[i].eval(calculator);
            } else {
                Object object2 = this.ands[i].eval(calculator);
                object = this.binaryOperation(object, object2, OR);
            }
            if (i != this.ands.length - 1 && OperationUtils.isFalse(object)) continue;
            return object;
        }
        return object;
    }

    protected Object objectBinaryOperation(Object object, Object object2, String string) {
        return OperationUtils.isFalse(object) ? object2 : object;
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        for (int i = 0; i < this.ands.length; ++i) {
            this.ands[i].traversal4Tiny(tinyHunter);
        }
    }

    public String exString(Calculator calculator) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.ands.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" || ");
            }
            stringBuffer.append(this.ands[i].exString(calculator));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.ands.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" || ");
            }
            stringBuffer.append(this.ands[i].toString());
        }
        return stringBuffer.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.ands.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" || ");
            }
            stringBuffer.append(this.ands[i].getExpression(n, n2, n3, n4, bl));
        }
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.ands.length;
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(Arrays.asList(this.ands[i].parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

