/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.base.ArrayUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.Function;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.parser.Atom;
import com.fr.report.script.core.parser.ConditionalOrExpression;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.ArrayList;
import java.util.Arrays;

public class FunctionCall
extends Atom {
    private String name;
    private ConditionalOrExpression[] arguments;

    FunctionCall(String string, ConditionalOrExpression[] conditionalOrExpressionArray) {
        this.name = string;
        this.arguments = conditionalOrExpressionArray;
    }

    public Object eval(Calculator calculator) throws UtilEvalError {
        if ("if".equalsIgnoreCase(this.name)) {
            return this.ifFunction(calculator);
        }
        Function function = calculator.resolveMethod(this.name);
        if (function == null) {
            throw new InterpreterError("no function found: " + this.name);
        }
        function.setCalculator(calculator);
        Object[] objectArray = new Object[this.arguments.length];
        if (this.arguments != null) {
            objectArray = function.processArguments(this.arguments);
        }
        return function.run(objectArray);
    }

    private Object ifFunction(Calculator calculator) throws UtilEvalError {
        if (ArrayUtils.getLength(this.arguments) < 3) {
            return Primitive.ERROR_NAME;
        }
        if (ComparatorUtils.equals(this.arguments[0].eval(calculator), Boolean.FALSE)) {
            return this.arguments[2].eval(calculator);
        }
        return this.arguments[1].eval(calculator);
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i].traversal4Tiny(tinyHunter);
        }
    }

    public String exString(Calculator calculator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (this.arguments[i] == null) continue;
            stringBuffer.append(this.arguments[i].exString(calculator));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (this.arguments[i] == null) continue;
            stringBuffer.append(this.arguments[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (this.arguments[i] == null) continue;
            stringBuffer.append(this.arguments[i].getExpression(n, n2, n3, n4, bl));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.arguments.length;
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(Arrays.asList(this.arguments[i].parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

