/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.MathExpression;
import com.fr.report.script.core.parser.OperationUtils;
import com.fr.report.script.core.parser.PowerExpression;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UtilEvalError;
import com.fr.util.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiExpression
extends MathExpression {
    private static final String MULTI = "*";
    private static final String DIV = "/";
    private static final String MOD = "%";
    private static final int DEFAULT_DECIMAL_SCALE = 20;
    String[] ops;
    PowerExpression[] powers;

    MultiExpression(PowerExpression[] powerExpressionArray, String[] stringArray) {
        this.powers = powerExpressionArray;
        this.ops = stringArray;
    }

    private static boolean isMULTI(String string) {
        return MULTI.equals(string);
    }

    private static boolean isDIV(String string) {
        return DIV.equals(string);
    }

    private static boolean isMOD(String string) {
        return MOD.equals(string);
    }

    public Object eval(Calculator calculator) throws UtilEvalError {
        if (this.powers.length == 0) {
            throw new InterpreterError("powerList should not be empty");
        }
        Object object = null;
        for (int i = 0; i < this.powers.length; ++i) {
            if (i == 0) {
                object = this.powers[i].eval(calculator);
                continue;
            }
            Object object2 = this.powers[i].eval(calculator);
            object = this.binaryOperation(object, object2, this.ops[i - 1]);
        }
        return object;
    }

    protected Object ccNINI(String string) {
        if (MultiExpression.isMOD(string)) {
            return OperationUtils.ZERO;
        }
        if (MultiExpression.isMULTI(string)) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        return new Integer(1);
    }

    protected Object ccPIPI(String string) {
        return this.ccNINI(string);
    }

    protected Object ccNIPI(String string) {
        if (MultiExpression.isMOD(string)) {
            return OperationUtils.ZERO;
        }
        if (MultiExpression.isMULTI(string)) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        return new Integer(-1);
    }

    protected Object ccPINI(String string) {
        return this.ccNIPI(string);
    }

    protected Object ccNIRE(Object object, String string) {
        if (MultiExpression.isMOD(string)) {
            return OperationUtils.ZERO;
        }
        Number number = Utils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        int n = number.intValue();
        if (MultiExpression.isMULTI(string)) {
            if (n > 0) {
                return OperationUtils.NEGATIVE_INFINITY;
            }
            if (n == 0) {
                return OperationUtils.ZERO;
            }
            return OperationUtils.POSITIVE_INFINITY;
        }
        if (n >= 0) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccPIRE(Object object, String string) {
        Object object2 = this.ccNIRE(object, string);
        if (object2 == OperationUtils.POSITIVE_INFINITY) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        if (object2 == OperationUtils.NEGATIVE_INFINITY) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        return object2;
    }

    protected Object ccRENI(Object object, String string) {
        if (MultiExpression.isMOD(string) || MultiExpression.isDIV(string)) {
            return OperationUtils.ZERO;
        }
        Number number = Utils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        int n = number.intValue();
        if (n > 0) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        if (n == 0) {
            return OperationUtils.ZERO;
        }
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccREPI(Object object, String string) {
        Object object2 = this.ccRENI(object, string);
        if (object2 == OperationUtils.POSITIVE_INFINITY) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        if (object2 == OperationUtils.NEGATIVE_INFINITY) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        return object2;
    }

    protected Object ccRERE(Object object, Object object2, String string) {
        return this.numberOperation(object, object2, string);
    }

    protected Object decimalOperation(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        if (MultiExpression.isMULTI(string)) {
            return bigDecimal.multiply(bigDecimal2);
        }
        if (MultiExpression.isDIV(string)) {
            if (bigDecimal.compareTo(OperationUtils.BZERO) == 0) {
                return new Integer(0);
            }
            if (bigDecimal2.compareTo(OperationUtils.BZERO) == 0) {
                return bigDecimal.compareTo(OperationUtils.BZERO) > 0 ? OperationUtils.POSITIVE_INFINITY : OperationUtils.NEGATIVE_INFINITY;
            }
            return bigDecimal.divide(bigDecimal2, bigDecimal.scale() > 20 ? bigDecimal.scale() : 20, 6);
        }
        return bigDecimal.toBigInteger().mod(bigDecimal2.toBigInteger());
    }

    protected Object doubleOperation(double d, double d2, String string) {
        if (MultiExpression.isMULTI(string)) {
            return new Double(d * d2);
        }
        if (MultiExpression.isDIV(string)) {
            if (d == 0.0) {
                return new Integer(0);
            }
            if (d2 == 0.0) {
                return d > 0.0 ? OperationUtils.POSITIVE_INFINITY : OperationUtils.NEGATIVE_INFINITY;
            }
            return new Double(d / d2);
        }
        return new Double(d % d2);
    }

    protected Object intOperation(int n, int n2, String string) {
        if (MultiExpression.isMULTI(string)) {
            return new Integer(n * n2);
        }
        if (MultiExpression.isDIV(string)) {
            if (n == 0) {
                return new Integer(0);
            }
            if (n2 == 0) {
                return n > 0 ? OperationUtils.POSITIVE_INFINITY : OperationUtils.NEGATIVE_INFINITY;
            }
            return new Double((double)n / (double)n2);
        }
        return new Integer(n % n2);
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        for (int i = 0; i < this.powers.length; ++i) {
            this.powers[i].traversal4Tiny(tinyHunter);
        }
    }

    public String exString(Calculator calculator) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.powers.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ').append(this.ops[i - 1]).append(' ');
            }
            stringBuffer.append(this.powers[i].exString(calculator));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.powers.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ').append(this.ops[i - 1]).append(' ');
            }
            stringBuffer.append(this.powers[i]);
        }
        return stringBuffer.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.powers.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ').append(this.ops[i - 1]).append(' ');
            }
            stringBuffer.append(this.powers[i].getExpression(n, n2, n3, n4, bl));
        }
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.powers.length;
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(Arrays.asList(this.powers[i].parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

