/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.base.core.ComparatorUtils;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.UtilEvalError;
import java.math.BigDecimal;

public class OperationUtils {
    public static final Double POSITIVE_INFINITY = new Double(Double.POSITIVE_INFINITY);
    public static final Double NEGATIVE_INFINITY = new Double(Double.NEGATIVE_INFINITY);
    private static final String BOOL = "!";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    public static final Integer ZERO = new Integer(0);
    public static final BigDecimal BZERO = new BigDecimal(0.0);

    private OperationUtils() {
    }

    public static boolean isFalse(Object object) {
        return object == null || object == Primitive.NULL || ComparatorUtils.equals(object, Boolean.FALSE) || ComparatorUtils.equals(object, new Integer(0)) || ComparatorUtils.equals(object, "");
    }

    static boolean booleanUnaryOperation(Boolean bl, String string) throws UtilEvalError {
        boolean bl2 = bl;
        if (BOOL.equals(string)) {
            return !bl2;
        }
        throw new UtilEvalError("Operator inappropriate for boolean:\n" + string + bl);
    }

    static int intUnaryOperation(Integer n, String string) {
        int n2 = n;
        if (PLUS.equals(string)) {
            return n2;
        }
        if (MINUS.equals(string)) {
            return -n2;
        }
        throw new InterpreterError("bad integer unaryOperation:\n" + string + n);
    }

    static long longUnaryOperation(Long l, String string) {
        long l2 = l;
        if (PLUS.equals(string)) {
            return l2;
        }
        if (MINUS.equals(string)) {
            return -l2;
        }
        throw new InterpreterError("bad long unaryOperation:\n" + string + l);
    }

    static float floatUnaryOperation(Float f, String string) {
        float f2 = f.floatValue();
        if (PLUS.equals(string)) {
            return f2;
        }
        if (MINUS.equals(string)) {
            return -f2;
        }
        throw new InterpreterError("bad float unaryOperation:\n" + string + f);
    }

    static double doubleUnaryOperation(Double d, String string) {
        double d2 = d;
        if (PLUS.equals(string)) {
            return d2;
        }
        if (MINUS.equals(string)) {
            return -d2;
        }
        throw new InterpreterError("bad double unaryOperation:\n" + string + d);
    }

    static BigDecimal bigDecimalUnaryOperation(BigDecimal bigDecimal, String string) {
        if (PLUS.equals(string)) {
            return bigDecimal;
        }
        if (MINUS.equals(string)) {
            return bigDecimal.negate();
        }
        throw new InterpreterError("bad bigDecimal unaryOperation:\n" + string + bigDecimal);
    }

    static Object promoteCharByteShort(Object object) {
        if (object instanceof Character) {
            return object.toString();
        }
        if (object instanceof Byte || object instanceof Short) {
            return new Integer(((Number)object).intValue());
        }
        return object;
    }
}

