/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.MathExpression;
import com.fr.report.script.core.parser.OperationUtils;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UnaryExpression;
import com.fr.report.script.core.parser.UtilEvalError;
import com.fr.util.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public class PowerExpression
extends MathExpression {
    private static final String POW = "^";
    UnaryExpression[] unarys;

    PowerExpression(UnaryExpression[] unaryExpressionArray) {
        this.unarys = unaryExpressionArray;
    }

    public Object eval(Calculator calculator) throws UtilEvalError {
        if (this.unarys.length == 0) {
            throw new InterpreterError("unaryList should not be empty");
        }
        Object object = null;
        for (int i = 0; i < this.unarys.length; ++i) {
            if (i == 0) {
                object = this.unarys[i].eval(calculator);
                continue;
            }
            Object object2 = this.unarys[i].eval(calculator);
            object = this.binaryOperation(object, object2, POW);
        }
        return object;
    }

    protected Object ccNINI(String string) {
        return OperationUtils.ZERO;
    }

    protected Object ccNIPI(String string) {
        return OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccNIRE(Object object, String string) {
        Number number = Utils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.NEGATIVE_INFINITY;
        }
        if (number.intValue() < 0) {
            return OperationUtils.ZERO;
        }
        return OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccPINI(String string) {
        return OperationUtils.ZERO;
    }

    protected Object ccPIPI(String string) {
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccPIRE(Object object, String string) {
        Number number = Utils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        if (number.intValue() < 0) {
            return OperationUtils.ZERO;
        }
        return OperationUtils.POSITIVE_INFINITY;
    }

    protected Object ccRENI(Object object, String string) {
        return OperationUtils.ZERO;
    }

    protected Object ccREPI(Object object, String string) {
        Number number = Utils.objectToNumber(object, true);
        if (number == null) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        int n = number.intValue();
        if (n > 0) {
            return OperationUtils.POSITIVE_INFINITY;
        }
        if (n == 0) {
            return OperationUtils.ZERO;
        }
        return OperationUtils.NEGATIVE_INFINITY;
    }

    protected Object ccRERE(Object object, Object object2, String string) {
        return this.numberOperation(object, object2, string);
    }

    protected Object decimalOperation(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        return this.doubleOperation(bigDecimal.doubleValue(), bigDecimal2.doubleValue(), string);
    }

    protected Object doubleOperation(double d, double d2, String string) {
        return new Double(Math.pow(d, d2));
    }

    protected Object intOperation(int n, int n2, String string) {
        return new Double(Math.pow(n, n2));
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        for (int i = 0; i < this.unarys.length; ++i) {
            this.unarys[i].traversal4Tiny(tinyHunter);
        }
    }

    public String exString(Calculator calculator) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.unarys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ^ ");
            }
            stringBuffer.append(this.unarys[i].exString(calculator));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.unarys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ^ ");
            }
            stringBuffer.append(this.unarys[i]);
        }
        return stringBuffer.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.unarys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ^ ");
            }
            stringBuffer.append(this.unarys[i].getExpression(n, n2, n3, n4, bl));
        }
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.unarys.length;
        for (int i = 0; i < n; ++i) {
            if (this.unarys[i].parserParameter() == null) continue;
            arrayList.addAll(Arrays.asList(this.unarys[i].parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

