/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.base.core.ComparatorUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.parser.AddExpression;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.MathExpression;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UtilEvalError;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public class RelationExpression
extends MathExpression {
    private static final String GT = ">";
    private static final String LT = "<";
    private static final String GE = ">=";
    private static final String LE = "<=";
    private static final String EQ = "=";
    private static final String NE1 = "!=";
    private static final String NE2 = "<>";
    AddExpression left;
    String op;
    AddExpression right;

    RelationExpression(AddExpression addExpression, String string, AddExpression addExpression2) {
        this.left = addExpression;
        this.op = string;
        this.right = addExpression2;
    }

    private static Boolean onEQ(String string) {
        return GE.equals(string) || LE.equals(string) || EQ.equals(string);
    }

    private static Boolean onLT(String string) {
        return LT.equals(string) || LE.equals(string) || NE1.equals(string) || NE2.equals(string);
    }

    private static Boolean onGT(String string) {
        return GT.equals(string) || GE.equals(string) || NE1.equals(string) || NE2.equals(string);
    }

    public Object eval(Calculator calculator) throws UtilEvalError {
        if (this.left == null) {
            throw new InterpreterError("left of RelationExpression should not be empty");
        }
        Object object = this.left.eval(calculator);
        if (this.op != null && this.right != null) {
            object = this.binaryOperation(object, this.right.eval(calculator), this.op);
        }
        return object;
    }

    protected Object arrayBinaryOperation(FArray fArray, FArray fArray2, String string) {
        int n;
        int n2;
        boolean bl = true;
        if (fArray.length() == fArray2.length()) {
            n2 = fArray.length();
            for (n = 0; n < n2 && (bl = ComparatorUtils.equals(fArray.elementAt(n), fArray2.elementAt(n))); ++n) {
            }
        } else {
            bl = false;
        }
        if (bl) {
            return GE.equals(string) || LE.equals(string) || EQ.equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (EQ.equals(string)) {
            return Boolean.FALSE;
        }
        if (NE1.equals(string) || NE2.equals(string)) {
            return Boolean.TRUE;
        }
        n = Math.min(fArray.length(), fArray2.length());
        n2 = 0;
        for (int i = 0; i < n && n2 == 0; ++i) {
            n2 = ComparatorUtils.compare(fArray.elementAt(i), fArray2.elementAt(i));
        }
        if (n2 == 0) {
            n2 = fArray.length() - fArray2.length();
        }
        if (n2 > 0) {
            return GT.equals(string) || GE.equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (n2 < 0) {
            return GT.equals(string) || GE.equals(string) ? Boolean.FALSE : Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected boolean isRelationExpression() {
        return true;
    }

    protected Object ccNINI(String string) {
        return RelationExpression.onEQ(string);
    }

    protected Object ccNIPI(String string) {
        return RelationExpression.onLT(string);
    }

    protected Object ccNIRE(Object object, String string) {
        return RelationExpression.onLT(string);
    }

    protected Object ccPINI(String string) {
        return RelationExpression.onGT(string);
    }

    protected Object ccPIPI(String string) {
        return RelationExpression.onEQ(string);
    }

    protected Object ccPIRE(Object object, String string) {
        return RelationExpression.onGT(string);
    }

    protected Object ccRENI(Object object, String string) {
        return RelationExpression.onGT(string);
    }

    protected Object ccREPI(Object object, String string) {
        return RelationExpression.onLT(string);
    }

    protected Object ccRERE(Object object, Object object2, String string) {
        if (object instanceof Number && object2 instanceof Number) {
            return this.numberOperation(object, object2, string);
        }
        if (ComparatorUtils.equals(object, object2)) {
            return RelationExpression.onEQ(string);
        }
        if (ComparatorUtils.compare(object, object2) > 0) {
            return RelationExpression.onGT(string);
        }
        return RelationExpression.onLT(string);
    }

    protected Object decimalOperation(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        return this.compareOperation(ComparatorUtils.compare(bigDecimal, bigDecimal2), string);
    }

    protected Object doubleOperation(double d, double d2, String string) {
        return this.compareOperation(ComparatorUtils.compare(d, d2), string);
    }

    protected Object intOperation(int n, int n2, String string) {
        return this.compareOperation(n - n2, string);
    }

    private Object compareOperation(double d, String string) {
        if (d == 0.0) {
            return RelationExpression.onEQ(string);
        }
        if (d > 0.0) {
            return RelationExpression.onGT(string);
        }
        return RelationExpression.onLT(string);
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        if (this.left != null) {
            this.left.traversal4Tiny(tinyHunter);
        }
        if (this.right != null) {
            this.right.traversal4Tiny(tinyHunter);
        }
    }

    public String exString(Calculator calculator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.left.exString(calculator));
        if (this.op != null && this.right != null) {
            stringBuffer.append(' ').append(this.op).append(' ').append(this.right.exString(calculator));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.left);
        if (this.op != null && this.right != null) {
            stringBuffer.append(' ').append(this.op).append(' ').append(this.right);
        }
        return stringBuffer.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.left.getExpression(n, n2, n3, n4, bl));
        if (this.op != null && this.right != null) {
            stringBuffer.append(' ').append(this.op).append(' ').append(this.right.getExpression(n, n2, n3, n4, bl));
        }
        return stringBuffer.toString();
    }

    public String[] parserParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.left.parserParameter()));
        if (this.op != null && this.right != null) {
            arrayList.addAll(Arrays.asList(this.right.parserParameter()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

