/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.core.parser;

import com.fr.report.script.Calculator;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.parser.AbstractNode;
import com.fr.report.script.core.parser.Atom;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.OperationUtils;
import com.fr.report.script.core.parser.TinyHunter;
import com.fr.report.script.core.parser.UtilEvalError;
import java.math.BigDecimal;

public class UnaryExpression
extends AbstractNode {
    String op;
    Atom atom;

    UnaryExpression(String string, Atom atom) {
        this.op = string;
        this.atom = atom;
    }

    public Object eval(Calculator calculator) throws UtilEvalError {
        if (this.atom == null) {
            throw new InterpreterError("atom should not be null");
        }
        Object object = this.atom.eval(calculator);
        if (this.op != null) {
            object = this.primitiveWrapperUnaryOperation(object, this.op);
        }
        return object;
    }

    private Object primitiveWrapperUnaryOperation(Object object, String string) throws UtilEvalError {
        if (object == Primitive.ERROR_NAME || object == Primitive.ERROR_NAME) {
            return Primitive.ERROR_NAME;
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            Object[] objectArray = new Object[fArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.primitiveWrapperUnaryOperation(fArray.elementAt(i), string);
            }
            return new FArray(objectArray);
        }
        Object object2 = OperationUtils.promoteCharByteShort(object);
        if (object2 instanceof Boolean) {
            return new Boolean(OperationUtils.booleanUnaryOperation((Boolean)object2, string));
        }
        if (object2 instanceof Integer) {
            return new Integer(OperationUtils.intUnaryOperation((Integer)object2, string));
        }
        if (object2 instanceof Long) {
            return new Long(OperationUtils.longUnaryOperation((Long)object2, string));
        }
        if (object2 instanceof Float) {
            return new Float(OperationUtils.floatUnaryOperation((Float)object2, string));
        }
        if (object2 instanceof Double) {
            return new Double(OperationUtils.doubleUnaryOperation((Double)object2, string));
        }
        if (object2 instanceof BigDecimal) {
            return OperationUtils.bigDecimalUnaryOperation((BigDecimal)object2, string);
        }
        throw new InterpreterError("error exists: " + string + this.atom);
    }

    public void traversal4Tiny(TinyHunter tinyHunter) {
        this.atom.traversal4Tiny(tinyHunter);
    }

    public String exString(Calculator calculator) {
        return (this.op != null ? this.op : "") + this.atom.exString(calculator);
    }

    public String toString() {
        return (this.op != null ? this.op : "") + this.atom.toString();
    }

    public String getExpression(int n, int n2, int n3, int n4, boolean bl) {
        return (this.op != null ? this.op : "") + this.atom.getExpression(n, n2, n3, n4, bl);
    }

    public String[] parserParameter() {
        return this.atom.parserParameter();
    }
}

