/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.function;

import com.fr.report.script.Function;
import com.fr.report.script.NormalFunction;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FunctionHelper;

public class ASINH
extends NormalFunction {
    public Object run(Object[] objectArray) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        double d = 0.0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Number)) continue;
            double d2 = ((Number)objectArray[i]).doubleValue();
            d = Math.log(d2 + Math.sqrt(d2 * d2 + 1.0));
            break;
        }
        return FunctionHelper.parsePrimitiveDouble(d);
    }

    public Function.Type getType() {
        return Function.MATH;
    }

    public String getCN() {
        return "ASINH(number): \u8fd4\u56de\u6307\u5b9a\u6570\u503c\u7684\u53cd\u53cc\u66f2\u6b63\u5f26\u503c\u3002\u53cd\u53cc\u66f2\u6b63\u5f26\u503c\u7684\u53cc\u66f2\u6b63\u5f26\u7b49\u4e8e\u6307\u5b9a\u6570\u503c\u3002\u5373: ASINH(SINH(number))=number\u3002\nNumber:\u4efb\u610f\u5b9e\u6570\u3002\n\u793a\u4f8b:\nASINH(-5)\u7b49\u4e8e-2.312438341\u3002\nASINH(8)\u7b49\u4e8e2.776472281\u3002\nASINH(16)\u7b49\u4e8e3.466711038\u3002";
    }

    public String getEN() {
        return "ASINH(number): Returns the inverse hyperbolic sine of a number. The inverse hyperbolic sine is the value whose hyperbolic sine is number, so ASINH(SINH(number)) equals number.\nNumber is any real number.\n\nExample:\n   ASINH(-5)=-2.312438341\n   ASINH(8)=2.776472281\n   ASINH(16)=3.466711038";
    }
}

