/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.function;

import com.fr.report.script.Function;
import com.fr.report.script.NormalFunction;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FunctionHelper;

public class ATANH
extends NormalFunction {
    public Object run(Object[] objectArray) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        Object object = objectArray[0];
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return FunctionHelper.parsePrimitiveDouble(Math.log((1.0 + d) / (1.0 - d)) / 2.0);
        }
        return Primitive.ERROR_NAME;
    }

    public Function.Type getType() {
        return Function.MATH;
    }

    public String getCN() {
        return "ATANH(number): \u8fd4\u56de\u6570\u5b57\u7684\u53cd\u53cc\u66f2\u6b63\u5207\u503c\uff0c\u8be5\u51fd\u6570\u7684\u53c2\u6570\u503c\u5373\u4e3a\u53cd\u53cc\u66f2\u6b63\u5207\u503c\u7684\u53cc\u66f2\u6b63\u5207\u503c\u3002\nNumber:\u6307\u4ecb\u4e8e-1~1\u4e4b\u95f4\u7684\u4efb\u610f\u5b9e\u6570\u3002\n\u5907\u6ce8:\n    \u6307\u5b9a\u7684number\u5fc5\u987b\u4ecb\u4e8e-1~1\u4e4b\u95f4\uff08\u4e0d\u5305\u62ec-1\uff0c1\uff09\u3002\n    ATANH(TANH(number))=number\uff0c\u4f8b\u5982\uff0cATANH(TANH(8))=8\u3002\n\u793a\u4f8b:\nATANH(-0.5)\u7b49\u4e8e-0.549306144\u3002\nATANH(0)\u7b49\u4e8e0\u3002\nATANH(0.7)\u7b49\u4e8e0.867300528\u3002";
    }

    public String getEN() {
        return "ATANH(number): Returns the inverse hyperbolic tangent of a number. \n\nRemarks:\n    Number must be between -1 and 1 (excluding -1 and 1).\n    ATANH(TANH(number))=number, for example ATANH(TANH(8))=8.\n\nExample:\n   ATANH(-0.5) = -0.549306144\n   ATANH(0) = 0\n   ATANH(0.7) = 0.867300528";
    }
}

