/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.function;

import com.fr.report.script.Function;
import com.fr.report.script.NormalFunction;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.FunctionHelper;

public class AVERAGE
extends NormalFunction {
    public Object run(Object[] objectArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            d += this.parseObject(objectArray[i]);
            n += this.parseObjectCount(objectArray[i]);
        }
        return FunctionHelper.parsePrimitiveDouble(d / (double)n);
    }

    private double parseObject(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            double d = 0.0;
            int n = fArray.length();
            for (int i = 0; i < n; ++i) {
                d += this.parseObject(fArray.elementAt(i));
            }
            return d;
        }
        if (object != null) {
            try {
                return Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    private int parseObjectCount(Object object) {
        if (object instanceof FArray) {
            return ((FArray)object).length();
        }
        if (!(object instanceof Primitive)) {
            return 1;
        }
        return 0;
    }

    public Function.Type getType() {
        return Function.MATH;
    }

    public String getCN() {
        return "AVERAGE(number1,number2,\u2026): \u8fd4\u56de\u6307\u5b9a\u6570\u636e\u7684\u5e73\u5747\u503c\u3002\nNumber1,number2\u2026:\u7528\u4e8e\u8ba1\u7b97\u5e73\u5747\u503c\u7684\u53c2\u6570\u3002\n\u5907\u6ce8:\n    \u53c2\u6570\u5fc5\u987b\u662f\u6570\u5b57\uff0c\u6216\u662f\u542b\u6709\u6570\u5b57\u7684\u540d\u79f0\uff0c\u6570\u7ec4\u6216\u5f15\u7528\u3002\n    \u5982\u679c\u6570\u7ec4\u6216\u5f15\u7528\u53c2\u6570\u4e2d\u542b\u6709\u6587\u5b57\uff0c\u903b\u8f91\u503c\uff0c\u6216\u7a7a\u767d\u5355\u5143\u683c\uff0c\u8fd9\u4e9b\u503c\u5c06\u88ab\u5ffd\u7565\uff1b\u4f46\u662f\uff0c\u5355\u5143\u683c\u4e2d\u7684\u96f6\u503c\u5219\u53c2\u4e0e\u8ba1\u7b97\u3002\n\u793a\u4f8b:\n\u5982\u679cA1:A6\u88ab\u547d\u540d\u4e3a\u201cages\u201d\uff0c\u5206\u522b\u7b49\u4e8e10\uff0c23\uff0c14\uff0c24\uff0c33\u53ca25\uff0c\u5219:\nAVERAGE(A1:A6)\u7b49\u4e8e21.5\u3002\nAVERAGE(ages)\u7b49\u4e8e21.5\u3002\n\u5982\u679c\u8fd8\u6709\u4e00\u4e2a\u5e74\u9f84\u4e3a18\u7684\uff0c\u6c42\u6240\u6709\u5e74\u9f84\u7684\u5e73\u5747\u503c\u4e3a: AVERAGE(A1:A6,18)\u7b49\u4e8e21\u3002";
    }

    public String getEN() {
        return "AVERAGE(number1,number2,\u2026): Returns the average (arithmetic mean) of the arguments.\nNumber1, number2, ...  are 1 to 30 numeric arguments for which you want the average.\n\nRemarks:\n1. The arguments must either be numbers or be names, arrays, or references that contain numbers. \n2. If an array or reference argument contains text, logical values, or empty cells, those values are ignored; however, cells with the value zero are included. \n\nExample:\n\u5982\u679cA1:A6\u88ab\u547d\u540d\u4e3a\u201cages\u201d\uff0c\u5206\u522b\u7b49\u4e8e10\uff0c23\uff0c14\uff0c24\uff0c33\u53ca25\uff0c\u5219:\nAVERAGE(A1:A6)\u7b49\u4e8e21.5\u3002\nAVERAGE(ages)\u7b49\u4e8e21.5\u3002\n\u5982\u679c\u8fd8\u6709\u4e00\u4e2a\u5e74\u9f84\u4e3a18\u7684\uff0c\u6c42\u6240\u6709\u5e74\u9f84\u7684\u5e73\u5747\u503c\u4e3a: AVERAGE(A1:A6,18)\u7b49\u4e8e21\u3002";
    }
}

