/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.function;

import com.fr.base.FRContext;
import com.fr.base.core.antlr.ANTLRException;
import com.fr.report.script.Calculator;
import com.fr.report.script.DelayedFunction;
import com.fr.report.script.Function;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.parser.Expression;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;

public class MAPARRAY
extends DelayedFunction {
    public Object run(Object[] objectArray) {
        Expression expression;
        if (objectArray.length != 2) {
            return Primitive.ERROR_VALUE;
        }
        if (objectArray[0] == null) {
            return null;
        }
        FArray fArray = new FArray();
        if (!(objectArray[0] instanceof FArray)) {
            fArray.add(objectArray[0].toString());
        } else {
            fArray = (FArray)objectArray[0];
        }
        Calculator calculator = this.getCalculator();
        try {
            expression = calculator.parse(objectArray[1]);
        }
        catch (ANTLRException aNTLRException) {
            FRContext.getLogger().log(Level.WARNING, aNTLRException.getMessage(), aNTLRException);
            return fArray;
        }
        Iterator iterator = fArray.iterator();
        int n = 0;
        FArray fArray2 = new FArray();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("item", e);
            hashMap.put("index", new Integer(n + 1));
            ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(hashMap);
            calculator.pushNameSpace(parameterMapNameSpace);
            try {
                Object object = expression.eval(calculator);
                fArray2.add(object);
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().log(Level.INFO, utilEvalError.getMessage(), utilEvalError);
            }
            calculator.removeNameSpace(parameterMapNameSpace);
            ++n;
        }
        return fArray2;
    }

    public Function.Type getType() {
        return Function.ARRAY;
    }

    public String getCN() {
        return "MAPARRAY(array, fn):\u628a\u4e00\u4e2a\u6570\u7ec4\u4e2d\u7684\u9879\u76ee\u8f6c\u6362\u5230\u53e6\u4e00\u4e2a\u6570\u7ec4\u4e2d\u3002\narray (Array): \u8981\u8f6c\u6362\u7684\u6570\u7ec4 \nfn (Function): \u5904\u7406\u6570\u7ec4\u9879\u76ee\u7684\u51fd\u6570 \n\u793a\u4f8b\uff1a\nMAPARRAY([3,4,2,3,6,8,7], item != 3)\u7b49\u4e8e[false,true,true,false,true,true,true].";
    }

    public String getEN() {
        return "";
    }
}

