/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.script.function;

import com.fr.report.script.Function;
import com.fr.report.script.NormalFunction;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.FunctionHelper;

public class SUM
extends NormalFunction {
    public Object run(Object[] objectArray) {
        double d = 0.0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            d += this.parseObject(objectArray[i]);
        }
        return FunctionHelper.parsePrimitiveDouble(d);
    }

    private double parseObject(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            double d = 0.0;
            int n = fArray.length();
            for (int i = 0; i < n; ++i) {
                d += this.parseObject(fArray.elementAt(i));
            }
            return d;
        }
        if (object != null) {
            try {
                return Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public Function.Type getType() {
        return Function.MATH;
    }

    public String getCN() {
        return "SUM(number1,number2,\u2026): \u6c42\u4e00\u4e2a\u6307\u5b9a\u5355\u5143\u683c\u533a\u57df\u4e2d\u6240\u6709\u6570\u5b57\u4e4b\u548c\u3002\nNumber1,number2,\u2026:1\u523030\u4e2a\u53c2\u6570\u6216\u6307\u5b9a\u5355\u5143\u683c\u533a\u57df\u4e2d\u6240\u6709\u6570\u5b57\u3002\n\u5907\u6ce8:\n    \u51fd\u6570\u5c06\u76f4\u63a5\u952e\u5165\u53c2\u6570\u4e2d\u7684\u6570\u503c\u3001\u903b\u8f91\u503c\u53ca\u6587\u672c\u8868\u8fbe\u5f0f\u8ba1\u7b97\u5728\u5185\u3002\n    \u82e5\u53c2\u6570\u662f\u6570\u7ec4\u6216\u5f15\u7528\uff0c\u5219\u53ea\u6709\u6570\u7ec4\u6216\u5355\u5143\u683c\u5f15\u7528\u4e2d\u7684\u6570\u503c\u8fdb\u884c\u8ba1\u7b97\u3002\n\u793a\u4f8b:\nSUM(70,80)\u7b49\u4e8e150\u3002\nSUM(\"70\",80,TRUE)\u7b49\u4e8e151\uff0c\u903b\u8f91\u503c\u201cTRUE\u201d\u4f5c\u4e3a1\u6765\u8ba1\u7b97\uff1b\u201cFALSE\u201d\u4f5c\u4e3a0\u8ba1\u7b97\uff1b\u6587\u672c\u201c70\u201d\u4f5c\u4e3a70\u6765\u8ba1\u7b97\u3002";
    }

    public String getEN() {
        return "SUM(number1,number2,\u2026): Adds all the numbers in a range of cells.\nNumber1, number2, ...    are 1 to 30 arguments for which you want the total value or sum.\n\nRemarks:\n1. Numbers, logical values, and text representations of numbers that you type directly into the list of arguments are counted. See the first and second examples following. \n2. If an argument is an array or reference, only numbers in that array or reference are counted. Empty cells, logical values, text, or error values in the array or reference are ignored. See the third example following. \n\nExample:\n   SUM(70,80)=150.\n   SUM(\"70\",80,TRUE)=151, TRUE is calculated as 1, FALSE for 0, String \"70\" fo 70.";
    }
}

