/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.semantic;

import com.fr.base.ColumnRow;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.condition.Condition;
import com.fr.data.condition.LiteConditionUtils;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.ReportParameterAttr;
import com.fr.report.TemplateReport;
import com.fr.report.WorkBook;
import com.fr.report.WorkSheet;
import com.fr.report.parameter.Parameter;
import com.fr.report.semantic.WizardCellElement;
import com.fr.report.semantic.WizardRpt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractWizardRpt
implements WizardRpt {
    private List tableDataNameList = new ArrayList();
    private List tableDataList = new ArrayList();
    private boolean showParameterWindow = true;
    private int parameterWindowPosition = 1;

    public void setShowParameterWindow(boolean bl) {
        this.showParameterWindow = bl;
    }

    public boolean isShowParameterWindow() {
        return this.showParameterWindow;
    }

    public int getParameterWindowPosition() {
        return this.parameterWindowPosition;
    }

    public void setParameterWindowPosition(int n) {
        this.parameterWindowPosition = n;
    }

    public WorkBook generateWorkBook() {
        Object object;
        WorkBook workBook = new WorkBook();
        WorkSheet workSheet = new WorkSheet();
        workBook.addReport(workSheet);
        workSheet.getReportSettings().setShrinkToFitMode(1);
        Iterator iterator = this.getTableDataNameIterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            TableData tableData = this.getTableData((String)object);
            workBook.putTableData((String)object, tableData);
        }
        this.insertIntoReport(workSheet, ColumnRow.valueOf(0, 0));
        object = workBook.getReportParameterAttr();
        if (object == null) {
            object = new ReportParameterAttr();
            workBook.setReportParameterAttr((ReportParameterAttr)object);
        }
        ((ReportParameterAttr)object).setShowWindow(this.isShowParameterWindow());
        ((ReportParameterAttr)object).setWindowPosition(this.getParameterWindowPosition());
        return workBook;
    }

    public abstract void insertIntoReport(TemplateReport var1, ColumnRow var2);

    public Iterator getTableDataNameIterator() {
        return this.tableDataNameList.iterator();
    }

    public TableData getTableData(String string) {
        int n = this.tableDataNameList.indexOf(string);
        if (n == -1) {
            return null;
        }
        return (TableData)this.tableDataList.get(n);
    }

    public void putTableData(String string, TableData tableData) {
        if (string == null) {
            return;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (tableData == null) {
            if (n != -1) {
                this.tableDataNameList.remove(n);
                this.tableDataList.remove(n);
            }
        } else if (n != -1) {
            this.tableDataList.set(n, tableData);
        } else {
            this.tableDataNameList.add(string);
            this.tableDataList.add(tableData);
        }
    }

    public boolean renameTableData(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        if (ComparatorUtils.equals(string, string2)) {
            return false;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (n == -1) {
            return false;
        }
        this.tableDataNameList.set(n, string2);
        return true;
    }

    public void removeTableData(String string) {
        if (string == null) {
            return;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (n != -1) {
            this.tableDataNameList.remove(n);
            this.tableDataList.remove(n);
        }
    }

    public void clearAllTableData() {
        this.tableDataNameList.clear();
        this.tableDataList.clear();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("TableDataMap".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isAttr()) {
                            AbstractWizardRpt.this.clearAllTableData();
                        }
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("NameTableData")) {
                            String string = null;
                            String string2 = xMLableReader.getAttr("name");
                            if (string2 != null) {
                                string = string2;
                            }
                            XMLObject xMLObject = new XMLObject(this, null){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.isChildNode() && "TableData".equals(xMLableReader.getTagName())) {
                                        this.obj = DataXMLUtils.readXMLTableData(xMLableReader);
                                    }
                                }
                            };
                            xMLableReader.readXMLObject(xMLObject);
                            AbstractWizardRpt.this.putTableData(string, (TableData)xMLObject.getObject());
                        }
                    }
                });
            } else if ("ParameterAttributes".equals(string)) {
                String string2 = xMLableReader.getAttr("showParameterWindow");
                if (string2 != null) {
                    this.setShowParameterWindow(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("parameterWindowPosition")) != null) {
                    this.setParameterWindowPosition(Integer.parseInt(string2));
                }
            }
        }
    }

    protected void addWCelllElementCondition(TemplateReport templateReport, WizardCellElement wizardCellElement) {
        if (wizardCellElement == null) {
            return;
        }
        Condition condition = wizardCellElement.getCondition();
        if (condition != null) {
            ReportParameterAttr reportParameterAttr;
            ArrayList arrayList = new ArrayList();
            LiteConditionUtils.getAllParameters(condition, arrayList);
            ReportParameterAttr reportParameterAttr2 = reportParameterAttr = templateReport.getTemplateWorkBook() == null ? null : templateReport.getTemplateWorkBook().getReportParameterAttr();
            if (reportParameterAttr == null) {
                reportParameterAttr = new ReportParameterAttr();
                templateReport.getTemplateWorkBook().setReportParameterAttr(reportParameterAttr);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                reportParameterAttr.addParameter((Parameter)arrayList.get(i));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.tableDataNameList != null && this.tableDataNameList.size() > 0) {
            xMLPrintWriter.startTAG("TableDataMap");
            for (int i = 0; i < this.tableDataNameList.size(); ++i) {
                String string = (String)this.tableDataNameList.get(i);
                TableData tableData = (TableData)this.tableDataList.get(i);
                xMLPrintWriter.startTAG("NameTableData").attr("name", string);
                if (tableData != null) {
                    DataXMLUtils.writeXMLTableData(xMLPrintWriter, tableData);
                }
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("ParameterAttributes").attr("showParameterWindow", this.showParameterWindow).attr("parameterWindowPosition", this.parameterWindowPosition).end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

