/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.semantic;

import com.fr.base.Style;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.condition.Condition;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.util.function.AbstractDataFunction;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.TableDataColumn;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.cellElement.core.SummaryGrouper;
import com.fr.report.io.xml.ReportXMLUtils;
import java.io.Serializable;

public class WizardCellElement
implements XMLReadable,
Serializable,
Cloneable {
    private String tableDataName;
    private String columnName;
    private Style style = Style.DEFAULT_STYLE;
    private Condition condition;
    private int summary = 0;
    private int order = 1;
    private int rowHeight = 19;
    private int columnWidth = 72;

    public String getTableDataName() {
        return this.tableDataName;
    }

    public void setTableDataName(String string) {
        this.tableDataName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public int getSummary() {
        return this.summary;
    }

    public void setSummary(int n) {
        this.summary = n;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public void setColumnWidth(int n) {
        this.columnWidth = n;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public CellElement toCellElement() {
        return this.toCellElement(0, 0);
    }

    public CellElement toCellElement(int n, int n2) {
        return this.toCellElement(n, n2, (byte)0);
    }

    public CellElement toCellElement(int n, int n2, byte by) {
        return this.toCellElement(n, n2, 1, 1, by);
    }

    public CellElement toCellElement(int n, int n2, int n3, int n4, byte by) {
        TableDataColumn tableDataColumn;
        DefaultCellElement defaultCellElement = new DefaultCellElement(n, n2, n3, n4, null);
        CellExpandAttr cellExpandAttr = defaultCellElement.getCellExpandAttr();
        if (cellExpandAttr == null) {
            cellExpandAttr = new CellExpandAttr();
            defaultCellElement.setCellExpandAttr(cellExpandAttr);
        }
        cellExpandAttr.setDirection(by);
        cellExpandAttr.setExtendable((byte)0);
        Object object = defaultCellElement.getValue();
        DSColumn dSColumn = null;
        if (object == null || !(object instanceof DSColumn)) {
            dSColumn = new DSColumn();
            defaultCellElement.setValue(dSColumn);
        }
        dSColumn = (DSColumn)defaultCellElement.getValue();
        dSColumn.setDSName(this.tableDataName);
        String string = this.columnName;
        if (string.startsWith("#")) {
            int n5 = Integer.parseInt(string.substring(1));
            tableDataColumn = TableDataColumn.createColumn(n5);
        } else {
            tableDataColumn = TableDataColumn.createColumn(string);
        }
        dSColumn.setColumn(tableDataColumn);
        dSColumn.setOrder(this.order);
        if (this.condition != null) {
            dSColumn.setCondition(this.condition);
        }
        if (this.summary != 0) {
            SummaryGrouper summaryGrouper = new SummaryGrouper();
            summaryGrouper.setFunction(AbstractDataFunction.createDataFunction(this.summary));
            dSColumn.setGrouper(summaryGrouper);
        }
        Style style = this.getStyle();
        style = style.deriveTextStyle(0);
        defaultCellElement.setStyle(style);
        return defaultCellElement;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("WCellAttr".equals(string)) {
                String string2 = xMLableReader.getAttr("tableDataName");
                if (string2 != null) {
                    this.setTableDataName(string2);
                }
                if ((string2 = xMLableReader.getAttr("columnName")) != null) {
                    this.setColumnName(string2);
                }
                if ((string2 = xMLableReader.getAttr("order")) != null) {
                    this.setOrder(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("summary")) != null) {
                    this.summary = Integer.parseInt(string2);
                }
                if ((string2 = xMLableReader.getAttr("columnWidth")) != null) {
                    this.columnWidth = Integer.parseInt(string2);
                }
                if ((string2 = xMLableReader.getAttr("rowHeight")) != null) {
                    this.rowHeight = Integer.parseInt(string2);
                }
            } else if ("Style".equals(string)) {
                this.setStyle(ReportXMLUtils.readFullStyle(xMLableReader));
            } else if ("Condition".equals(string)) {
                this.condition = DataXMLUtils.readXMLCondition(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("WCellAttr").attr("tableDataName", this.getTableDataName()).attr("columnName", this.getColumnName()).attr("order", this.getOrder()).attr("summary", this.getSummary()).attr("columnWidth", this.getColumnWidth()).attr("rowHeight", this.getRowHeight()).end();
        if (this.getStyle() != null) {
            ReportXMLUtils.writeStyle(xMLPrintWriter, this.style);
        }
        if (this.condition != null) {
            DataXMLUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WizardCellElement wizardCellElement = (WizardCellElement)super.clone();
        if (this.condition != null) {
            wizardCellElement.setCondition((Condition)this.condition.clone());
        }
        return wizardCellElement;
    }
}

