/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web;

import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.web.core.MailAuthenticator;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailManager
implements XMLable {
    private String mailHost = null;
    private String user = null;
    private String password = null;
    private String fromEmailAddress = null;
    private transient Properties mailProperties;

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailHost(String string) {
        this.mailHost = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    public void setFromEmailAddress(String string) {
        this.fromEmailAddress = string;
    }

    public void sendTestMail(String string) throws MessagingException {
        this.send(string, "Email Test", Inter.getLocText("ReportServerP-Congratulation_Email_Test_Success"));
    }

    public void send(String string, String string2, String string3) throws MessagingException {
        this.send(string, null, null, string2, string3, null);
    }

    public void send(String string, String string2, String string3, String string4) throws MessagingException {
        this.send(string, null, null, null, string2, string3, null, string4);
    }

    public void send(String string, String string2, String string3, String string4, String string5, Object object) throws MessagingException {
        this.send(string, string2, string3, null, string4, string5, object, null);
    }

    public void send(String string, String string2, String string3, String string4, String string5, String string6, Object object) throws MessagingException {
        this.send(string, string2, string3, string4, string5, string6, object, null);
    }

    public void send(String string, String string2, String string3, String string4, String string5, String string6, Object object, String string7) throws MessagingException {
        Address[] addressArray;
        Address[] addressArray2;
        Address[] addressArray3;
        File[] fileArray;
        Properties properties = this.asMailProperties();
        Session session = Session.getInstance((Properties)properties, (Authenticator)new MailAuthenticator(properties.getProperty("mail.user"), properties.getProperty("mail.password")));
        MimeMessage mimeMessage = new MimeMessage(session);
        if (StringUtils.isNotBlank(string)) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string));
        }
        if (StringUtils.isNotBlank(string2)) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)string2));
        }
        if (StringUtils.isNotBlank(string3)) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)string3));
        }
        if (StringUtils.isBlank(string4) && StringUtils.isBlank(string4 = this.fromEmailAddress)) {
            string4 = Inter.getLocText("HTML-Report_Mail_Server");
        }
        mimeMessage.setFrom((Address)new InternetAddress(string4));
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        if (string7 == null) {
            mimeBodyPart.setText(string6);
        } else {
            mimeBodyPart.setContent((Object)string6, string7);
        }
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeMessage.setSubject(string5);
        mimeMessage.setContent((Multipart)mimeMultipart);
        mimeMessage.setSentDate(new Date());
        if (object instanceof File) {
            fileArray = (File[])object;
            if (fileArray != null && fileArray.exists()) {
                addressArray3 = new MimeBodyPart();
                addressArray2 = new FileDataSource((File)fileArray);
                addressArray3.setDataHandler(new DataHandler((DataSource)addressArray2));
                addressArray3.setFileName(fileArray.getName());
                mimeMultipart.addBodyPart((BodyPart)addressArray3);
            }
        } else if (object instanceof File[]) {
            fileArray = (File[])object;
            for (int i = 0; i < fileArray.length; ++i) {
                addressArray2 = new MimeBodyPart();
                addressArray = new FileDataSource((File)fileArray[i]);
                addressArray2.setDataHandler(new DataHandler((DataSource)addressArray));
                addressArray2.setFileName(fileArray[i].getName());
                mimeMultipart.addBodyPart((BodyPart)addressArray2);
            }
        } else if (object instanceof String[]) {
            fileArray = (String[])object;
            for (int i = 0; i < fileArray.length; ++i) {
                addressArray2 = new MimeBodyPart();
                addressArray = new FileDataSource((String)fileArray[i]);
                addressArray2.setDataHandler(new DataHandler((DataSource)addressArray));
                addressArray2.setFileName((String)fileArray[i]);
                mimeMultipart.addBodyPart((BodyPart)addressArray2);
            }
        }
        mimeMessage.saveChanges();
        fileArray = session.getTransport("smtp");
        fileArray.connect();
        addressArray3 = mimeMessage.getRecipients(Message.RecipientType.TO);
        if (addressArray3 == null) {
            addressArray3 = new Address[]{};
        }
        if ((addressArray2 = mimeMessage.getRecipients(Message.RecipientType.CC)) == null) {
            addressArray2 = new Address[]{};
        }
        if ((addressArray = mimeMessage.getRecipients(Message.RecipientType.BCC)) == null) {
            addressArray = new Address[]{};
        }
        Address[] addressArray4 = new Address[addressArray3.length + addressArray2.length + addressArray.length];
        System.arraycopy(addressArray3, 0, addressArray4, 0, addressArray3.length);
        System.arraycopy(addressArray2, 0, addressArray4, addressArray3.length, addressArray2.length);
        System.arraycopy(addressArray, 0, addressArray4, addressArray3.length + addressArray2.length, addressArray.length);
        fileArray.sendMessage((Message)mimeMessage, addressArray4);
        fileArray.close();
    }

    private Properties asMailProperties() {
        if (this.mailProperties == null) {
            this.mailProperties = new Properties();
            this.mailProperties.put("mail.smtp.host", this.mailHost);
            this.mailProperties.put("mail.transport.protocol", "smtp");
            this.mailProperties.put("mail.smtp.starttls.enable", "true");
            this.mailProperties.put("mail.smtp.auth", "true");
            this.mailProperties.put("mail.user", this.user);
            this.mailProperties.put("mail.password", this.password);
        }
        return this.mailProperties;
    }

    public JSONObject createJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("serverName", this.mailHost);
        jSONObject.put("fromAddress", this.fromEmailAddress);
        jSONObject.put("userName", this.user);
        jSONObject.put("passWord", this.password);
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        if (StringUtils.isNotEmpty(jSONObject.getString("serverName"))) {
            this.setMailHost(jSONObject.getString("serverName"));
        }
        if (StringUtils.isNotEmpty(jSONObject.getString("fromAddress"))) {
            this.setFromEmailAddress(jSONObject.getString("fromAddress"));
        }
        if (StringUtils.isNotEmpty(jSONObject.getString("userName"))) {
            this.setUser(jSONObject.getString("userName"));
        }
        if (StringUtils.isNotEmpty(jSONObject.getString("passWord"))) {
            this.setPassword(jSONObject.getString("passWord"));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("EmailManager").attr("mailHost", this.getMailHost()).attr("password", ReportXMLUtils.passwordString(this.getPassword())).attr("user", this.getUser()).attr("fromEmailAddress", this.getFromEmailAddress()).end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttr("mailHost");
            if (string != null) {
                this.setMailHost(string);
            }
            if ((string = xMLableReader.getAttr("fromEmailAddress")) != null) {
                this.setFromEmailAddress(string);
            }
            if ((string = xMLableReader.getAttr("password")) != null) {
                this.setPassword(ReportXMLUtils.unPasswordString(string));
            }
            if ((string = xMLableReader.getAttr("user")) != null) {
                this.setUser(string);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

