/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web;

import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import java.io.Serializable;

public abstract class Location
implements Serializable,
Cloneable {
    public static Location createTopEmbedLocation() {
        return new Embed(1);
    }

    public static Location createBottomEmbedLocation() {
        return new Embed(3);
    }

    public static Location createEmbedLocation(int n) {
        return new Embed(n);
    }

    public static Location createFloatLocation(int n, int n2, int n3, int n4) {
        return new Float(n, n2, n3, n4);
    }

    public static void writeXML(Location location, XMLPrintWriter xMLPrintWriter) {
        if (location != null) {
            xMLPrintWriter.startTAG("Location");
            if (location instanceof Embed) {
                xMLPrintWriter.startTAG("Embed").attr("position", ((Embed)location).getPosition()).end();
            } else if (location instanceof Float) {
                xMLPrintWriter.startTAG("Float").attr("left", ((Float)location).getLeft()).attr("right", ((Float)location).getRight()).attr("top", ((Float)location).getTop()).attr("bottom", ((Float)location).getBottom()).end();
            }
            xMLPrintWriter.end();
        }
    }

    public static Location readXML(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(null){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string;
                    String string2 = xMLableReader.getTagName();
                    if ("Embed".equals(string2) && (string = xMLableReader.getAttr("position")) != null) {
                        this.obj = Location.createEmbedLocation(Integer.parseInt(string));
                    } else if ("Float".equals(string2)) {
                        int n = -1;
                        int n2 = -1;
                        int n3 = -1;
                        int n4 = -1;
                        string = xMLableReader.getAttr("left");
                        if (string != null) {
                            n = Integer.parseInt(string);
                        }
                        if ((string = xMLableReader.getAttr("right")) != null) {
                            n2 = Integer.parseInt(string);
                        }
                        if ((string = xMLableReader.getAttr("top")) != null) {
                            n3 = Integer.parseInt(string);
                        }
                        if ((string = xMLableReader.getAttr("bottom")) != null) {
                            n4 = Integer.parseInt(string);
                        }
                        this.obj = Location.createFloatLocation(n3, n4, n, n2);
                    }
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (Location)xMLObject.getObject();
    }

    public static final class Float
    extends Location {
        private int top;
        private int bottom;
        private int left;
        private int right;

        public Float() {
        }

        public Float(int n, int n2, int n3, int n4) {
            this.top = n;
            this.bottom = n2;
            this.left = n3;
            this.right = n4;
        }

        public int getTop() {
            return this.top;
        }

        public void setTop(int n) {
            this.top = n;
        }

        public int getBottom() {
            return this.bottom;
        }

        public void setBottom(int n) {
            this.bottom = n;
        }

        public int getLeft() {
            return this.left;
        }

        public void setLeft(int n) {
            this.left = n;
        }

        public int getRight() {
            return this.right;
        }

        public void setRight(int n) {
            this.right = n;
        }
    }

    public static final class Embed
    extends Location {
        private int position = 1;

        public Embed() {
        }

        public Embed(int n) {
            this.position = n == 1 ? 1 : 3;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            this.position = n;
        }
    }
}

