/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web;

import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.Mapper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.Location;
import com.fr.report.web.ui.Button;
import com.fr.report.web.ui.ToolBar;
import com.fr.report.web.ui.Widget;
import com.fr.report.web.ui.impl.Email;
import com.fr.report.web.ui.impl.Excel;
import com.fr.report.web.ui.impl.Export;
import com.fr.report.web.ui.impl.FlashPrint;
import com.fr.report.web.ui.impl.PDF;
import com.fr.report.web.ui.impl.PDFPrint;
import com.fr.report.web.ui.impl.Print;
import com.fr.report.web.ui.impl.ServerPrint;
import com.fr.report.web.ui.impl.page.First;
import com.fr.report.web.ui.impl.page.Last;
import com.fr.report.web.ui.impl.page.Next;
import com.fr.report.web.ui.impl.page.PageNavi;
import com.fr.report.web.ui.impl.page.Previous;
import com.fr.report.web.ui.impl.write.AppendColumnRow;
import com.fr.report.web.ui.impl.write.ShowCellValue;
import com.fr.report.web.ui.impl.write.Submit;
import com.fr.report.web.ui.impl.write.Verify;
import com.fr.web.Repository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ToolBarManager
implements Serializable,
Cloneable,
XMLReadable {
    public static final String XML_TAG = "ToolBarManager";
    private Location toolBarLocation;
    private ToolBar toolBar;

    public static ToolBarManager createDefaultToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new First(), new Previous(), new PageNavi(), new Next(), new Last(), new FlashPrint(), new Print(), new Export(), new Email()}));
        return toolBarManager;
    }

    public static ToolBarManager createPrintPreviewToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new First(), new Previous(), new PageNavi(), new Next(), new Last(), new FlashPrint(), new Print(), new Export()}));
        return toolBarManager;
    }

    public static ToolBarManager createDefaultFormToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new FlashPrint(), new Print(), new Export(), new Email()}));
        return toolBarManager;
    }

    public static ToolBarManager createDefaultWriteToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new Submit(), new Verify(), new FlashPrint(), new Print(), new Export(), new Email(), new AppendColumnRow(), new ShowCellValue()}));
        return toolBarManager;
    }

    public Location getToolBarLocation() {
        return this.toolBarLocation;
    }

    public void setToolBarLocation(Location location) {
        this.toolBarLocation = location;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        Location.writeXML(this.toolBarLocation, xMLPrintWriter);
        if (this.toolBar != null) {
            this.toolBar.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        Object object;
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttr("toolbarPosition");
            if (string != null) {
                this.setToolBarLocation(Location.createEmbedLocation(Integer.parseInt(string)));
            }
            object = new ArrayList();
            object.add(new First());
            object.add(new Previous());
            object.add(new PageNavi());
            object.add(new Next());
            object.add(new Last());
            boolean bl = true;
            boolean bl2 = true;
            string = xMLableReader.getAttr("isIconVisible");
            if (string != null) {
                bl = Boolean.valueOf(string);
            }
            if ((string = xMLableReader.getAttr("isTextVisible")) != null) {
                bl2 = Boolean.valueOf(string);
            }
            if ((string = xMLableReader.getAttr("isShowFlashPrint")) != null && Boolean.valueOf(string).booleanValue()) {
                object.add(new FlashPrint());
            }
            if ((string = xMLableReader.getAttr("isShowPDFPrint")) != null && Boolean.valueOf(string).booleanValue()) {
                object.add(new PDFPrint());
            }
            if ((string = xMLableReader.getAttr("isShowPDF")) != null && Boolean.valueOf(string).booleanValue()) {
                object.add(new PDF());
            }
            if ((string = xMLableReader.getAttr("isShowExcel")) != null && Boolean.valueOf(string).booleanValue()) {
                object.add(new Excel());
            }
            if ((string = xMLableReader.getAttr("isShowPrint")) != null && Boolean.valueOf(string).booleanValue()) {
                object.add(new ServerPrint());
            }
            if ((string = xMLableReader.getAttr("isShowExport")) != null && Boolean.valueOf(string).booleanValue()) {
                object.add(new Export());
            }
            if ((string = xMLableReader.getAttr("isShowEmail")) != null && Boolean.valueOf(string).booleanValue()) {
                object.add(new Email());
            }
            if (!bl) {
                BaseCoreUtils.map((List)object, new Mapper(){

                    public Object map(int n, Object object, List list) {
                        ((Button)object).setIconName(null);
                        return object;
                    }
                });
            }
            if (!bl2) {
                BaseCoreUtils.map((List)object, new Mapper(){

                    public Object map(int n, Object object, List list) {
                        ((Button)object).setText(null);
                        return object;
                    }
                });
            }
            if (object.size() > 0) {
                this.toolBar = new ToolBar(object.toArray(new Widget[object.size()]));
            }
        }
        if (xMLableReader.isChildNode()) {
            object = xMLableReader.getTagName();
            if ("ToolBar".equals(object)) {
                this.toolBar = new ToolBar();
                xMLableReader.readXMLObject(this.toolBar);
            } else if ("Location".equals(object)) {
                this.toolBarLocation = Location.readXML(xMLableReader);
            }
        }
    }

    public JSONObject toJSONConfig(Repository repository) {
        JSONObject jSONObject = new JSONObject();
        Location location = this.getToolBarLocation();
        if (location == null) {
            location = Location.createTopEmbedLocation();
        }
        if (location instanceof Location.Embed) {
            try {
                jSONObject.put("position", ((Location.Embed)location).getPosition() == 1 ? "north" : "south");
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
        } else if (this.getToolBarLocation() instanceof Location.Float) {
            int n = ((Location.Float)location).getTop();
            int n2 = ((Location.Float)location).getBottom();
            int n3 = ((Location.Float)location).getLeft();
            int n4 = ((Location.Float)location).getRight();
            try {
                JSONObject jSONObject2 = new JSONObject();
                if (n >= 0) {
                    jSONObject2.put("top", n);
                }
                if (n2 >= 0) {
                    jSONObject2.put("bottom", n2);
                }
                if (n3 >= 0) {
                    jSONObject2.put("left", n3);
                }
                if (n4 >= 0) {
                    jSONObject2.put("right", n4);
                }
                jSONObject.put("position", jSONObject2);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
        }
        try {
            jSONObject.put("toolbarConf", this.getToolBar().createJSONConfig(repository));
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public Object clone() throws CloneNotSupportedException {
        ToolBarManager toolBarManager = (ToolBarManager)super.clone();
        if (this.toolBar != null) {
            toolBarManager.toolBar = (ToolBar)this.toolBar.clone();
        }
        return toolBarManager;
    }
}

