/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web;

import com.fr.base.ArrayUtils;
import com.fr.base.XMLable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.event.Listener;
import java.util.ArrayList;
import java.util.List;

public abstract class WebContent
implements XMLable {
    public static final String EVENT_BEFORE_TO_PDF = "beforetopdf";
    public static final String EVENT_AFTER_TO_PDF = "aftertopdf";
    public static final String EVENT_BEFORE_TO_EXCEL = "beforetoexcel";
    public static final String EVENT_AFTER_TO_EXCEL = "aftertoexcel";
    public static final String EVETN_BEFORE_TO_WORD = "beforetoword";
    public static final String EVENT_AFTER_TO_WORD = "aftertoword";
    public static final String EVENT_BEFORE_PDF_PRINT = "beforepdfprint";
    public static final String EVENT_AFTER_PDF_PRINT = "afterpdfprint";
    public static final String EVENT_BEFORE_FLASH_PRINT = "beforeflashprint";
    public static final String EVENT_AFTER_FLASH_PRINT = "afterflashprint";
    public static final String EVENT_BEFORE_APPLET_PRINT = "beforeappletprint";
    public static final String EVENT_AFTER_APPLET_PRINT = "afterappletprint";
    public static final String EVENT_BEFORE_EMAIL = "beforeemail";
    public static final String EVENT_AFTER_EMAIL = "afteremail";
    protected List listenerList;
    protected ToolBarManager[] managers;

    public String[] supportedEvents() {
        return new String[]{"startload", "afterload", EVENT_BEFORE_TO_PDF, EVENT_AFTER_TO_PDF, EVENT_BEFORE_TO_EXCEL, EVENT_AFTER_TO_EXCEL, EVETN_BEFORE_TO_WORD, EVENT_AFTER_TO_WORD, EVENT_BEFORE_PDF_PRINT, EVENT_AFTER_PDF_PRINT, EVENT_BEFORE_FLASH_PRINT, EVENT_AFTER_FLASH_PRINT, EVENT_BEFORE_APPLET_PRINT, EVENT_AFTER_APPLET_PRINT};
    }

    public int getListenerSize() {
        return this.listenerList == null ? 0 : this.listenerList.size();
    }

    public Listener getListener(int n) {
        return this.listenerList == null ? null : (Listener)this.listenerList.get(n);
    }

    public void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        Object[] objectArray = this.supportedEvents();
        if (ArrayUtils.isEmpty(objectArray)) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((String)objectArray[i]).equals(listener.getName())) continue;
            if (this.listenerList == null) {
                this.listenerList = new ArrayList();
            }
            this.listenerList.add(listener);
            return;
        }
    }

    public void clearListeners() {
        if (this.listenerList != null) {
            this.listenerList.clear();
        }
    }

    public ToolBarManager[] getToolBarManagers() {
        return this.managers;
    }

    public void setToolBarManagers(ToolBarManager[] toolBarManagerArray) {
        this.managers = toolBarManagerArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.managers = null;
            this.clearListeners();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Listener")) {
                Listener listener = new Listener();
                xMLableReader.readXMLObject(listener);
                this.addListener(listener);
            } else if (string.equals("ToolBars")) {
                final ArrayList arrayList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ToolBarManager")) {
                            ToolBarManager toolBarManager = new ToolBarManager();
                            xMLableReader.readXMLObject(toolBarManager);
                            arrayList.add(toolBarManager);
                        }
                    }
                });
                this.managers = arrayList.toArray(new ToolBarManager[arrayList.size()]);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        int n2 = this.getListenerSize();
        for (n = 0; n < n2; ++n) {
            Listener listener = this.getListener(n);
            listener.writeXML(xMLPrintWriter);
        }
        if (this.managers != null) {
            xMLPrintWriter.startTAG("ToolBars");
            int n3 = n2 = this.managers == null ? 0 : this.managers.length;
            for (n = 0; n < n2; ++n) {
                this.managers[n].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        WebContent webContent = (WebContent)super.clone();
        if (this.listenerList != null) {
            webContent.listenerList = new ArrayList();
            int n2 = this.getListenerSize();
            for (n = 0; n < n2; ++n) {
                webContent.listenerList.add(this.getListener(n).clone());
            }
        }
        if (this.managers != null) {
            webContent.managers = new ToolBarManager[this.managers.length];
            for (n = 0; n < this.managers.length; ++n) {
                webContent.managers[n] = (ToolBarManager)this.managers[n].clone();
            }
        }
        return webContent;
    }
}

