/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web;

import com.fr.base.ArrayUtils;
import com.fr.base.ColumnRow;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.SynchronizedFrozenColumnRow;
import com.fr.report.web.WebContent;
import java.awt.Color;

public class WebWrite
extends WebContent {
    public static final String EVENT_BEFORE_VERIFY_WRITE = "beforeverifywrite";
    public static final String EVENT_AFTER_VERIFY_WRITE = "afterverifywrite";
    public static final String EVENT_AFTER_VERIFY = "afterverify";
    public static final String EVENT_BEFORE_WRITE = "beforewrite";
    public static final String EVENT_AFTER_WRITE = "afterwrite";
    public static final String EVENT_WRITE_SUCCESS = "writesuccess";
    public static final String EVENT_WRITE_FAILURE = "writefailure";
    public static final String EVENT_BEFORE_APPEND = "beforeappend";
    public static final String EVENT_AFTER_APPEND = "afterappend";
    public static final String EVENT_BEFORE_DELETE = "beforedelete";
    public static final String EVENT_AFTER_DELETE = "afterdelete";
    private Color selectedColor = new Color(102, 231, 255);

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public String getColor() {
        return "rgb(" + this.selectedColor.getRed() + "," + this.selectedColor.getGreen() + "," + this.selectedColor.getBlue() + ")";
    }

    public String[] supportedEvents() {
        return (String[])ArrayUtils.addAll(super.supportedEvents(), new String[]{EVENT_AFTER_VERIFY, EVENT_BEFORE_VERIFY_WRITE, EVENT_AFTER_VERIFY_WRITE, EVENT_BEFORE_WRITE, EVENT_AFTER_WRITE, EVENT_WRITE_SUCCESS, EVENT_WRITE_FAILURE, EVENT_BEFORE_APPEND, EVENT_AFTER_APPEND, EVENT_BEFORE_DELETE, EVENT_AFTER_DELETE});
    }

    public boolean equals(Object object) {
        if (!(object instanceof WebWrite)) {
            return false;
        }
        return ComparatorUtils.equals(((WebWrite)object).listenerList, this.listenerList) && ComparatorUtils.equals(((WebWrite)object).selectedColor, this.selectedColor);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("FrozenColumnRow")) {
                ColumnRow columnRow;
                String string = xMLableReader.getAttr("columnrow");
                if (string != null && ColumnRow.validate(columnRow = ColumnRow.valueOf(string))) {
                    SynchronizedFrozenColumnRow.putSynchronizedFrozenColumnRow(columnRow);
                }
            } else if (xMLableReader.getTagName().equals("SelectedColor")) {
                String string = xMLableReader.getAttr("color");
                if (string != null) {
                    this.setSelectedColor(new Color(Integer.parseInt(string), true));
                } else {
                    this.setSelectedColor(null);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("SelectedColor");
        if (this.selectedColor != null) {
            xMLPrintWriter.attr("color", this.selectedColor.getRGB());
        }
        xMLPrintWriter.end();
    }
}

