/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.event;

import com.fr.base.Nameable;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONFunction;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.json.JSONVariable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.js.JavaScript;
import com.fr.web.Repository;
import java.io.Serializable;

public class Listener
implements XMLReadable,
Serializable,
Nameable,
Cloneable {
    public static final String XML_TAG = "Listener";
    private String targetWidget;
    private String eventName;
    private boolean invokeOnce = false;
    private JavaScript action;

    public Listener() {
    }

    public boolean isDefault() {
        return false;
    }

    public Listener(String string) {
        this(string, null);
    }

    public Listener(String string, JavaScript javaScript) {
        this(string, javaScript, false);
    }

    public Listener(String string, JavaScript javaScript, boolean bl) {
        this(null, string, javaScript, bl);
    }

    public Listener(String string, String string2, JavaScript javaScript) {
        this(string, string2, javaScript, false);
    }

    public Listener(String string, String string2, JavaScript javaScript, boolean bl) {
        this.setTargetWidget(string);
        this.setName(string2);
        this.setAction(javaScript);
        this.setInvokeOnce(bl);
    }

    public String getTargetWidget() {
        return this.targetWidget;
    }

    public void setTargetWidget(String string) {
        this.targetWidget = string;
    }

    public String getName() {
        return this.eventName;
    }

    public void setName(String string) {
        this.eventName = string;
    }

    public boolean isInvokeOnce() {
        return this.invokeOnce;
    }

    public void setInvokeOnce(boolean bl) {
        this.invokeOnce = bl;
    }

    public JavaScript getAction() {
        return this.action;
    }

    public void setAction(JavaScript javaScript) {
        this.action = javaScript;
    }

    public JSONObject createJSONConfig(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String string = this.getTargetWidget();
        if (StringUtils.isNotBlank(string)) {
            jSONObject.put("target", new JSONVariable(string));
        }
        jSONObject.put("eventName", this.getName());
        jSONObject.put("once", this.isInvokeOnce());
        jSONObject.put("action", new JSONFunction(new String[]{"e"}, this.getAction().createJS(repository)));
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttr("target");
            if (string != null) {
                this.setTargetWidget(string);
            }
            if ((string = xMLableReader.getAttr("event")) != null) {
                this.setName(string);
            }
            if ((string = xMLableReader.getAttr("once")) != null) {
                this.setInvokeOnce(Boolean.valueOf(string));
            }
        }
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("JavaScript")) {
            this.setAction(ReportXMLUtils.readJavaScript(xMLableReader));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotBlank(this.getTargetWidget())) {
            xMLPrintWriter.attr("target", this.getTargetWidget());
        }
        if (StringUtils.isNotBlank(this.getName())) {
            xMLPrintWriter.attr("event", this.getName());
        }
        if (this.isInvokeOnce()) {
            xMLPrintWriter.attr("once", this.isInvokeOnce());
        }
        if (this.getAction() != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.getAction(), "JavaScript");
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        return this.action == null ? "" : this.eventName + ":" + this.action.getClass().getName();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Listener)) {
            return false;
        }
        return ComparatorUtils.equals(this.getTargetWidget(), ((Listener)object).getTargetWidget()) || ComparatorUtils.equals(this.getName(), ((Listener)object).getName()) || ComparatorUtils.equals(this.getAction(), ((Listener)object).getAction()) || this.isInvokeOnce() == ((Listener)object).isInvokeOnce();
    }

    public Object clone() throws CloneNotSupportedException {
        Listener listener = (Listener)super.clone();
        if (this.action != null) {
            listener.action = (JavaScript)this.action.clone();
        }
        return listener;
    }
}

