/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.Icon;
import com.fr.report.web.ui.Widget;
import com.fr.util.Utils;
import com.fr.web.Repository;

public class Button
extends Widget {
    public static final String EVENT_AFTERINIT = "afterinit";
    public static final String EVENT_CLICK = "click";
    protected String text;
    protected String iconName;
    protected boolean showIcon = true;
    protected boolean showText = true;
    protected String hotkeys;

    public Button() {
    }

    public Button(String string) {
        this.text = string;
    }

    public Button(String string, String string2) {
        this.text = string;
        this.iconName = string2;
    }

    public boolean getShowIcon() {
        return this.showIcon;
    }

    public void setShowIcon(boolean bl) {
        this.showIcon = bl;
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void setShowText(boolean bl) {
        this.showText = bl;
    }

    public String getHotkeys() {
        return this.hotkeys;
    }

    public void setHotkeys(String string) {
        this.hotkeys = string;
    }

    public String getXType() {
        return "button";
    }

    public boolean isEditor() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[]{EVENT_AFTERINIT, EVENT_CLICK};
    }

    public String getText() {
        return this.text;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setIconName(String string) {
        this.iconName = string;
    }

    protected JSONObject createChildConfig(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("src", this.getText());
        jSONObject.put("iconSrc", FRContext.getWidgetManager().getIconManager().getCssInfo(this.getIconName(), repository.getServletURL()));
        jSONObject.put("showIconSrc", this.getShowIcon());
        jSONObject.put("showTextSrc", this.getShowText());
        return jSONObject;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        jSONObject.put("render", true);
        if (this.text != null && this.getShowText()) {
            jSONObject.put("text", this.getText());
        } else if (object != null && this.getShowText()) {
            jSONObject.put("text", Utils.objectToString(object));
        }
        if (StringUtils.isNotEmpty(this.hotkeys)) {
            jSONObject.put("hotkeys", this.hotkeys);
        }
        if (this.iconName != null && this.getShowIcon()) {
            jSONObject.put("icon", FRContext.getWidgetManager().getIconManager().getCssInfo(this.iconName, repository.getServletURL()));
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Text")) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.setText(string3);
                }
            } else if (string2.equals("Hotkeys")) {
                String string4 = xMLableReader.getElementValue();
                if (string4 != null) {
                    this.setHotkeys(string4);
                }
            } else if (string2.equals("ShowIcon")) {
                String string5 = xMLableReader.getElementValue();
                if (string5 != null) {
                    this.setShowIcon(new Boolean(string5));
                }
            } else if (string2.equals("ShowText")) {
                String string6 = xMLableReader.getElementValue();
                if (string6 != null) {
                    this.setShowText(new Boolean(string6));
                }
            } else if (string2.equals("IconName")) {
                String string7 = xMLableReader.getElementValue();
                if (string7 != null) {
                    this.setIconName(string7);
                }
            } else if (Icon.XML_TAG.equals(string2) && (string = xMLableReader.getAttr("name")) != null) {
                this.setIconName(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.text)) {
            xMLPrintWriter.startTAG("Text").textNode(this.text).end();
        }
        if (StringUtils.isNotBlank(this.hotkeys)) {
            xMLPrintWriter.startTAG("Hotkeys").textNode(this.hotkeys).end();
        }
        if (!this.showIcon) {
            xMLPrintWriter.startTAG("ShowIcon").textNode(String.valueOf(this.showIcon)).end();
        }
        if (!this.showText) {
            xMLPrintWriter.startTAG("ShowText").textNode(String.valueOf(this.showText)).end();
        }
        if (this.iconName != null) {
            xMLPrintWriter.startTAG("IconName").textNode(String.valueOf(this.iconName)).end();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Button)) {
            return false;
        }
        Button button = (Button)object;
        return super.equals(object) && ComparatorUtils.equals(this.getText(), button.getText()) && ComparatorUtils.equals(this.getIconName(), button.getIconName()) && this.getShowIcon() == button.getShowIcon() && this.getShowText() == button.getShowText() && ComparatorUtils.equals(this.hotkeys, button.getHotkeys());
    }

    public Object clone() throws CloneNotSupportedException {
        Button button = (Button)super.clone();
        return button;
    }
}

