/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.web.ui.WriteUnableRepeatEditor;
import com.fr.web.Repository;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.WidgetService;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class CheckBoxGroup
extends WriteUnableRepeatEditor {
    public static final String STATECHANGE = "statechange";
    private Dictionary mvList;
    private String delimiter = ",";
    private String startSymbol = "";
    private String endSymbol = "";
    private boolean returnArray = true;

    public String getXType() {
        return "checkboxgroup";
    }

    public boolean isEditor() {
        return false;
    }

    public void setDictionary(Dictionary dictionary) {
        this.mvList = dictionary;
    }

    public Dictionary getDictionary() {
        return this.mvList;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public String getStartSymbol() {
        return this.startSymbol;
    }

    public void setStartSymbol(String string) {
        this.startSymbol = string;
    }

    public String getEndSymbol() {
        return this.endSymbol;
    }

    public void setEndSymbol(String string) {
        this.endSymbol = string;
    }

    public boolean isReturnArray() {
        return this.returnArray;
    }

    public void setReturnArray(boolean bl) {
        this.returnArray = bl;
    }

    public String[] dependence() {
        return this.mvList == null ? new String[]{} : this.mvList.getDependence();
    }

    public String[] supportedEvents() {
        return (String[])ArrayUtils.addAll(super.supportedEvents(), new String[]{STATECHANGE});
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        if (this.mvList == null) {
            return jSONArray;
        }
        calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
        calculator.pushNameSpace(new WidgetService.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
        this.mvList.reset();
        Iterator iterator = this.mvList.entrys(calculator);
        ArrayList<Dictionary.MV> arrayList = new ArrayList<Dictionary.MV>();
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            String string = WidgetService.toJSONString(mV.getModel(), httpServletRequest);
            String string2 = WidgetService.toJSONString(mV.getView(), httpServletRequest);
            if (!StringUtils.isNotEmpty(string2)) continue;
            if (this.isRemoveRepeat()) {
                if (arrayList.contains(mV)) continue;
                jSONArray.put(new JSONObject().put("value", string).put("text", string2));
                arrayList.add(mV);
                continue;
            }
            jSONArray.put(new JSONObject().put("value", string).put("text", string2));
        }
        return jSONArray;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        if (this.returnArray) {
            jSONObject.put("returnArray", true);
        }
        if (!ComparatorUtils.equals(this.delimiter, ",")) {
            jSONObject.put("delimiter", this.delimiter);
        }
        if (!StringUtils.isEmpty(this.startSymbol)) {
            jSONObject.put("startSymbol", this.startSymbol);
        }
        if (!StringUtils.isEmpty(this.endSymbol)) {
            jSONObject.put("endSymbol", this.endSymbol);
        }
        if (!ArrayUtils.isEmpty(this.dependence())) {
            jSONObject.put("dependence", this.dependence());
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Dictionary")) {
                this.mvList = DataXMLUtils.readXMLDictionary(xMLableReader);
            }
            if (xMLableReader.getTagName().equals("RAAttr")) {
                this.returnArray = false;
                if (xMLableReader.getAttr("delimiter") != null) {
                    this.delimiter = xMLableReader.getAttr("delimiter");
                }
                if (xMLableReader.getAttr("start") != null) {
                    this.startSymbol = xMLableReader.getAttr("start");
                }
                if (xMLableReader.getAttr("end") != null) {
                    this.endSymbol = xMLableReader.getAttr("end");
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.mvList != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.mvList, "Dictionary");
        }
        if (!this.returnArray) {
            xMLPrintWriter.startTAG("RAAttr").attr("isArray", this.returnArray);
            if (!",".equals(this.delimiter)) {
                xMLPrintWriter.attr("delimiter", this.delimiter);
            }
            if (!StringUtils.isEmpty(this.startSymbol)) {
                xMLPrintWriter.attr("start", this.startSymbol);
            }
            if (!StringUtils.isEmpty(this.endSymbol)) {
                xMLPrintWriter.attr("end", this.endSymbol);
            }
            xMLPrintWriter.end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof CheckBoxGroup && super.equals(object) && ComparatorUtils.equals(this.mvList, ((CheckBoxGroup)object).mvList) && ComparatorUtils.equals(this.delimiter, ((CheckBoxGroup)object).delimiter) && this.returnArray == ((CheckBoxGroup)object).returnArray && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        CheckBoxGroup checkBoxGroup = (CheckBoxGroup)super.clone();
        if (this.mvList != null) {
            checkBoxGroup.mvList = (Dictionary)this.mvList.clone();
        }
        return checkBoxGroup;
    }
}

