/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.web.ui.WriteAbleRepeatEditor;
import com.fr.web.Repository;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.WidgetService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ComboBox
extends WriteAbleRepeatEditor {
    private Dictionary mvList;

    public String getXType() {
        return "combo";
    }

    public void setDictionary(Dictionary dictionary) {
        this.mvList = dictionary;
    }

    public Dictionary getDictionary() {
        return this.mvList;
    }

    public String[] dependence() {
        return this.mvList == null ? new String[]{} : this.mvList.getDependence();
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        if (this.mvList == null) {
            return jSONArray;
        }
        calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
        calculator.pushNameSpace(new WidgetService.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "filter");
        this.mvList.reset();
        Iterator iterator = this.mvList.entrys(calculator);
        ArrayList<Dictionary.MV> arrayList = new ArrayList<Dictionary.MV>();
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            String string2 = WidgetService.toJSONString(mV.getModel(), httpServletRequest);
            String string3 = WidgetService.toJSONString(mV.getView(), httpServletRequest);
            if (string != null && string2.toUpperCase().indexOf(string.toUpperCase()) == -1 && string3.toUpperCase().indexOf(string.toUpperCase()) == -1 || !StringUtils.isNotEmpty(string3)) continue;
            if (this.isRemoveRepeat()) {
                if (arrayList.contains(mV)) continue;
                jSONArray.put(new JSONObject().put("value", string2).put("text", string3));
                arrayList.add(mV);
                continue;
            }
            jSONArray.put(new JSONObject().put("value", string2).put("text", string3));
        }
        return jSONArray;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        try {
            jSONObject.put("editable", this.isEditable()).put("autoMode", true);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        jSONObject.put("mode", "remote");
        Object[] objectArray = this.dependence();
        if (!ArrayUtils.isEmpty(objectArray)) {
            jSONObject.put("dependence", objectArray);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Dictionary") || string.equals("MVList")) {
                this.mvList = DataXMLUtils.readXMLDictionary(xMLableReader);
            } else if ("Dict".equals(string)) {
                this.mvList = DataXMLUtils.readXMLDictionary(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.mvList != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.mvList, "Dictionary");
        }
    }

    public boolean equals(Object object) {
        return object instanceof ComboBox && super.equals(object) && ComparatorUtils.equals(this.mvList, ((ComboBox)object).mvList);
    }

    public Object clone() throws CloneNotSupportedException {
        ComboBox comboBox = (ComboBox)super.clone();
        if (this.mvList != null) {
            comboBox.mvList = (Dictionary)this.mvList.clone();
        }
        return comboBox;
    }
}

