/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.Button;
import com.fr.web.Repository;

public class CustomButton
extends Button {
    private String prefix = "x-btn";

    public String getXType() {
        return "custombutton";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "click"};
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        if (StringUtils.isNotBlank(this.prefix)) {
            jSONObject.put("prefix", this.getPrefix());
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string2 = xMLableReader.getTagName()).equals("Prefix") && (string = xMLableReader.getElementValue()) != null) {
            this.setPrefix(string);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.prefix) && !"x-btn".equals(this.prefix)) {
            xMLPrintWriter.startTAG("Prefix").textNode(this.prefix).end();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CustomButton)) {
            return false;
        }
        CustomButton customButton = (CustomButton)object;
        return super.equals(object) && ComparatorUtils.equals(this.getPrefix(), customButton.getPrefix());
    }

    public Object clone() throws CloneNotSupportedException {
        CustomButton customButton = (CustomButton)super.clone();
        return customButton;
    }
}

