/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.AbstractWidgetConfig;
import com.fr.report.web.ui.Widget;
import com.fr.web.Repository;

public class CustomWidgetConfig
extends AbstractWidgetConfig {
    public static final String XML_TAG = "CWC";
    private String xType;
    private String jsPath;
    private String cssPath;

    public CustomWidgetConfig() {
    }

    public CustomWidgetConfig(String string) {
        this.xType = string;
    }

    public String getWidgetType() {
        return this.xType;
    }

    public void setWidgetType(String string) {
        this.xType = string;
    }

    public String getJSPath() {
        return this.jsPath;
    }

    public void setJSPath(String string) {
        this.jsPath = string;
    }

    public String getCssPath() {
        return this.cssPath;
    }

    public void setCssPath(String string) {
        this.cssPath = string;
    }

    public Widget toWidget() {
        return new Widget(){

            public String getXType() {
                return CustomWidgetConfig.this.xType;
            }

            public boolean isEditor() {
                return true;
            }

            public String[] supportedEvents() {
                return new String[0];
            }

            public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
                JSONObject jSONObject = super.createJSONConfig(object, repository);
                if (!StringUtils.isBlank(CustomWidgetConfig.this.jsPath)) {
                    jSONObject.put("jspath", CustomWidgetConfig.this.jsPath);
                }
                if (!StringUtils.isBlank(CustomWidgetConfig.this.cssPath)) {
                    jSONObject.put("csspath", CustomWidgetConfig.this.cssPath);
                }
                return jSONObject;
            }
        };
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            String string2 = xMLableReader.getAttr("jsPath");
            if (string2 != null) {
                this.jsPath = string2;
            }
            if ((string2 = xMLableReader.getAttr("cssPath")) != null) {
                this.cssPath = string2;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotEmpty(this.jsPath) || StringUtils.isNotEmpty(this.cssPath)) {
            xMLPrintWriter.startTAG(XML_TAG);
            if (StringUtils.isNotEmpty(this.jsPath)) {
                xMLPrintWriter.attr("jsPath", this.jsPath);
            }
            if (StringUtils.isNotEmpty(this.cssPath)) {
                xMLPrintWriter.attr("cssPath", this.cssPath);
            }
            xMLPrintWriter.end();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof CustomWidgetConfig)) {
            return false;
        }
        return ComparatorUtils.equals(((CustomWidgetConfig)object).jsPath, this.jsPath) && ComparatorUtils.equals(((CustomWidgetConfig)object).cssPath, this.cssPath) && ComparatorUtils.equals(((CustomWidgetConfig)object).xType, this.xType);
    }
}

