/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.DirectWriteEditor;
import com.fr.web.Repository;
import java.util.Date;

public class DateEditor
extends DirectWriteEditor {
    private String startDate;
    private String endDate;
    private String formatText = "yyyy-MM-dd";
    private boolean returnDate = false;

    public String getXType() {
        return "datetime";
    }

    public String getFormatText() {
        return this.formatText;
    }

    public void setFormatText(String string) {
        this.formatText = string;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String string) {
        this.startDate = string;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String string) {
        this.endDate = string;
    }

    public boolean isReturnDate() {
        return this.returnDate;
    }

    public void setReturnDate(boolean bl) {
        this.returnDate = bl;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        if (this.formatText != null) {
            jSONObject.put("format", this.formatText);
        }
        if (this.startDate != null) {
            jSONObject.put("startDate", this.value2Config(this.startDate));
        }
        if (this.endDate != null) {
            jSONObject.put("endDate", this.value2Config(this.endDate));
        }
        if (this.returnDate) {
            jSONObject.put("returnDate", true);
        }
        return jSONObject;
    }

    protected Object value2Config(Object object) {
        String string = object instanceof Date ? DateUtils.DATEFORMAT1.format((Date)object) : (object == null ? "" : object.toString());
        return string;
    }

    public String[] supportedEvents() {
        return new String[]{"afteredit"};
    }

    public boolean equals(Object object) {
        return object instanceof DateEditor && super.equals(object) && ComparatorUtils.equals(this.startDate, ((DateEditor)object).startDate) && ComparatorUtils.equals(this.endDate, ((DateEditor)object).endDate) && this.returnDate == ((DateEditor)object).returnDate;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            if (xMLableReader.getTagName().equals("DateAttr")) {
                string = null;
                string = xMLableReader.getAttr("format");
                if (string != null) {
                    this.setFormatText(string);
                }
                if ((string = xMLableReader.getAttr("start")) != null) {
                    this.startDate = string;
                }
                if ((string = xMLableReader.getAttr("end")) != null) {
                    this.endDate = string;
                }
                if ((string = xMLableReader.getAttr("returnDate")) != null) {
                    this.returnDate = true;
                }
            }
            if (xMLableReader.getTagName().equals("Attribute")) {
                string = null;
                string = xMLableReader.getAttr("format");
                if (string != null) {
                    this.setFormatText(string);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("DateAttr");
        if (!ComparatorUtils.equals(this.getFormatText(), "yyyy-MM-dd")) {
            xMLPrintWriter.attr("format", this.getFormatText());
        }
        if (this.startDate != null) {
            xMLPrintWriter.attr("start", this.startDate);
        }
        if (this.endDate != null) {
            xMLPrintWriter.attr("end", this.endDate);
        }
        if (this.returnDate) {
            xMLPrintWriter.attr("returnDate", this.returnDate);
        }
        xMLPrintWriter.end();
    }
}

