/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.FieldEditor;
import com.fr.web.Repository;

public abstract class DirectWriteEditor
extends FieldEditor {
    public static final String CLICK = "click";
    public static final String AFTERINIT = "afterinit";
    protected boolean editable = true;

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public String[] supportedEvents() {
        return (String[])ArrayUtils.addAll(super.supportedEvents(), new String[]{CLICK, AFTERINIT});
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        jSONObject.put("editable", (Object)this.editable);
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Editable")) {
            this.editable = Boolean.valueOf(xMLableReader.getElementValue());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!this.editable) {
            xMLPrintWriter.startTAG("Editable").textNode(String.valueOf(this.editable)).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof DirectWriteEditor && super.equals(object) && this.editable == ((DirectWriteEditor)object).editable;
    }
}

