/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.Widget;
import com.fr.web.Repository;

public abstract class FieldEditor
extends Widget {
    public static final String BEFOREEDIT = "beforeedit";
    public static final String AFTEREDIT = "afteredit";
    public static final String STOPEDIT = "stopedit";
    protected String fieldName;
    protected boolean allowBlank = true;
    protected String errorMessage = "";

    public String getFieldName() {
        return this.widgetName;
    }

    public void setFieldName(String string) {
        this.widgetName = string;
    }

    public boolean isAllowBlank() {
        return this.allowBlank;
    }

    public void setAllowBlank(boolean bl) {
        this.allowBlank = bl;
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? "" : this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public boolean isEditor() {
        return true;
    }

    public String[] dependence() {
        return new String[0];
    }

    public String[] supportedEvents() {
        return new String[]{BEFOREEDIT, AFTEREDIT, STOPEDIT};
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        if (StringUtils.isNotBlank(this.fieldName)) {
            jSONObject.put("fieldName", this.fieldName);
        }
        if (StringUtils.isNotBlank(this.errorMessage)) {
            jSONObject.put("errorMsg", this.errorMessage);
        }
        if (!this.allowBlank) {
            jSONObject.put("allowBlank", this.allowBlank);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("FieldName")) {
                this.setWidgetName(xMLableReader.getElementValue());
            }
            if (xMLableReader.getTagName().equals("EMSG")) {
                this.errorMessage = xMLableReader.getElementValue();
            }
            if (xMLableReader.getTagName().equals("allowBlank")) {
                this.allowBlank = false;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.errorMessage)) {
            xMLPrintWriter.startTAG("EMSG").textNode(this.errorMessage).end();
        }
        if (!this.allowBlank) {
            xMLPrintWriter.startTAG("allowBlank").textNode(String.valueOf(this.allowBlank)).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof FieldEditor && super.equals(object) && ComparatorUtils.equals(this.errorMessage, ((FieldEditor)object).errorMessage) && this.allowBlank == ((FieldEditor)object).allowBlank;
    }

    public String toString() {
        return StringUtils.isEmpty(this.fieldName) ? super.toString() : "$" + this.fieldName;
    }
}

