/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.FieldEditor;
import com.fr.web.Repository;

public class FileEditor
extends FieldEditor {
    public static final String EVENT_UPLOAD_CALLBACK = "callback";
    private boolean autoUpload = true;
    private String url;
    private String allowTypes;

    public boolean isAutoUpload() {
        return this.autoUpload;
    }

    public void setAutoUpload(boolean bl) {
        this.autoUpload = bl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getAllowTypes() {
        return this.allowTypes;
    }

    public void setAllowTypes(String string) {
        this.allowTypes = string;
    }

    public String getXType() {
        return "file";
    }

    public String[] supportedEvents() {
        Object[] objectArray = new String[]{EVENT_UPLOAD_CALLBACK};
        return (String[])ArrayUtils.addAll(super.supportedEvents(), objectArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileEditor)) {
            return false;
        }
        return ComparatorUtils.equals(((FileEditor)object).url, this.url);
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        if (!this.autoUpload) {
            jSONObject.put("autoUpload", false);
        }
        if (!StringUtils.isBlank(this.url)) {
            jSONObject.put("url", this.url);
        }
        if (!StringUtils.isEmpty(this.allowTypes)) {
            jSONObject.put("allowTypes", this.allowTypes);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("FileAttr")) {
            String string = null;
            string = xMLableReader.getAttr("url");
            if (string != null) {
                this.setUrl(string);
            }
            if ((string = xMLableReader.getAttr("autoUpload")) != null) {
                this.setAutoUpload(false);
            }
            if ((string = xMLableReader.getAttr("allowTypes")) != null) {
                this.setAllowTypes(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("FileAttr");
        if (this.url != null) {
            xMLPrintWriter.attr("url", this.url);
        }
        if (!this.autoUpload) {
            xMLPrintWriter.attr("autoUpload", this.autoUpload);
        }
        if (!StringUtils.isEmpty(this.allowTypes)) {
            xMLPrintWriter.attr("allowTypes", this.allowTypes);
        }
        xMLPrintWriter.end();
    }
}

