/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.BaseUtils;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.util.ListMap;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.Icon;
import com.fr.web.Browser;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IconManager
implements XMLable {
    public static final String XML_TAG = "IM";
    private static ListMap iconMap = new ListMap();
    private static List systemIconList = new ArrayList();
    public static final Icon SUBMIT = IconManager.getDefaultIcon("submit", "/com/fr/web/images/save.png");
    public static final Icon SUBMITFORCILY = IconManager.getDefaultIcon("submitforcily", "/com/fr/web/images/save2.png");
    public static final Icon FIRST = IconManager.getDefaultIcon("first", "/com/fr/web/images/first.png");
    public static final Icon PREVIOUS = IconManager.getDefaultIcon("previous", "/com/fr/web/images/previous.png");
    public static final Icon NEXT = IconManager.getDefaultIcon("next", "/com/fr/web/images/next.png");
    public static final Icon LAST = IconManager.getDefaultIcon("last", "/com/fr/web/images/last.png");
    public static final Icon RELOAD = IconManager.getDefaultIcon("reload", "/com/fr/web/images/reload.png");
    public static final Icon PAGESETUP = IconManager.getDefaultIcon("pagesetup", "/com/fr/web/images/pageSetup.png");
    public static final Icon FLASHPRINT = IconManager.getDefaultIcon("flashprint", "/com/fr/web/images/flashPrint.png");
    public static final Icon PDFPRINT = IconManager.getDefaultIcon("pdfprint", "/com/fr/web/images/pdfPrint.png");
    public static final Icon APPLETPRINT = IconManager.getDefaultIcon("appletprint", "/com/fr/web/images/appletPrint.png");
    public static final Icon PDF = IconManager.getDefaultIcon("pdf", "/com/fr/web/images/pdf.png");
    public static final Icon EXCEL = IconManager.getDefaultIcon("excel", "/com/fr/web/images/excel.png");
    public static final Icon WORD = IconManager.getDefaultIcon("word", "/com/fr/web/images/word.png");
    public static final Icon PRINT = IconManager.getDefaultIcon("print", "/com/fr/web/images/print.png");
    public static final Icon EXPORT = IconManager.getDefaultIcon("export", "/com/fr/web/images/export.png");
    public static final Icon EMAIL = IconManager.getDefaultIcon("email", "/com/fr/web/images/email.png");
    public static final Icon FROZEN = IconManager.getDefaultIcon("frozzen", "/com/fr/web/images/frozen.png");
    public static final Icon DEFAULT = IconManager.getDefaultIcon("default", "/com/fr/web/images/default.png");
    public static final Icon DELETECOLUMN = IconManager.getDefaultIcon("deletecolumn", "/com/fr/web/images/deleteColumn.png");
    public static final Icon DELETEROW = IconManager.getDefaultIcon("deleterow", "/com/fr/web/images/deleteRow.png");
    public static final Icon APPENDCOLUMN = IconManager.getDefaultIcon("appendcolumn", "/com/fr/web/images/appendColumn.png");
    public static final Icon APPENDROW = IconManager.getDefaultIcon("appendrow", "/com/fr/web/images/appendRow.png");
    public static final Icon VERIFY = IconManager.getDefaultIcon("verify", "/com/fr/web/images/verify.gif");
    public static final Icon ADD = IconManager.getDefaultIcon("add", "/com/fr/web/images/add.png");
    public static final Icon DELETE = IconManager.getDefaultIcon("delete", "/com/fr/web/images/delete.png");
    public static final Icon OK = IconManager.getDefaultIcon("ok", "/com/fr/web/images/ok.png");
    public static final Icon PREVIEW = IconManager.getDefaultIcon("preview", "/com/fr/web/images/preview.png");
    public static final Icon EDIT = IconManager.getDefaultIcon("edit", "/com/fr/web/images/edit.png");
    private static final String ICONCLASSNAME = "x-emb-";
    private IconInfo[] iis = null;
    private byte[] allInOneImageBytes = null;
    private Map iconImageBytesCacheMap = new HashMap();
    private StringBuffer iconCss = new StringBuffer();
    private StringBuffer iconCss2 = new StringBuffer();
    private int mark4Init = 0;
    public static final int DEFAULT_ICONWIDTH = 16;
    public static final int DEFAULT_ICONHEIGHT = 16;
    public static final String ICONRESOURCE = "icon_name_";
    private static final int spacing = 2;

    private static Icon getDefaultIcon(String string, String string2) {
        string = string.toLowerCase();
        Icon icon = new Icon(string, string2);
        iconMap.put(string, icon);
        systemIconList.add(string);
        return icon;
    }

    private void init4Image() {
        Rectangle rectangle;
        Object object;
        Image image = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.iis = new IconInfo[iconMap.size()];
        ImageInfo[] imageInfoArray = new ImageInfo[iconMap.size()];
        for (int i = 0; i < iconMap.size(); ++i) {
            Icon icon = (Icon)iconMap.getByIndex(i);
            String string = icon.getPath();
            String string2 = icon.getName();
            if (StringUtils.isBlank(string2)) continue;
            if (this.isSystemIcon(string2)) {
                if (!string.startsWith("/") && !string.startsWith("\\")) {
                    string = File.separator + string;
                }
                image = BaseUtils.readImage(string);
                icon.setImage(image);
            } else {
                image = icon.getImage();
                if (image != null) {
                    string = ICONRESOURCE + string2;
                }
            }
            this.iis[i] = new IconInfo(string2, ICONRESOURCE + string2, null);
            if (image != null) {
                n3 = image.getWidth(null);
                n3 = n3 > -1 ? n3 : 16;
                n4 = image.getHeight(null);
                n4 = n4 > -1 ? n4 : 16;
                object = new Rectangle(0, n2, n3, n4);
                n2 += n4 + 2;
                n = n > n3 ? n : n3;
                imageInfoArray[i] = new ImageInfo(image, (Rectangle)object);
                continue;
            }
            imageInfoArray[i] = null;
        }
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2);
        object = bufferedImage.createGraphics();
        for (int i = 0; i < this.iis.length; ++i) {
            if (imageInfoArray[i] == null) continue;
            rectangle = imageInfoArray[i].getRectangle();
            image = imageInfoArray[i].getImage();
            Shape shape = ((Graphics)object).getClip();
            ((Graphics2D)object).clip(rectangle);
            ((Graphics)object).drawImage(image, rectangle.x, rectangle.y, null);
            ((Graphics)object).setClip(shape);
        }
        bufferedImage.flush();
        ((Graphics)object).dispose();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BaseUtils.writeImage(bufferedImage, "png", byteArrayOutputStream);
        this.allInOneImageBytes = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < this.iis.length; ++i) {
            if (imageInfoArray[i] == null || this.iis[i] == null) continue;
            rectangle = imageInfoArray[i].getRectangle();
            this.iis[i].setCss(rectangle.x + "px " + "-" + rectangle.y + "px");
        }
    }

    private void init4Css(String string) {
        for (int i = 0; i < this.iis.length; ++i) {
            if (this.iis[i] == null || this.iis[i].getCss() == null) continue;
            this.iconCss.append(".").append(ICONCLASSNAME).append(this.iis[i].getName()).append("{background:").append("url(").append(this.getAllInOneImageUrl(string)).append(") ").append("no-repeat ").append(this.iis[i].getCss()).append(";}\n");
            this.iconCss2.append(".").append(ICONCLASSNAME).append(this.iis[i].getName()).append("{\n").append("filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(this.getAllInOneImagePath(string, this.iis[i].getPath())).append("');\n}\n");
        }
    }

    public String getCssInfo(String string, String string2) {
        if (string == null) {
            return "";
        }
        string = string.toLowerCase();
        this.checkInit(string2);
        if (this.iis != null) {
            for (int i = 0; i < this.iis.length; ++i) {
                if (this.iis[i] == null || this.iis[i].getName() == null || !this.iis[i].getName().equals(string)) continue;
                return "css:" + ICONCLASSNAME + this.iis[i].getName();
            }
        }
        return "";
    }

    private void checkInit(String string) {
        if (this.mark4Init <= 0) {
            this.init4Image();
            if (StringUtils.isNotBlank(string)) {
                this.init4Css(string);
                this.mark4Init = 1;
            }
        }
    }

    public String getCssFile(String string, Browser browser) {
        this.checkInit(string);
        if (browser.supportTransparentImage()) {
            return this.iconCss.toString();
        }
        return this.iconCss2.toString();
    }

    public byte[] getAllInOneImageBytes(String string) {
        this.checkInit(string);
        if (this.allInOneImageBytes != null) {
            return this.allInOneImageBytes;
        }
        return new byte[0];
    }

    public byte[] getIconImage4Web(String string, String string2) {
        this.checkInit(string);
        String string3 = string2.substring(ICONRESOURCE.length());
        if (string3 == null) {
            return new byte[0];
        }
        if (this.iconImageBytesCacheMap.containsKey(string3 = string3.toLowerCase())) {
            return (byte[])this.iconImageBytesCacheMap.get(string3);
        }
        Image image = this.getIconImage(string3);
        if (image != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BaseUtils.writeImage(image, "png", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.iconImageBytesCacheMap.put(string3, byArray);
            return byArray;
        }
        return new byte[0];
    }

    private String getAllInOneImageUrl(String string) {
        return string + "?op=attach_image&id=toolbar-image.png";
    }

    private String getAllInOneImagePath(String string, String string2) {
        return string + "?op=attach_image&id=" + string2;
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        return iconMap.containsKey(string);
    }

    public boolean addIcon(Icon icon, boolean bl) {
        if (icon == null || StringUtils.isBlank(icon.getName()) || icon.getImage() == null) {
            return false;
        }
        String string = icon.getName().toLowerCase();
        icon.setName(string);
        if (iconMap.containsKey(string) && !bl) {
            return false;
        }
        iconMap.put(string, icon);
        this.mark4Init = 0;
        return true;
    }

    public boolean removeIcon(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        if (iconMap.remove(string = string.toLowerCase()) != null) {
            this.mark4Init = 0;
            return true;
        }
        return false;
    }

    public int getIconCount() {
        return iconMap.size();
    }

    public boolean isSystemIcon(String string) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        return systemIconList.contains(string);
    }

    public Image getIconImage(String string) {
        Image image;
        if (string == null) {
            return null;
        }
        Icon icon = this.getIcon4Self(string = string.toLowerCase());
        if (icon == null) {
            return null;
        }
        if (icon.getImage() != null) {
            image = icon.getImage();
        } else {
            String string2 = icon.getPath();
            if (StringUtils.isBlank(string2)) {
                return null;
            }
            if (!string2.startsWith("/") && !string2.startsWith("\\")) {
                string2 = File.separator + string2;
            }
            image = BaseUtils.readImage(string2);
            icon.setImage(image);
        }
        return image;
    }

    public Icon getIcon(Object object) throws CloneNotSupportedException {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        String string = ((String)object).toLowerCase();
        return (Icon)((Icon)iconMap.get(string)).clone();
    }

    private Icon getIcon4Self(Object object) {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        String string = ((String)object).toLowerCase();
        return (Icon)iconMap.get(string);
    }

    public Object[] getIconNames() {
        return iconMap.keySet().toArray();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            Icon icon = new Icon();
            if (Icon.XML_TAG.equals(string)) {
                xMLableReader.readXMLObject(icon);
            }
            this.addIcon(icon, false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (iconMap != null && iconMap.size() > 0) {
            for (int i = 0; i < iconMap.size(); ++i) {
                Icon icon = (Icon)iconMap.getByIndex(i);
                if (this.isSystemIcon(icon.getName())) continue;
                icon.writeXML(xMLPrintWriter);
            }
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        IconManager iconManager = (IconManager)super.clone();
        return iconManager;
    }

    private static class ImageInfo {
        private Image image;
        private Rectangle rectangle;

        public ImageInfo(Image image, Rectangle rectangle) {
            this.setImage(image);
            this.setRectangle(rectangle);
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Rectangle getRectangle() {
            return this.rectangle;
        }

        public void setRectangle(Rectangle rectangle) {
            this.rectangle = rectangle;
        }
    }

    private static class IconInfo {
        private String name;
        private String path;
        private String css;

        public IconInfo(String string, String string2, String string3) {
            this.setName(string);
            this.setPath(string2);
            this.setCss(string3);
        }

        public String getCss() {
            return this.css;
        }

        public void setCss(String string) {
            this.css = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }
    }
}

