/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.cellElement.Formula;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.web.ui.FieldEditor;
import com.fr.web.Repository;
import com.fr.web.core.SessionIDInfor;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class IframeEditor
extends FieldEditor {
    public static final String XML_TAG = "Iframe";
    private String src;
    private Parameter[] parameters;

    public IframeEditor() {
    }

    public IframeEditor(String string) {
        this.src = string;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String string) {
        this.src = string;
    }

    public Parameter[] getParameters() {
        return this.parameters == null ? new Parameter[]{} : this.parameters;
    }

    public void setParameters(Parameter[] parameterArray) {
        this.parameters = parameterArray;
    }

    public String getXType() {
        return "iframe";
    }

    public String[] supportedEvents() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
        for (int i = 0; i < (this.parameters == null ? 0 : this.parameters.length); ++i) {
            Object object;
            Object object2 = this.parameters[i].getValue();
            if (object2 instanceof Formula) {
                object = ((Formula)object2).getContent();
                object2 = calculator.eval((String)object);
            }
            object = new JSONObject().put(this.parameters[i].getName(), object2);
            jSONArray.put(object);
        }
        return jSONArray;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        if (StringUtils.isNotBlank(this.src)) {
            try {
                jSONObject.put("src", TemplateUtils.render(this.src, repository.checkoutTplContext()));
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals(XML_TAG)) {
                this.src = xMLableReader.getAttr("src");
            } else if ("Parameters".equals(xMLableReader.getTagName())) {
                Parameter[] parameterArray = ReportXMLUtils.readParameters(xMLableReader);
                this.setParameters(parameterArray);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.src)) {
            xMLPrintWriter.startTAG(XML_TAG).attr("src", this.src).end();
        }
        ReportXMLUtils.writeParameters(xMLPrintWriter, this.getParameters());
    }

    public boolean equals(Object object) {
        return object instanceof IframeEditor && super.equals(object) && ComparatorUtils.equals(this.src, ((IframeEditor)object).src) && ComparatorUtils.equals(this.parameters, ((IframeEditor)object).parameters);
    }
}

